/*
 * Decompiled with CFR 0.152.
 */
package com.agilemind.spyglass.data.compare;

import com.agilemind.commons.application.controllers.ApplicationControllerImpl;
import com.agilemind.commons.application.controllers.ProjectPanelController;
import com.agilemind.commons.application.controllers.ProjectsTabController;
import com.agilemind.commons.application.data.IProjectLocation;
import com.agilemind.commons.application.data.TroubleType;
import com.agilemind.commons.application.modules.storage.dropbox.exceptions.DropboxException;
import com.agilemind.commons.application.modules.storage.dropbox.exceptions.DropboxFileNotFoundException;
import com.agilemind.commons.application.modules.storage.dropbox.exceptions.WrongAuthorizationException;
import com.agilemind.commons.application.modules.storage.spscloud.client.exceptions.SpsCloudServerException;
import com.agilemind.commons.application.modules.storage.spscloud.client.projects.exceptions.ProjectNotFoundException;
import com.agilemind.commons.application.util.ProjectCorruptException;
import com.agilemind.commons.application.util.ProjectLoaderSaverManager;
import com.agilemind.commons.modules.storage.StorageType;
import com.agilemind.commons.mvc.controllers.ProviderFinder;
import com.agilemind.commons.util.ThreadSafeUtil;
import com.agilemind.commons.util.errorproof.ExecuteAndReturn;
import com.agilemind.spyglass.data.CompareProject;
import com.agilemind.spyglass.data.CompareProjectsList;
import com.agilemind.spyglass.data.ICompareProject;
import com.agilemind.spyglass.data.SpyGlassProject;
import com.agilemind.spyglass.data.compare.CompareProjectResult;
import com.agilemind.spyglass.data.compare.CompareResult;
import com.agilemind.spyglass.data.compare.g;
import com.agilemind.spyglass.data.compare.o;
import java.awt.Color;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.SwingUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompareProjectsManager {
    private ProviderFinder a;
    private List<CompareProjectResult<CompareProject>> b;
    private CompareProjectsList c;
    private final Map<ICompareProject, SpyGlassProject> d = new HashMap<ICompareProject, SpyGlassProject>();
    private static final Logger e = LoggerFactory.getLogger(CompareProjectsManager.class);

    public CompareProjectsManager(ProviderFinder providerFinder, CompareProjectsManager compareProjectsManager) {
        this.a = providerFinder;
        this.b = new ArrayList<CompareProjectResult<CompareProject>>();
        this.c = compareProjectsManager.c;
        this.copyFrom(compareProjectsManager);
    }

    public void fixUnsaved() {
        boolean bl = CompareResult.d;
        for (CompareProjectResult<CompareProject> compareProjectResult : this.b) {
            SpyGlassProject spyGlassProject = this.d.get(compareProjectResult.getCompareProject());
            if (spyGlassProject != null && spyGlassProject.getProjectLocation() != null) {
                compareProjectResult.setUnsaved(false);
            }
            if (!bl) continue;
        }
    }

    public CompareProjectsManager(ProviderFinder providerFinder, CompareProjectsList compareProjectsList) {
        this.a = providerFinder;
        this.c = compareProjectsList;
        this.b = this.a(compareProjectsList);
    }

    private List<CompareProjectResult<CompareProject>> a(CompareProjectsList compareProjectsList) {
        boolean bl = CompareResult.d;
        ArrayList<CompareProjectResult<CompareProject>> arrayList = new ArrayList<CompareProjectResult<CompareProject>>();
        for (CompareProject compareProject : compareProjectsList.getList()) {
            arrayList.add(new CompareProjectResult<CompareProject>(compareProject));
            if (!bl) continue;
        }
        return arrayList;
    }

    public List<CompareProjectResult<CompareProject>> getCompareProjectResults() {
        return this.b;
    }

    public boolean addCompareProject(Color color, SpyGlassProject spyGlassProject, String string, IProjectLocation iProjectLocation) {
        CompareProject compareProject = this.c.createCompareProject();
        compareProject.setProjectColor(color);
        compareProject.setProjectName(string);
        compareProject.setProjectLocation(iProjectLocation);
        CompareProjectResult<CompareProject> compareProjectResult = new CompareProjectResult<CompareProject>(compareProject);
        if (spyGlassProject != null && iProjectLocation == null) {
            this.d.put(compareProject, spyGlassProject);
            compareProjectResult.setUnsaved(true);
        }
        this.c.add(compareProject);
        return this.b.add(compareProjectResult);
    }

    public void removeCompareProject(CompareProjectResult<CompareProject> compareProjectResult) {
        this.b.remove(compareProjectResult);
        this.c.remove(compareProjectResult.getCompareProject());
        this.d.remove(compareProjectResult.getCompareProject());
    }

    public SpyGlassProject getCheckedUnsaved(CompareProject compareProject) throws InterruptedException {
        return (SpyGlassProject)ThreadSafeUtil.invokeWaitAndReturn((ExecuteAndReturn)new g(this, compareProject));
    }

    public SpyGlassProject getUnsavedProject(ICompareProject iCompareProject) {
        SpyGlassProject spyGlassProject = this.d.get(iCompareProject);
        if (spyGlassProject != null) {
            if (this.a(spyGlassProject)) {
                return spyGlassProject;
            }
            this.d.remove(iCompareProject);
        }
        return null;
    }

    private boolean a(SpyGlassProject spyGlassProject) {
        return this.c().contains(spyGlassProject);
    }

    private Set<SpyGlassProject> c() {
        boolean bl = CompareResult.d;
        HashSet<SpyGlassProject> hashSet = new HashSet<SpyGlassProject>();
        ApplicationControllerImpl applicationControllerImpl = (ApplicationControllerImpl)this.a.getProvider(ApplicationControllerImpl.class);
        ProjectsTabController projectsTabController = applicationControllerImpl.getProjectsTab();
        List list = projectsTabController.getTabs();
        for (ProjectPanelController projectPanelController : list) {
            hashSet.add((SpyGlassProject)projectPanelController.getProject());
            if (!bl) continue;
        }
        return hashSet;
    }

    public void copyFrom(CompareProjectsManager compareProjectsManager) {
        this.b.clear();
        this.b.addAll(compareProjectsManager.b);
        this.d.clear();
        this.d.putAll(compareProjectsManager.d);
    }

    public SpyGlassProject loadProject(CompareProjectResult<CompareProject> compareProjectResult) throws IOException, InterruptedException, InvocationTargetException {
        SpyGlassProject spyGlassProject;
        block11: {
            ProjectPanelController projectPanelController;
            block14: {
                IProjectLocation iProjectLocation;
                block13: {
                    block12: {
                        spyGlassProject = this.getCheckedUnsaved(compareProjectResult.getCompareProject());
                        if (spyGlassProject != null) break block11;
                        if (compareProjectResult.getCompareProject() != null) break block12;
                        iProjectLocation = null;
                        break block13;
                    }
                    iProjectLocation = compareProjectResult.getCompareProject().getProjectLocation();
                }
                IProjectLocation iProjectLocation2 = iProjectLocation;
                if (iProjectLocation2 == null) {
                    CompareProjectsManager.a(compareProjectResult, TroubleType.NOT_FOUND);
                    return null;
                }
                CompareProjectsManager.a(compareProjectResult, null);
                compareProjectResult.setUnsaved(false);
                ApplicationControllerImpl applicationControllerImpl = (ApplicationControllerImpl)this.a.getThisProvider(ApplicationControllerImpl.class);
                ProjectsTabController projectsTabController = applicationControllerImpl.getProjectsTab();
                projectPanelController = projectsTabController.getTab(iProjectLocation2);
                if (projectPanelController != null) break block14;
                ProjectLoaderSaverManager projectLoaderSaverManager = applicationControllerImpl.getProjectLoaderSaverManager();
                spyGlassProject = this.a((ApplicationControllerImpl<SpyGlassProject>)applicationControllerImpl, compareProjectResult, (ProjectLoaderSaverManager<SpyGlassProject>)projectLoaderSaverManager);
                if (!CompareResult.d) break block11;
            }
            spyGlassProject = (SpyGlassProject)projectPanelController.getProject();
        }
        return spyGlassProject;
    }

    private SpyGlassProject a(ApplicationControllerImpl<SpyGlassProject> applicationControllerImpl, CompareProjectResult<? extends ICompareProject> compareProjectResult, ProjectLoaderSaverManager<SpyGlassProject> projectLoaderSaverManager) throws IOException, InterruptedException, InvocationTargetException {
        try {
            IProjectLocation iProjectLocation;
            block11: {
                iProjectLocation = compareProjectResult.getCompareProject().getProjectLocation();
                if (iProjectLocation.getStorageType() != StorageType.DROPBOX || applicationControllerImpl.getParameters().haveAccount(StorageType.DROPBOX)) break block11;
                CompareProjectsManager.a(compareProjectResult, TroubleType.DROPBOX_WRONG_AUTH);
                return null;
            }
            SpyGlassProject spyGlassProject = this.a(iProjectLocation, projectLoaderSaverManager);
            CompareProjectsManager.a(compareProjectResult, null);
            return spyGlassProject;
        }
        catch (DropboxFileNotFoundException | ProjectNotFoundException | FileNotFoundException throwable) {
            e.error("", throwable);
            CompareProjectsManager.a(compareProjectResult, TroubleType.NOT_FOUND);
        }
        catch (SpsCloudServerException spsCloudServerException) {
            e.error("", (Throwable)spsCloudServerException);
            CompareProjectsManager.a(compareProjectResult, TroubleType.SPS_LOAD_ERROR);
        }
        catch (WrongAuthorizationException wrongAuthorizationException) {
            e.error("", (Throwable)wrongAuthorizationException);
            CompareProjectsManager.a(compareProjectResult, TroubleType.DROPBOX_WRONG_AUTH);
        }
        catch (DropboxException dropboxException) {
            e.error("", (Throwable)dropboxException);
            CompareProjectsManager.a(compareProjectResult, TroubleType.DROPBOX_LOAD_ERROR);
        }
        catch (ProjectCorruptException projectCorruptException) {
            CompareProjectsManager.a(compareProjectResult, TroubleType.CORRUPTED);
        }
        catch (IOException iOException) {
            e.error("", (Throwable)iOException);
            CompareProjectsManager.a(compareProjectResult, TroubleType.CONNECTION_ERROR);
        }
        catch (InterruptedException interruptedException) {
            CompareProjectsManager.a(compareProjectResult, null);
        }
        catch (Throwable throwable) {
            e.error("", throwable);
            CompareProjectsManager.a(compareProjectResult, TroubleType.UNKNOWN);
        }
        return null;
    }

    private SpyGlassProject a(IProjectLocation iProjectLocation, ProjectLoaderSaverManager<SpyGlassProject> projectLoaderSaverManager) throws IOException, InterruptedException {
        return (SpyGlassProject)projectLoaderSaverManager.loadProject(iProjectLocation);
    }

    private static void a(CompareProjectResult<? extends ICompareProject> compareProjectResult, TroubleType troubleType) throws InterruptedException, InvocationTargetException {
        SwingUtilities.invokeAndWait(new o(compareProjectResult, troubleType));
    }

    static Map a(CompareProjectsManager compareProjectsManager) {
        return compareProjectsManager.d;
    }
}

