/*
 * Decompiled with CFR 0.152.
 */
package com.agilemind.spyglass.data.compare.factors;

import com.agilemind.commons.application.modules.io.searchengine.data.PopularityHistory;
import com.agilemind.commons.application.modules.io.searchengine.data.PopularityHistoryMap;
import com.agilemind.commons.application.modules.io.searchengine.data.SearchEngineFactor;
import com.agilemind.commons.io.searchengine.analyzers.SearchEngineFactorsList;
import com.agilemind.commons.io.searchengine.analyzers.data.IMozAuthorityResult;
import com.agilemind.commons.io.searchengine.analyzers.data.SearchEngineFactorType;
import com.agilemind.commons.io.searchengine.searchengines.data.mozapi.IMozApiKeysSettings;
import com.agilemind.spyglass.data.SpyGlassProject;
import com.agilemind.spyglass.data.compare.CompareFactor;
import com.agilemind.spyglass.data.compare.CompareResult;
import com.agilemind.spyglass.data.compare.factors.TopTLDCompareFactor;
import com.agilemind.spyglass.util.SpyGlassStringKey;

public class DomainGooglePRAuthorityCompareFactor
implements CompareFactor {
    private final SpyGlassProject a;
    private final IMozApiKeysSettings b;

    public DomainGooglePRAuthorityCompareFactor(SpyGlassProject spyGlassProject, IMozApiKeysSettings iMozApiKeysSettings) {
        this.a = spyGlassProject;
        this.b = iMozApiKeysSettings;
    }

    @Override
    public CompareResult<Comparable> getCompareResult() {
        boolean bl = TopTLDCompareFactor.b;
        PopularityHistoryMap popularityHistoryMap = this.a.getPopularityHistoryMap();
        Integer n2 = this.b.isUseInsteadPR() ? this.a(popularityHistoryMap) : this.getGooglePR(popularityHistoryMap);
        CompareResult<Comparable> compareResult = new CompareResult<Comparable>(n2, n2 == null || n2 == -1);
        if (bl) {
            SpyGlassStringKey.b = !SpyGlassStringKey.b;
        }
        return compareResult;
    }

    public Integer getGooglePR(PopularityHistoryMap popularityHistoryMap) {
        Integer n2 = (Integer)DomainGooglePRAuthorityCompareFactor.a(SearchEngineFactorsList.DOMAIN_GOOGLE_PR, popularityHistoryMap);
        if (n2 == null) {
            return null;
        }
        if (n2 == -1) {
            return -2;
        }
        return n2;
    }

    private Integer a(PopularityHistoryMap popularityHistoryMap) {
        IMozAuthorityResult iMozAuthorityResult = (IMozAuthorityResult)DomainGooglePRAuthorityCompareFactor.a(SearchEngineFactorsList.MOZ_AUTHORITY_FACTOR_TYPE, popularityHistoryMap);
        if (iMozAuthorityResult == null) {
            return null;
        }
        return (int)Math.round(iMozAuthorityResult.getDomainAuthority());
    }

    private static <T extends Comparable> T a(SearchEngineFactorType<T> searchEngineFactorType, PopularityHistoryMap popularityHistoryMap) {
        PopularityHistory popularityHistory = popularityHistoryMap.getPopularityHistory(searchEngineFactorType);
        if (popularityHistory == null) {
            return null;
        }
        SearchEngineFactor searchEngineFactor = popularityHistory.getLastRankingFactor();
        if (searchEngineFactor == null) {
            return null;
        }
        return (T)searchEngineFactor.getFactorValue();
    }
}

