/*
 * Decompiled with CFR 0.152.
 */
package com.agilemind.spyglass.util;

import com.agilemind.commons.application.data.ScanResult;
import com.agilemind.commons.application.modules.io.searchengine.data.PopularityMap;
import com.agilemind.commons.application.modules.io.searchengine.data.SearchEngineFactor;
import com.agilemind.commons.application.modules.linkinfo.data.AnchorType;
import com.agilemind.commons.application.modules.linkinfo.data.LinkInfo;
import com.agilemind.commons.application.modules.widget.util.to.AnchorAltTextResult;
import com.agilemind.commons.application.modules.widget.util.to.AnchorUrlResult;
import com.agilemind.commons.application.modules.widget.util.to.KeywordsResult;
import com.agilemind.commons.application.modules.widget.util.to.analyze.CountryResult;
import com.agilemind.commons.application.modules.widget.util.to.analyze.DofollowNofollowDistribution;
import com.agilemind.commons.application.modules.widget.util.to.analyze.HomepageLinksDistribution;
import com.agilemind.commons.application.modules.widget.util.to.analyze.PRDistribution;
import com.agilemind.commons.application.modules.widget.util.to.analyze.TLDResult;
import com.agilemind.commons.io.searchengine.analyzers.SearchEngineFactorsList;
import com.agilemind.commons.io.searchengine.analyzers.data.FactorType;
import com.agilemind.commons.io.searchengine.analyzers.data.SearchEngineFactorType;
import com.agilemind.commons.io.searchengine.validator.scanstatus.ScanStatus;
import com.agilemind.commons.io.utils.MethodParameters;
import com.agilemind.commons.io.utils.ip.data.IP;
import com.agilemind.commons.localization.stringkey.Country;
import com.agilemind.commons.util.MathUtil;
import com.agilemind.commons.util.StringUtil;
import com.agilemind.commons.util.UnicodeURL;
import com.agilemind.commons.util.UnicodeURLUtil;
import com.agilemind.spyglass.data.AnalyzeRecord;
import com.agilemind.spyglass.data.SpyGlassProject;
import com.agilemind.spyglass.util.ScanProjectsOperation;
import com.agilemind.spyglass.util.s;
import com.agilemind.spyglass.util.t;
import com.agilemind.spyglass.util.u;
import com.agilemind.spyglass.util.v;
import com.agilemind.spyglass.util.w;
import com.agilemind.spyglass.util.x;
import com.agilemind.spyglass.util.y;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Pattern;

public class BacklinkAnalyzeUtil {
    public static final int NO_DATA = -1;
    private static final Pattern a;
    private static final String[] b;

    public static int getUniqueDomainsCount(List<AnalyzeRecord> list) {
        int n2 = ScanProjectsOperation.j;
        ArrayList<UnicodeURL> arrayList = new ArrayList<UnicodeURL>();
        for (AnalyzeRecord analyzeRecord : list) {
            arrayList.add(analyzeRecord.getPage());
            if (n2 == 0) continue;
        }
        return BacklinkAnalyzeUtil.getUniqueHomepagesCount(arrayList);
    }

    public static int getHomepageLinkingDomainsCount(List<AnalyzeRecord> list) {
        int n2 = ScanProjectsOperation.j;
        ArrayList<UnicodeURL> arrayList = new ArrayList<UnicodeURL>();
        for (AnalyzeRecord analyzeRecord : list) {
            UnicodeURL unicodeURL = analyzeRecord.getPage();
            if (UnicodeURLUtil.isHomePageIncludeIndex((UnicodeURL)unicodeURL)) {
                arrayList.add(unicodeURL);
            }
            if (n2 == 0) continue;
        }
        return BacklinkAnalyzeUtil.getUniqueHomepagesCount(arrayList);
    }

    public static int getUniqueIPsCount(List<AnalyzeRecord> list) {
        int n2 = ScanProjectsOperation.j;
        if (list.isEmpty()) {
            return 0;
        }
        boolean bl = false;
        HashSet<IP> hashSet = new HashSet<IP>();
        for (AnalyzeRecord analyzeRecord : list) {
            SearchEngineFactor searchEngineFactor = analyzeRecord.getRankingFactorsMap().getFactor((FactorType)SearchEngineFactorsList.DOMAIN_IP_FACTOR_TYPE);
            if (searchEngineFactor == null && n2 == 0) continue;
            bl = true;
            IP iP = (IP)searchEngineFactor.getFactorValue();
            if (iP == null && n2 == 0) continue;
            hashSet.add(iP);
            if (n2 == 0) continue;
        }
        int n3 = bl ? hashSet.size() : -1;
        return n3;
    }

    public static int getUniqueCBlocksCount(List<AnalyzeRecord> list) {
        int n2 = ScanProjectsOperation.j;
        if (list.isEmpty()) {
            return 0;
        }
        boolean bl = false;
        HashSet<String> hashSet = new HashSet<String>();
        for (AnalyzeRecord analyzeRecord : list) {
            SearchEngineFactor searchEngineFactor = analyzeRecord.getRankingFactorsMap().getFactor((FactorType)SearchEngineFactorsList.DOMAIN_IP_FACTOR_TYPE);
            if (searchEngineFactor == null && n2 == 0) continue;
            bl = true;
            IP iP = (IP)searchEngineFactor.getFactorValue();
            if (iP == null && n2 == 0) continue;
            String string = "";
            int[] nArray = iP.getDigits();
            for (int i2 = 0; i2 < nArray.length - 1; ++i2) {
                string = string + nArray[i2];
                if (n2 == 0) continue;
            }
            hashSet.add(string);
            if (n2 == 0) continue;
        }
        int n3 = bl ? hashSet.size() : -1;
        return n3;
    }

    public static int getUniqueAnchorsCount(List<AnalyzeRecord> list) {
        int n2 = ScanProjectsOperation.j;
        HashSet<String> hashSet = new HashSet<String>();
        HashSet<String> hashSet2 = new HashSet<String>();
        for (AnalyzeRecord analyzeRecord : list) {
            block12: {
                String string;
                block11: {
                    ScanResult scanResult = analyzeRecord.getScanResult();
                    if (scanResult == null && n2 == 0) continue;
                    LinkInfo linkInfo = scanResult.getLinkInfo();
                    if (linkInfo == null && n2 == 0) continue;
                    string = BacklinkAnalyzeUtil.a(linkInfo);
                    AnchorType anchorType = linkInfo.getAnchorType();
                    if (anchorType != AnchorType.TEXT_LINK || linkInfo.getBanner() != null) break block11;
                    hashSet.add(string);
                    if (n2 == 0) break block12;
                }
                hashSet2.add(string);
            }
            if (n2 == 0) continue;
        }
        return hashSet.size() + hashSet2.size();
    }

    public static int getUniqueKeywordsCount(List<AnalyzeRecord> list) {
        int n2 = ScanProjectsOperation.j;
        HashSet<String> hashSet = new HashSet<String>();
        for (AnalyzeRecord analyzeRecord : list) {
            String string = analyzeRecord.getAnchorText();
            if (string != null) {
                Collection<String> collection = BacklinkAnalyzeUtil.a(string);
                hashSet.addAll(collection);
            }
            if (n2 == 0) continue;
        }
        return hashSet.size();
    }

    public static int getUniqueAnchorUrlsCount(List<AnalyzeRecord> list) {
        int n2 = ScanProjectsOperation.j;
        HashSet<String> hashSet = new HashSet<String>();
        for (AnalyzeRecord analyzeRecord : list) {
            UnicodeURL unicodeURL = analyzeRecord.getAnchorUrl();
            if (unicodeURL != null) {
                hashSet.add(BacklinkAnalyzeUtil.a(unicodeURL).toLowerCase());
            }
            if (n2 == 0) continue;
        }
        return hashSet.size();
    }

    public static List<CountryResult> getCountryDistributions(List<AnalyzeRecord> list) {
        int n2 = ScanProjectsOperation.j;
        ArrayList<CountryResult> arrayList = new ArrayList<CountryResult>();
        Map<Country, List<UnicodeURL>> map = BacklinkAnalyzeUtil.a(list);
        int n3 = BacklinkAnalyzeUtil.getUniqueDomainsCount(list);
        for (Map.Entry<Country, List<UnicodeURL>> entry : map.entrySet()) {
            int n4 = BacklinkAnalyzeUtil.getUniqueHomepagesCount(entry.getValue());
            double d2 = MathUtil.getPercent((double)n3, (double)n4);
            arrayList.add(new CountryResult(entry.getKey(), n4, d2));
            if (n2 == 0) continue;
        }
        Collections.sort(arrayList, new s());
        return arrayList;
    }

    private static Map<Country, List<UnicodeURL>> a(List<AnalyzeRecord> list) {
        int n2 = ScanProjectsOperation.j;
        HashMap<Country, List<UnicodeURL>> hashMap = new HashMap<Country, List<UnicodeURL>>();
        for (AnalyzeRecord analyzeRecord : list) {
            SearchEngineFactor searchEngineFactor = analyzeRecord.getRankingFactorsMap().getFactor((FactorType)SearchEngineFactorsList.DOMAIN_IP_FACTOR_TYPE);
            if (searchEngineFactor == null && n2 == 0) continue;
            IP iP = (IP)searchEngineFactor.getFactorValue();
            if (iP == null && n2 == 0) continue;
            Country country = iP.getCountry();
            if (country.equals((Object)Country.UNKNOWN) && n2 == 0) continue;
            ArrayList<UnicodeURL> arrayList = (ArrayList<UnicodeURL>)hashMap.get(country);
            if (arrayList == null) {
                arrayList = new ArrayList<UnicodeURL>();
                hashMap.put(country, arrayList);
            }
            arrayList.add(analyzeRecord.getPage());
            if (n2 == 0) continue;
        }
        return hashMap;
    }

    public static List<TLDResult> getTLDDistribution(List<AnalyzeRecord> list) {
        int n2 = ScanProjectsOperation.j;
        ArrayList<TLDResult> arrayList = new ArrayList<TLDResult>();
        Map<String, List<UnicodeURL>> map = BacklinkAnalyzeUtil.b(list);
        int n3 = BacklinkAnalyzeUtil.getUniqueDomainsCount(list);
        for (Map.Entry<String, List<UnicodeURL>> entry : map.entrySet()) {
            int n4 = BacklinkAnalyzeUtil.getUniqueHomepagesCount(entry.getValue());
            double d2 = MathUtil.getPercent((double)n3, (double)n4);
            arrayList.add(new TLDResult(entry.getKey(), n4, d2));
            if (n2 == 0) continue;
        }
        Collections.sort(arrayList, new t());
        return arrayList;
    }

    private static Map<String, List<UnicodeURL>> b(List<AnalyzeRecord> list) {
        int n2 = ScanProjectsOperation.j;
        HashMap<String, List<UnicodeURL>> hashMap = new HashMap<String, List<UnicodeURL>>();
        for (AnalyzeRecord analyzeRecord : list) {
            if (a.matcher(analyzeRecord.getPage().getUnicodeHost()).find() && n2 == 0) continue;
            String string = UnicodeURLUtil.getTld((UnicodeURL)analyzeRecord.getPage());
            ArrayList<UnicodeURL> arrayList = (ArrayList<UnicodeURL>)hashMap.get(string);
            if (arrayList == null) {
                arrayList = new ArrayList<UnicodeURL>();
                hashMap.put(string, arrayList);
            }
            arrayList.add(analyzeRecord.getPage());
            if (n2 == 0) continue;
        }
        return hashMap;
    }

    public static List<AnchorAltTextResult> getPagesTopAnchorAltTexts(List<AnalyzeRecord> list) {
        int n2 = ScanProjectsOperation.j;
        ArrayList<AnchorAltTextResult> arrayList = new ArrayList<AnchorAltTextResult>();
        Map<Map.Entry<String, AnchorType>, List<UnicodeURL>> map = BacklinkAnalyzeUtil.c(list);
        for (Map.Entry<Map.Entry<String, AnchorType>, List<UnicodeURL>> entry : map.entrySet()) {
            String string = entry.getKey().getKey();
            AnchorType anchorType = entry.getKey().getValue();
            int n3 = entry.getValue().size();
            double d2 = MathUtil.getPercent((double)list.size(), (double)n3);
            arrayList.add(new AnchorAltTextResult(string, anchorType, n3, d2));
            if (n2 == 0) continue;
        }
        Collections.sort(arrayList, new x(null));
        return arrayList;
    }

    public static List<AnchorAltTextResult> getDomainsTopAnchorAltTexts(List<AnalyzeRecord> list) {
        int n2 = ScanProjectsOperation.j;
        ArrayList<AnchorAltTextResult> arrayList = new ArrayList<AnchorAltTextResult>();
        Map<Map.Entry<String, AnchorType>, List<UnicodeURL>> map = BacklinkAnalyzeUtil.c(list);
        int n3 = BacklinkAnalyzeUtil.getUniqueDomainsCount(list);
        for (Map.Entry<Map.Entry<String, AnchorType>, List<UnicodeURL>> entry : map.entrySet()) {
            int n4 = BacklinkAnalyzeUtil.getUniqueHomepagesCount(entry.getValue());
            double d2 = MathUtil.getPercent((double)n3, (double)n4);
            arrayList.add(new AnchorAltTextResult(entry.getKey().getKey(), entry.getKey().getValue(), n4, d2));
            if (n2 == 0) continue;
        }
        Collections.sort(arrayList, new x(null));
        return arrayList;
    }

    private static Map<Map.Entry<String, AnchorType>, List<UnicodeURL>> c(List<AnalyzeRecord> list) {
        int n2 = ScanProjectsOperation.j;
        HashMap<Map.Entry<String, AnchorType>, List<UnicodeURL>> hashMap = new HashMap<Map.Entry<String, AnchorType>, List<UnicodeURL>>();
        for (AnalyzeRecord analyzeRecord : list) {
            String string;
            MethodParameters.SimpleEntry simpleEntry;
            ArrayList<UnicodeURL> arrayList;
            AnchorType anchorType;
            LinkInfo linkInfo;
            block8: {
                ScanResult scanResult = analyzeRecord.getScanResult();
                if (scanResult == null && n2 == 0) continue;
                linkInfo = scanResult.getLinkInfo();
                if (linkInfo == null && n2 == 0) continue;
                anchorType = linkInfo.getAnchorType();
                if (anchorType != AnchorType.TEXT_LINK || linkInfo.getBanner() == null) break block8;
                anchorType = AnchorType.IMAGE_LINK;
            }
            if ((arrayList = (ArrayList<UnicodeURL>)hashMap.get(simpleEntry = new MethodParameters.SimpleEntry((Object)(string = BacklinkAnalyzeUtil.a(linkInfo)), (Object)anchorType))) == null) {
                arrayList = new ArrayList<UnicodeURL>();
                hashMap.put((Map.Entry<String, AnchorType>)simpleEntry, arrayList);
            }
            arrayList.add(analyzeRecord.getPage());
            if (n2 == 0) continue;
        }
        return hashMap;
    }

    public static List<KeywordsResult> getPagesTopKeywords(List<AnalyzeRecord> list) {
        int n2 = ScanProjectsOperation.j;
        ArrayList<KeywordsResult> arrayList = new ArrayList<KeywordsResult>();
        Map<String, List<UnicodeURL>> map = BacklinkAnalyzeUtil.d(list);
        for (Map.Entry<String, List<UnicodeURL>> entry : map.entrySet()) {
            int n3 = entry.getValue().size();
            double d2 = MathUtil.getPercent((double)list.size(), (double)n3);
            arrayList.add(new KeywordsResult(entry.getKey(), n3, d2));
            if (n2 == 0) continue;
        }
        Collections.sort(arrayList, new y(null));
        return arrayList;
    }

    public static List<KeywordsResult> getDomainsTopKeywords(List<AnalyzeRecord> list) {
        int n2 = ScanProjectsOperation.j;
        ArrayList<KeywordsResult> arrayList = new ArrayList<KeywordsResult>();
        Map<String, List<UnicodeURL>> map = BacklinkAnalyzeUtil.d(list);
        int n3 = BacklinkAnalyzeUtil.getUniqueDomainsCount(list);
        for (Map.Entry<String, List<UnicodeURL>> entry : map.entrySet()) {
            int n4 = BacklinkAnalyzeUtil.getUniqueHomepagesCount(entry.getValue());
            double d2 = MathUtil.getPercent((double)n3, (double)n4);
            arrayList.add(new KeywordsResult(entry.getKey(), n4, d2));
            if (n2 == 0) continue;
        }
        Collections.sort(arrayList, new y(null));
        return arrayList;
    }

    private static Map<String, List<UnicodeURL>> d(List<AnalyzeRecord> list) {
        int n2 = ScanProjectsOperation.j;
        HashMap<String, List<UnicodeURL>> hashMap = new HashMap<String, List<UnicodeURL>>();
        for (AnalyzeRecord analyzeRecord : list) {
            String string = analyzeRecord.getAnchorText();
            if (string == null && n2 == 0) continue;
            Collection<String> collection = BacklinkAnalyzeUtil.a(string);
            for (String string2 : collection) {
                ArrayList<UnicodeURL> arrayList = (ArrayList<UnicodeURL>)hashMap.get(string2);
                if (arrayList == null) {
                    arrayList = new ArrayList<UnicodeURL>();
                    hashMap.put(string2, arrayList);
                }
                arrayList.add(analyzeRecord.getPage());
                if (n2 == 0) continue;
            }
            if (n2 == 0) continue;
        }
        return hashMap;
    }

    public static List<AnchorUrlResult> getPagesTopAnchorUrls(List<AnalyzeRecord> list) {
        int n2 = ScanProjectsOperation.j;
        ArrayList<AnchorUrlResult> arrayList = new ArrayList<AnchorUrlResult>();
        Map<UnicodeURL, List<UnicodeURL>> map = BacklinkAnalyzeUtil.e(list);
        for (Map.Entry<UnicodeURL, List<UnicodeURL>> entry : map.entrySet()) {
            int n3 = entry.getValue().size();
            double d2 = MathUtil.getPercent((double)list.size(), (double)n3);
            arrayList.add(new AnchorUrlResult(entry.getKey(), n3, d2));
            if (n2 == 0) continue;
        }
        Collections.sort(arrayList, new u());
        return arrayList;
    }

    public static List<AnchorUrlResult> getDomainsTopAnchorUrls(List<AnalyzeRecord> list) {
        int n2 = ScanProjectsOperation.j;
        ArrayList<AnchorUrlResult> arrayList = new ArrayList<AnchorUrlResult>();
        Map<UnicodeURL, List<UnicodeURL>> map = BacklinkAnalyzeUtil.e(list);
        int n3 = BacklinkAnalyzeUtil.getUniqueDomainsCount(list);
        for (Map.Entry<UnicodeURL, List<UnicodeURL>> entry : map.entrySet()) {
            int n4 = BacklinkAnalyzeUtil.getUniqueHomepagesCount(entry.getValue());
            double d2 = MathUtil.getPercent((double)n3, (double)n4);
            arrayList.add(new AnchorUrlResult(entry.getKey(), n4, d2));
            if (n2 == 0) continue;
        }
        Collections.sort(arrayList, new v());
        return arrayList;
    }

    private static Map<UnicodeURL, List<UnicodeURL>> e(List<AnalyzeRecord> list) {
        int n2 = ScanProjectsOperation.j;
        TreeMap<UnicodeURL, List<UnicodeURL>> treeMap = new TreeMap<UnicodeURL, List<UnicodeURL>>(new w());
        for (AnalyzeRecord analyzeRecord : list) {
            UnicodeURL unicodeURL = analyzeRecord.getAnchorUrl();
            if (unicodeURL == null && n2 == 0) continue;
            ArrayList<UnicodeURL> arrayList = (ArrayList<UnicodeURL>)treeMap.get(unicodeURL);
            if (arrayList == null) {
                arrayList = new ArrayList<UnicodeURL>();
                treeMap.put(unicodeURL, arrayList);
            }
            arrayList.add(analyzeRecord.getPage());
            if (n2 == 0) continue;
        }
        return treeMap;
    }

    private static String a(UnicodeURL unicodeURL) {
        return UnicodeURLUtil.removeTrailingSlash((String)UnicodeURLUtil.removeWWW((String)UnicodeURLUtil.removeProtocol((UnicodeURL)unicodeURL)));
    }

    public static int getUniqueHomepagesCount(List<UnicodeURL> list) {
        int n2 = ScanProjectsOperation.j;
        HashSet<String> hashSet = new HashSet<String>();
        for (UnicodeURL unicodeURL : list) {
            hashSet.add(unicodeURL.getUnicodeHost().toLowerCase());
            if (n2 == 0) continue;
        }
        return hashSet.size();
    }

    private static String a(LinkInfo linkInfo) {
        return StringUtil.removeBrakes((String)linkInfo.getName()).toLowerCase();
    }

    private static Collection<String> a(String string) {
        if ("".equals(string)) {
            return Collections.singletonList(string);
        }
        string = string.replaceAll(b[4], "");
        return StringUtil.getUniqueKeywords((String)string.toLowerCase());
    }

    public static DofollowNofollowDistribution getDofollowNofollowDistribution(List<AnalyzeRecord> list) {
        int n2 = ScanProjectsOperation.j;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        for (AnalyzeRecord analyzeRecord : list) {
            block16: {
                block19: {
                    block18: {
                        ScanStatus scanStatus;
                        block17: {
                            block15: {
                                ScanResult scanResult = analyzeRecord.getScanResult();
                                scanStatus = scanResult.getScanStatus();
                                if (scanStatus != ScanStatus.SCAN_STATUS_UNKNOWN) break block15;
                                ++n5;
                                if (n2 == 0) break block16;
                            }
                            if (!scanStatus.isOkStatus()) break block17;
                            ++n3;
                            if (n2 == 0) break block16;
                        }
                        if (scanStatus == ScanStatus.SCAN_STATUS_CHEATING_NOFOLLOW) break block18;
                        if (scanStatus != ScanStatus.SCAN_STATUS_NOINDEX_ROBOTS) break block19;
                    }
                    ++n4;
                    if (n2 == 0) break block16;
                }
                ++n5;
            }
            if (n2 == 0) continue;
        }
        double d2 = MathUtil.getPercent((double)list.size(), (double)n3);
        double d3 = MathUtil.getPercent((double)list.size(), (double)n4);
        double d4 = MathUtil.getPercent((double)list.size(), (double)n5);
        return new DofollowNofollowDistribution(n3, d2, n4, d3, n5, d4);
    }

    public static HomepageLinksDistribution getHomepageLinksDistribution(List<AnalyzeRecord> list) {
        int n2 = BacklinkAnalyzeUtil.getUniqueDomainsCount(list);
        int n3 = BacklinkAnalyzeUtil.getHomepageLinkingDomainsCount(list);
        double d2 = MathUtil.getPercent((double)n2, (double)n3);
        int n4 = n2 - n3;
        double d3 = MathUtil.getPercent((double)n2, (double)n4);
        return new HomepageLinksDistribution(n3, d2, n4, d3);
    }

    public static List<AnalyzeRecord> getAcceptedBacklinks(SpyGlassProject spyGlassProject) {
        int n2 = ScanProjectsOperation.j;
        if (spyGlassProject == null) {
            throw new IllegalArgumentException(String.format(b[3], b[2], b[1], b[0]));
        }
        ArrayList<AnalyzeRecord> arrayList = new ArrayList<AnalyzeRecord>();
        Iterator iterator = spyGlassProject.getBackLinks().iterator();
        while (iterator.hasNext()) {
            AnalyzeRecord analyzeRecord = (AnalyzeRecord)iterator.next();
            ScanResult scanResult = analyzeRecord.getScanResult();
            ScanStatus scanStatus = scanResult.getScanStatus();
            if (scanStatus == ScanStatus.SCAN_STATUS_SITE_NOT_FOUND || scanStatus == ScanStatus.SCAN_STATUS_PAGE_NOT_FOUND || scanStatus == ScanStatus.SCAN_STATUS_LINK_NOT_FOUND) continue;
            if (spyGlassProject.getDisavowFacade().isDisavow(analyzeRecord.getPage()) && n2 == 0) continue;
            arrayList.add(analyzeRecord);
            if (n2 == 0) continue;
        }
        return arrayList;
    }

    public static List<PRDistribution> getPagesPRDistributions(List<AnalyzeRecord> list) {
        int n2 = ScanProjectsOperation.j;
        ArrayList<PRDistribution> arrayList = new ArrayList<PRDistribution>();
        Map<Integer, List<UnicodeURL>> map = BacklinkAnalyzeUtil.a((SearchEngineFactorType<Integer>)SearchEngineFactorsList.PAGE_GOOGLE_PR, list);
        if (map.isEmpty()) {
            return arrayList;
        }
        for (int i2 = -1; i2 <= 10; ++i2) {
            List<UnicodeURL> list2 = map.get(i2);
            if (list2 == null) {
                arrayList.add(new PRDistribution(i2));
                if (n2 == 0) continue;
            }
            double d2 = MathUtil.getPercent((double)list.size(), (double)list2.size());
            arrayList.add(new PRDistribution(i2, list2.size(), d2));
            if (n2 == 0) continue;
        }
        return arrayList;
    }

    public static List<PRDistribution> getDomainsPRDistributions(List<AnalyzeRecord> list) {
        int n2 = ScanProjectsOperation.j;
        ArrayList<PRDistribution> arrayList = new ArrayList<PRDistribution>();
        Map<Integer, List<UnicodeURL>> map = BacklinkAnalyzeUtil.a((SearchEngineFactorType<Integer>)SearchEngineFactorsList.DOMAIN_GOOGLE_PR, list);
        if (map.isEmpty()) {
            return arrayList;
        }
        int n3 = BacklinkAnalyzeUtil.getUniqueDomainsCount(list);
        for (int i2 = -1; i2 <= 10; ++i2) {
            List<UnicodeURL> list2 = map.get(i2);
            if (list2 == null) {
                arrayList.add(new PRDistribution(i2));
                if (n2 == 0) continue;
            }
            int n4 = BacklinkAnalyzeUtil.getUniqueHomepagesCount(list2);
            double d2 = MathUtil.getPercent((double)n3, (double)n4);
            arrayList.add(new PRDistribution(i2, n4, d2));
            if (n2 == 0) continue;
        }
        return arrayList;
    }

    private static Map<Integer, List<UnicodeURL>> a(SearchEngineFactorType<Integer> searchEngineFactorType, List<AnalyzeRecord> list) {
        int n2 = ScanProjectsOperation.j;
        HashMap<Integer, List<UnicodeURL>> hashMap = new HashMap<Integer, List<UnicodeURL>>();
        for (AnalyzeRecord analyzeRecord : list) {
            PopularityMap popularityMap = analyzeRecord.getRankingFactorsMap();
            SearchEngineFactor searchEngineFactor = popularityMap.getFactor(searchEngineFactorType);
            if (searchEngineFactor == null && n2 == 0) continue;
            Integer n3 = (Integer)searchEngineFactor.getFactorValue();
            ArrayList<UnicodeURL> arrayList = (ArrayList<UnicodeURL>)hashMap.get(n3);
            if (arrayList == null) {
                arrayList = new ArrayList<UnicodeURL>();
                hashMap.put(n3, arrayList);
            }
            arrayList.add(analyzeRecord.getPage());
            if (n2 == 0) continue;
        }
        return hashMap;
    }

    static String b(UnicodeURL unicodeURL) {
        return BacklinkAnalyzeUtil.a(unicodeURL);
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        char[] cArray;
        block28: {
            int n2;
            int n3;
            char[] cArray2;
            int n4;
            block27: {
                String string;
                String[] stringArray = new String[5];
                String[] stringArray2 = stringArray;
                String[] stringArray3 = stringArray;
                int n5 = 0;
                String string2 = "#I Ke'I$~c n5im(E:au";
                int n6 = -1;
                block18: while (true) {
                    char[] cArray3;
                    block26: {
                        int n7;
                        int n8;
                        char[] cArray4;
                        block25: {
                            char[] cArray5 = string2.toCharArray();
                            n4 = 0;
                            int n9 = cArray5.length;
                            cArray4 = cArray5;
                            n8 = n9;
                            if (n9 <= 1) break block25;
                            cArray3 = cArray4;
                            n7 = n8;
                            if (n8 <= n4) break block26;
                        }
                        do {
                            char[] cArray6 = cArray4;
                            char[] cArray7 = cArray4;
                            int n10 = n4;
                            while (true) {
                                int n11;
                                char c2 = cArray6[n10];
                                switch (n4 % 5) {
                                    case 0: {
                                        n11 = 68;
                                        break;
                                    }
                                    case 1: {
                                        n11 = 44;
                                        break;
                                    }
                                    case 2: {
                                        n11 = 84;
                                        break;
                                    }
                                    case 3: {
                                        n11 = 10;
                                        break;
                                    }
                                    default: {
                                        n11 = 6;
                                    }
                                }
                                cArray6[n10] = (char)(c2 ^ n11);
                                ++n4;
                                cArray4 = cArray7;
                                n8 = n8;
                                if (n8 != 0) break;
                                cArray7 = cArray4;
                                n7 = n8;
                                n10 = n8;
                                cArray6 = cArray4;
                            }
                            cArray3 = cArray4;
                            n7 = n8;
                        } while (n8 > n4);
                    }
                    string = new String(cArray3);
                    switch (n6) {
                        default: {
                            stringArray2[n5] = string.intern();
                            stringArray2 = stringArray3;
                            stringArray3 = stringArray3;
                            n5 = 1;
                            string2 = "'C9%g#E8ok-B0%u4U3fg7_{\u007fr-@{Hg'G8ch/m:kj=V1_r-@";
                            n6 = 0;
                            continue block18;
                        }
                        case 0: {
                            stringArray2[n5] = string.intern();
                            stringArray2 = stringArray3;
                            stringArray3 = stringArray3;
                            n5 = 2;
                            string2 = "4^;`c'X";
                            n6 = 1;
                            continue block18;
                        }
                        case 1: {
                            stringArray2[n5] = string.intern();
                            stringArray2 = stringArray3;
                            stringArray3 = stringArray3;
                            n5 = 3;
                            string2 = "\u0005^3\u007fk!B *`+^tJH+X\u001a\u007fj(\f$kt%A1~c6\fs/uc\f;l&a_z/udA!yrdB;~&&Itds(@";
                            n6 = 2;
                            continue block18;
                        }
                        case 2: {
                            stringArray2[n5] = string.intern();
                            stringArray2 = stringArray3;
                            stringArray3 = stringArray3;
                            n5 = 4;
                            string2 = "\u001f\rk&[";
                            n6 = 3;
                            continue block18;
                        }
                        case 3: 
                    }
                    break;
                }
                stringArray2[n5] = string.intern();
                b = stringArray3;
                char[] cArray8 = "\u001a\u0004|Q6uqkVb\u0018Hkv4\u001f\u001cy>[\u0018H(83\u001f\u001cy?[mpz#}wQ|Q6uqkVb\u0018Hkv4\u001f\u001cy>[\u0018H(83\u001f\u001cy?[m\b".toCharArray();
                n4 = 0;
                int n12 = cArray8.length;
                cArray2 = cArray8;
                n3 = n12;
                if (n12 <= 1) break block27;
                cArray = cArray2;
                n2 = n3;
                if (n3 <= n4) break block28;
            }
            do {
                char[] cArray9 = cArray2;
                char[] cArray10 = cArray2;
                int n13 = n4;
                while (true) {
                    int n14;
                    char c3 = cArray9[n13];
                    switch (n4 % 5) {
                        case 0: {
                            n14 = 68;
                            break;
                        }
                        case 1: {
                            n14 = 44;
                            break;
                        }
                        case 2: {
                            n14 = 84;
                            break;
                        }
                        case 3: {
                            n14 = 10;
                            break;
                        }
                        default: {
                            n14 = 6;
                        }
                    }
                    cArray9[n13] = (char)(c3 ^ n14);
                    ++n4;
                    cArray2 = cArray10;
                    n3 = n3;
                    if (n3 != 0) break;
                    cArray10 = cArray2;
                    n2 = n3;
                    n13 = n3;
                    cArray9 = cArray2;
                }
                cArray = cArray2;
                n2 = n3;
            } while (n3 > n4);
        }
        a = Pattern.compile(new String(cArray).intern());
    }
}

