/*
 * Decompiled with CFR 0.152.
 */
package com.agilemind.spyglass.views;

import com.agilemind.commons.application.data.ScanResult;
import com.agilemind.commons.application.modules.io.searchengine.data.PopularityMap;
import com.agilemind.commons.application.modules.io.searchengine.data.SearchEngineFactor;
import com.agilemind.commons.application.modules.linkinfo.data.AnchorType;
import com.agilemind.commons.application.modules.linkinfo.data.LinkInfo;
import com.agilemind.commons.data.field.Age;
import com.agilemind.commons.io.searchengine.analyzers.SearchEngineFactorsList;
import com.agilemind.commons.io.searchengine.analyzers.data.FactorType;
import com.agilemind.commons.io.searchengine.analyzers.data.IMozAuthorityResult;
import com.agilemind.commons.io.searchengine.analyzers.data.SearchEngineFactorType;
import com.agilemind.commons.io.searchengine.analyzers.parsers.IFactorParser;
import com.agilemind.commons.io.searchengine.analyzers.util.FilterSiteWithResourcePages;
import com.agilemind.commons.io.searchengine.validator.scanstatus.ScanStatus;
import com.agilemind.commons.io.utils.ip.data.IP;
import com.agilemind.commons.util.StringUtil;
import com.agilemind.commons.util.UnicodeURL;
import com.agilemind.commons.util.UnicodeURLUtil;
import com.agilemind.spyglass.data.AnalyzeRecord;
import com.agilemind.spyglass.data.BackLinksRecord;
import com.agilemind.spyglass.data.LinkRisk;
import com.agilemind.spyglass.data.LinkRiskRule;
import com.agilemind.spyglass.views.AbstractBackLinkTable;
import com.agilemind.spyglass.views.LinkRiskCache;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Set;

public class LinkRiskUtils {
    private static final String a;

    private LinkRiskUtils() {
    }

    public static LinkRisk getLinkRisk(AnalyzeRecord analyzeRecord, Collection<AnalyzeRecord> collection, LinkRiskCache linkRiskCache, boolean bl) {
        linkRiskCache.initCache(collection);
        ScanResult scanResult = analyzeRecord.getScanResult();
        ScanStatus scanStatus = scanResult.getScanStatus();
        if (scanStatus == ScanStatus.SCAN_STATUS_CHEATING_NOFOLLOW) {
            return new LinkRisk(Collections.singleton(LinkRiskRule.LINK_IS_NOFOLLOW));
        }
        if (!scanStatus.isOkStatus()) {
            return new LinkRisk(Collections.singleton(LinkRiskRule.NO_LINK_BACK));
        }
        int n2 = collection.size();
        return LinkRiskUtils.a(analyzeRecord, linkRiskCache, n2, bl);
    }

    private static LinkRisk a(AnalyzeRecord analyzeRecord, LinkRiskCache linkRiskCache, int n2, boolean bl) {
        List<SearchEngineFactorType<?>> list = LinkRiskUtils.a(analyzeRecord, bl);
        if (list.isEmpty()) {
            return LinkRiskUtils.b(analyzeRecord, linkRiskCache, n2, bl);
        }
        LinkRisk linkRisk = LinkRisk.createNotCalculatedLinkRisk();
        linkRisk.setSearchEngineTypes(list);
        return linkRisk;
    }

    private static List<SearchEngineFactorType<?>> a(AnalyzeRecord analyzeRecord, boolean bl) {
        ArrayList arrayList;
        block5: {
            PopularityMap popularityMap;
            block4: {
                arrayList = new ArrayList();
                ScanStatus scanStatus = analyzeRecord.getScanStatus();
                if (scanStatus == ScanStatus.SCAN_STATUS_UNKNOWN) {
                    arrayList.add(SearchEngineFactorsList.EXTRA_PAGE_INFO_FACTOR_TYPE);
                }
                popularityMap = analyzeRecord.getRankingFactorsMap();
                LinkRiskUtils.a(popularityMap, arrayList, SearchEngineFactorsList.GOOGLE_INDEXED_PAGES_FACTOR_TYPE);
                LinkRiskUtils.a(popularityMap, arrayList, SearchEngineFactorsList.EXTERNAL_LINKS_FACTOR_TYPE);
                LinkRiskUtils.a(popularityMap, arrayList, SearchEngineFactorsList.TOTAL_LINKS_FACTOR_TYPE);
                LinkRiskUtils.a(popularityMap, arrayList, SearchEngineFactorsList.DOMAIN_AGE_FACTOR_TYPE);
                LinkRiskUtils.a(popularityMap, arrayList, SearchEngineFactorsList.DOMAIN_IP_FACTOR_TYPE);
                if (!bl) break block4;
                LinkRiskUtils.a(popularityMap, arrayList, SearchEngineFactorsList.MOZ_AUTHORITY_FACTOR_TYPE);
                if (!AbstractBackLinkTable.e) break block5;
            }
            LinkRiskUtils.a(popularityMap, arrayList, SearchEngineFactorsList.DOMAIN_GOOGLE_PR);
            LinkRiskUtils.a(popularityMap, arrayList, SearchEngineFactorsList.PAGE_GOOGLE_PR);
        }
        return arrayList;
    }

    private static void a(PopularityMap popularityMap, List<SearchEngineFactorType<?>> list, SearchEngineFactorType<?> searchEngineFactorType) {
        SearchEngineFactor searchEngineFactor = (SearchEngineFactor)popularityMap.get(searchEngineFactorType);
        if (searchEngineFactor == null) {
            list.add(searchEngineFactorType);
        }
    }

    private static LinkRisk b(AnalyzeRecord analyzeRecord, LinkRiskCache linkRiskCache, int n2, boolean bl) {
        Object object;
        ArrayList<LinkRiskRule> arrayList;
        Integer n3;
        Long l2;
        PopularityMap popularityMap;
        block18: {
            block19: {
                boolean bl2;
                block15: {
                    block16: {
                        block17: {
                            bl2 = AbstractBackLinkTable.e;
                            popularityMap = analyzeRecord.getRankingFactorsMap();
                            l2 = (Long)popularityMap.getFactor((FactorType)SearchEngineFactorsList.GOOGLE_INDEXED_PAGES_FACTOR_TYPE).getFactorValue();
                            n3 = (Integer)popularityMap.getFactor((FactorType)SearchEngineFactorsList.EXTERNAL_LINKS_FACTOR_TYPE).getFactorValue();
                            Integer n4 = (Integer)popularityMap.getFactor((FactorType)SearchEngineFactorsList.TOTAL_LINKS_FACTOR_TYPE).getFactorValue();
                            arrayList = new ArrayList<LinkRiskRule>();
                            if (l2 == 0L) {
                                arrayList.add(LinkRiskRule.NOT_INDEXED_IN_GOOGLE);
                            }
                            if (n4 > 1000) {
                                arrayList.add(LinkRiskRule.MASSIVE_NUMBER_OF_OUTGOING_LINKS);
                            }
                            if (!bl) break block15;
                            object = (IMozAuthorityResult)popularityMap.getFactor((FactorType)SearchEngineFactorsList.MOZ_AUTHORITY_FACTOR_TYPE).getFactorValue();
                            int n5 = (int)Math.round(object.getDomainAuthority() / 10.0);
                            int n6 = (int)Math.round(object.getPageAuthority() / 10.0);
                            if (n5 == 0) {
                                arrayList.add(LinkRiskRule.NO_DA);
                            }
                            if (n6 < 1 && n3 <= 2) {
                                arrayList.add(LinkRiskRule.WEAK_PAGE_WITHOUT_EXTERNAL_LINKS_AND_NO_PA);
                            }
                            if (n5 >= 1) break block16;
                            if (!LinkRiskUtils.a(popularityMap)) break block17;
                            arrayList.add(LinkRiskRule.YOUNG_DOMAIN_WITH_LOW_DA);
                            if (!bl2) break block16;
                        }
                        if (LinkRiskUtils.b(popularityMap)) {
                            arrayList.add(LinkRiskRule.OLD_DOMAIN_WITH_LOW_DA);
                        }
                    }
                    if (!bl2) break block18;
                }
                object = (Integer)popularityMap.getFactor((FactorType)SearchEngineFactorsList.DOMAIN_GOOGLE_PR).getFactorValue();
                Integer n7 = (Integer)popularityMap.getFactor((FactorType)SearchEngineFactorsList.PAGE_GOOGLE_PR).getFactorValue();
                if ((Integer)object == -1) {
                    arrayList.add(LinkRiskRule.NO_GOOGLE_PR);
                }
                if ((n7 == -1 || n7 == 0) && n3 <= 2) {
                    arrayList.add(LinkRiskRule.WEAK_PAGE_WITHOUT_EXTERNAL_LINKS);
                }
                if ((Integer)object != -1 && (Integer)object != 0) break block18;
                if (!LinkRiskUtils.a(popularityMap)) break block19;
                arrayList.add(LinkRiskRule.YOUNG_DOMAIN_WITH_NO_PR);
                if (!bl2) break block18;
            }
            if (LinkRiskUtils.b(popularityMap)) {
                arrayList.add(LinkRiskRule.OLD_DOMAIN_WITH_NO_PR);
            }
        }
        LinkRiskUtils.a((BackLinksRecord)analyzeRecord, linkRiskCache, l2, arrayList);
        LinkRiskUtils.a(popularityMap, linkRiskCache, arrayList);
        object = analyzeRecord.getScanResult().getLinkInfo();
        if (LinkRiskUtils.a((LinkInfo)object)) {
            LinkRiskUtils.a((LinkInfo)object, linkRiskCache, arrayList, n2);
        }
        String string = analyzeRecord.getPage().toUnicodeString().toLowerCase();
        LinkRiskUtils.a(string, arrayList);
        LinkRiskUtils.a(string, n3, arrayList);
        return new LinkRisk(arrayList);
    }

    private static boolean a(PopularityMap popularityMap) {
        Date date = (Date)popularityMap.getFactor((FactorType)SearchEngineFactorsList.DOMAIN_AGE_FACTOR_TYPE).getFactorValue();
        if (!date.equals(IFactorParser.NA_DATE)) {
            Date date2 = new Age(0, 6, 0).getDate();
            return date2.before(date);
        }
        return false;
    }

    private static boolean b(PopularityMap popularityMap) {
        Date date = (Date)popularityMap.getFactor((FactorType)SearchEngineFactorsList.DOMAIN_AGE_FACTOR_TYPE).getFactorValue();
        if (!date.equals(IFactorParser.NA_DATE)) {
            Date date2 = new Age(1, 0, 0).getDate();
            return date2.after(date);
        }
        return false;
    }

    private static void a(BackLinksRecord backLinksRecord, LinkRiskCache linkRiskCache, Long l2, List<LinkRiskRule> list) {
        String string;
        Integer n2;
        UnicodeURL unicodeURL = backLinksRecord.getDomain();
        if (unicodeURL != null && (double)(n2 = linkRiskCache.getSameDomains(string = UnicodeURLUtil.getHostWithoutWWW((UnicodeURL)unicodeURL))).intValue() > (double)l2.longValue() * 0.4) {
            list.add(LinkRiskRule.SITE_WIDE_LINK);
        }
    }

    private static void a(PopularityMap popularityMap, LinkRiskCache linkRiskCache, List<LinkRiskRule> list) {
        SearchEngineFactor searchEngineFactor = popularityMap.getFactor((FactorType)SearchEngineFactorsList.DOMAIN_IP_FACTOR_TYPE);
        if (searchEngineFactor != null) {
            String string;
            Set<String> set;
            IP iP = (IP)searchEngineFactor.getFactorValue();
            Set<String> set2 = linkRiskCache.getSameIPs(iP);
            if (set2 != null && set2.size() > 1) {
                list.add(LinkRiskRule.DUPLICATE_DOMAIN_IP);
            }
            if ((set = linkRiskCache.getSameClassC(string = LinkRiskUtils.a(iP))) != null && set.size() > 1) {
                list.add(LinkRiskRule.DUPLICATE_DOMAIN_IP_C_CLASS);
            }
        }
    }

    private static void a(LinkInfo linkInfo, LinkRiskCache linkRiskCache, List<LinkRiskRule> list, int n2) {
        boolean bl = AbstractBackLinkTable.e;
        String string = linkInfo.getName().toLowerCase().trim();
        Integer n3 = linkRiskCache.getSameAnchorText(string);
        if (n3 != null && (double)n3.intValue() > (double)n2 * 0.05) {
            list.add(LinkRiskRule.MANY_SAME_ANCHORS);
        }
        Set set = StringUtil.getUniqueKeywords((String)string);
        for (String string2 : set) {
            Integer n4 = linkRiskCache.getSameAnchorKeywords(string2);
            if (n4 != null && (double)n4.intValue() > (double)n2 * 0.1) {
                list.add(LinkRiskRule.MANY_SAME_KEYWORD_IN_ANCHOR);
                if (!bl) break;
            }
            if (!bl) continue;
        }
    }

    static String a(IP iP) {
        int[] nArray = iP.getDigits();
        return "" + nArray[0] + nArray[1] + nArray[2];
    }

    static boolean a(LinkInfo linkInfo) {
        return linkInfo != null && linkInfo.getAnchorType() == AnchorType.TEXT_LINK && linkInfo.getBanner() == null && !StringUtil.isEmpty((String)linkInfo.getName());
    }

    private static void a(String string, List<LinkRiskRule> list) {
        boolean bl = AbstractBackLinkTable.e;
        for (String string2 : FilterSiteWithResourcePages.PAGE_NAMES) {
            if (!string.contains(string2)) continue;
            list.add(LinkRiskRule.LINK_DIRECTORY_LINK);
            return;
        }
    }

    private static void a(String string, Integer n2, List<LinkRiskRule> list) {
        if (n2 >= 60 && string.contains(a)) {
            list.add(LinkRiskRule.POTENTIAL_SPAM_FORUM);
        }
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        char[] cArray;
        block10: {
            int n2;
            int n3;
            char[] cArray2;
            int n4;
            block9: {
                char[] cArray3 = "J\u0016SDv".toCharArray();
                n4 = 0;
                int n5 = cArray3.length;
                cArray2 = cArray3;
                n3 = n5;
                if (n5 <= 1) break block9;
                cArray = cArray2;
                n2 = n3;
                if (n3 <= n4) break block10;
            }
            do {
                char[] cArray4 = cArray2;
                char[] cArray5 = cArray2;
                int n6 = n4;
                while (true) {
                    int n7;
                    char c2 = cArray4[n6];
                    switch (n4 % 5) {
                        case 0: {
                            n7 = 44;
                            break;
                        }
                        case 1: {
                            n7 = 121;
                            break;
                        }
                        case 2: {
                            n7 = 33;
                            break;
                        }
                        case 3: {
                            n7 = 49;
                            break;
                        }
                        default: {
                            n7 = 27;
                        }
                    }
                    cArray4[n6] = (char)(c2 ^ n7);
                    ++n4;
                    cArray2 = cArray5;
                    n3 = n3;
                    if (n3 != 0) break;
                    cArray5 = cArray2;
                    n2 = n3;
                    n6 = n3;
                    cArray4 = cArray2;
                }
                cArray = cArray2;
                n2 = n3;
            } while (n3 > n4);
        }
        a = new String(cArray).intern();
    }
}

