/*
 * Decompiled with CFR 0.152.
 */
package jxbrowser.impl;

import com.teamdev.jxbrowser.chromium.Browser;
import com.teamdev.jxbrowser.chromium.BrowserFunction;
import com.teamdev.jxbrowser.chromium.BrowserPreferences;
import com.teamdev.jxbrowser.chromium.BrowserView;
import com.teamdev.jxbrowser.chromium.CacheStorage;
import com.teamdev.jxbrowser.chromium.ContextMenuHandler;
import com.teamdev.jxbrowser.chromium.CookieStorage;
import com.teamdev.jxbrowser.chromium.DefaultLoadHandler;
import com.teamdev.jxbrowser.chromium.DefaultPopupHandler;
import com.teamdev.jxbrowser.chromium.DialogHandler;
import com.teamdev.jxbrowser.chromium.EditorCommand;
import com.teamdev.jxbrowser.chromium.JSValue;
import com.teamdev.jxbrowser.chromium.KeyFilter;
import com.teamdev.jxbrowser.chromium.LoadHTMLParams;
import com.teamdev.jxbrowser.chromium.LoadHandler;
import com.teamdev.jxbrowser.chromium.LoadParams;
import com.teamdev.jxbrowser.chromium.NavigationEntry;
import com.teamdev.jxbrowser.chromium.PopupContainer;
import com.teamdev.jxbrowser.chromium.PopupHandler;
import com.teamdev.jxbrowser.chromium.PopupParams;
import com.teamdev.jxbrowser.chromium.dom.DOMDocument;
import com.teamdev.jxbrowser.chromium.dom.DOMNodeAtPoint;
import com.teamdev.jxbrowser.chromium.events.FinishLoadingEvent;
import com.teamdev.jxbrowser.chromium.events.LoadAdapter;
import com.teamdev.jxbrowser.chromium.events.LoadListener;
import com.teamdev.jxbrowser.chromium.events.StatusListener;
import com.teamdev.jxbrowser.chromium.events.TitleListener;
import com.teamdev.jxbrowser.chromium.internal.ipc.IPCException;
import java.awt.Container;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.ComponentListener;
import java.awt.event.KeyListener;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Field;
import java.nio.charset.Charset;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.swing.JComponent;
import jxbrowser.api.BrowserSearch;
import jxbrowser.api.NavigationUrlAcceptor;
import jxbrowser.impl.JxBrowserSearch;
import jxbrowser.impl.JxBrowserSearchParams;
import jxbrowser.util.JxBrowserUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JxBrowser {
    private final Browser browser;
    private final BrowserSearch search;
    private static final Logger LOG = LoggerFactory.getLogger(JxBrowser.class);

    public JxBrowser(Browser browser) {
        this.browser = browser;
        this.search = new JxBrowserSearch(this);
        this.disablePopup();
        JxBrowserUtils.registerBrowser(this);
    }

    Browser getBrowser() {
        return this.browser;
    }

    public JComponent getComponent() {
        return this.browser.getView().getComponent();
    }

    public void navigate(String url) {
        this.browser.loadURL(url);
    }

    public void navigateBlocked(final String url) throws InterruptedException {
        this.invokeAndWaitReady(new Runnable(){

            @Override
            public void run() {
                JxBrowser.this.navigate(url);
            }
        });
    }

    public void waitReady() throws InterruptedException {
        this.waitReady(0);
    }

    public void waitReady(int milliseconds) throws InterruptedException {
        JxBrowser.waitReady(this.browser, milliseconds);
    }

    private static void waitReady(Browser browser, int milliseconds) throws InterruptedException {
        int all = 0;
        while (browser.isLoading() && all <= milliseconds) {
            if (milliseconds > 0) {
                all += 25;
            }
            TimeUnit.MILLISECONDS.sleep(25L);
        }
    }

    public BrowserPreferences getPreferences() {
        return this.browser.getPreferences();
    }

    public void goBack() {
        this.browser.goBack();
    }

    public void goForward() {
        this.browser.goForward();
    }

    public void setContent(String pageContent) {
        this.browser.loadHTML(pageContent);
    }

    public void setContent(LoadHTMLParams loadHTMLParams) {
        this.browser.loadHTML(loadHTMLParams);
    }

    public void setDialogHandler(DialogHandler dialogHandler) {
        this.browser.setDialogHandler(dialogHandler);
    }

    public void executeCommand(EditorCommand editorCommand) {
        this.browser.executeCommand(editorCommand);
    }

    public void executeCommand(EditorCommand editorCommand, String value) {
        this.browser.executeCommand(editorCommand, value);
    }

    public void stop() {
        this.browser.stop();
    }

    public void refresh() {
        this.browser.reload();
    }

    public String getCurrentLocation() {
        return this.browser.getURL();
    }

    public String getContent() {
        return this.browser.getHTML();
    }

    public boolean canGoBack() {
        return this.browser.canGoBack();
    }

    public boolean canGoForward() {
        return this.browser.canGoForward();
    }

    public BufferedImage getScreenShot(int width, int height) {
        BrowserView view = this.browser.getView();
        view.updateSize(width, height);
        Image image = view.getImage();
        BufferedImage bufferedImage = new BufferedImage(width, height, 6);
        Graphics2D graphics = (Graphics2D)bufferedImage.getGraphics();
        graphics.drawImage(image, 0, 0, null);
        return bufferedImage;
    }

    public JSValue executeJavaScript(String s) {
        return this.executeJavaScript(s, "UTF-8");
    }

    public JSValue executeJavaScript(String s, String encoding) {
        boolean needReset;
        String systemEncoding = System.getProperty("file.encoding");
        boolean bl = needReset = !systemEncoding.equals(encoding);
        if (needReset) {
            this.resetCharset(encoding);
        }
        JSValue jsValue = this.browser.executeJavaScriptAndReturnValue(s);
        if (needReset) {
            this.resetCharset(systemEncoding);
        }
        return jsValue;
    }

    private void resetCharset(String encoding) {
        System.setProperty("file.encoding", encoding);
        try {
            Field charset = Charset.class.getDeclaredField("defaultCharset");
            charset.setAccessible(true);
            charset.set(null, null);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            this.logStackTrace(e);
        }
    }

    private void logStackTrace(Throwable e) {
        StringWriter sw = new StringWriter();
        e.printStackTrace(new PrintWriter(sw));
        LOG.error(sw.toString());
    }

    public String executeScript(String s) {
        return this.executeScript(s, "UTF-8");
    }

    public String executeScript(String s, String encoding) {
        JSValue jsValue = this.executeJavaScript(s, encoding);
        return jsValue.isString() ? jsValue.getString() : jsValue.toString();
    }

    public DOMDocument getDocument() {
        return this.browser.getDocument();
    }

    public void dispose() {
        JxBrowserUtils.unregisterBrowser(this);
        Container parent = this.browser.getView().getComponent().getParent();
        if (parent != null) {
            parent.remove(this.browser.getView().getComponent());
            this.browser.getView().getComponent().removeNotify();
            parent.invalidate();
        }
        try {
            this.browser.dispose();
        }
        catch (IPCException e) {
            this.logStackTrace(e);
        }
    }

    public CookieStorage getCookieStorage() {
        return this.browser.getCookieStorage();
    }

    public CacheStorage getCacheStorage() {
        return this.browser.getCacheStorage();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof JxBrowser)) {
            return false;
        }
        JxBrowser jxBrowser = (JxBrowser)o;
        return this.browser.equals(jxBrowser.browser);
    }

    public int hashCode() {
        return this.browser.hashCode();
    }

    public BrowserSearch getSearch() {
        return this.search;
    }

    public void findPrevious(JxBrowserSearchParams jxBrowserSearchParams) {
        this.search.findPrevious(jxBrowserSearchParams);
    }

    public void findNext(JxBrowserSearchParams jxBrowserSearchParams) {
        this.search.findNext(jxBrowserSearchParams);
    }

    public void addNavigationUrlAcceptor(final NavigationUrlAcceptor navigationUrlAcceptor) {
        this.browser.setLoadHandler((LoadHandler)new DefaultLoadHandler(){

            public boolean onLoad(LoadParams loadParams) {
                return !navigationUrlAcceptor.acceptURL(loadParams.getURL());
            }
        });
    }

    private void disablePopup() {
        this.browser.setPopupHandler((PopupHandler)new DisablePopupHandler());
    }

    public void setPopupHandler(PopupHandler popupHandler) {
        this.browser.setPopupHandler(popupHandler);
    }

    public void addMouseListener(MouseListener mouseListener) {
        this.getAvtComponent().addMouseListener(mouseListener);
    }

    public void addKeyListener(KeyListener listener) {
        this.getAvtComponent().addKeyListener(listener);
    }

    public void addComponentListener(ComponentListener componentListener) {
        this.getAvtComponent().addComponentListener(componentListener);
    }

    private JComponent getAvtComponent() {
        return this.browser.getView().getComponent();
    }

    public void addNavigationListener(LoadListener loadListener) {
        this.browser.addLoadListener(loadListener);
    }

    public void addTitleListener(TitleListener titleListener) {
        this.browser.addTitleListener(titleListener);
    }

    public void addStatusListener(StatusListener statusListener) {
        this.browser.addStatusListener(statusListener);
    }

    public void setKeyFilter(KeyFilter keyFilter) {
        this.browser.getView().setKeyFilter(keyFilter);
    }

    public void setContextMenuHandler(ContextMenuHandler contextMenuHandler) {
        this.browser.setContextMenuHandler(contextMenuHandler);
    }

    public void registerFunction(String functionName, BrowserFunction browserFunction) {
        this.browser.registerFunction(functionName, browserFunction);
    }

    public void unregisterFunction(String functionName) {
        this.browser.unregisterFunction(functionName);
    }

    public boolean isNavigationFinished() {
        return !this.browser.isLoading();
    }

    public boolean isDisposed() {
        return this.browser.isDisposed();
    }

    public boolean isLoading() {
        return this.browser.isLoading();
    }

    public NavigationEntry getCurrentNavigationEntry() {
        return this.browser.getCurrentNavigationEntry();
    }

    public DOMNodeAtPoint getNodeAtPoint(int x, int y) {
        return this.browser.getNodeAtPoint(x, y);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invokeAndWaitReady(Runnable runnable) throws InterruptedException {
        final CountDownLatch latch = new CountDownLatch(1);
        LoadAdapter listener = new LoadAdapter(){

            public void onFinishLoadingFrame(FinishLoadingEvent event) {
                if (event.isMainFrame()) {
                    latch.countDown();
                }
            }
        };
        this.browser.addLoadListener((LoadListener)listener);
        try {
            runnable.run();
            if (!latch.await(45L, TimeUnit.SECONDS)) {
                throw new RuntimeException(new TimeoutException());
            }
        }
        finally {
            this.browser.removeLoadListener((LoadListener)listener);
        }
    }

    private static class DisablePopupHandler
    extends DefaultPopupHandler {
        private DisablePopupHandler() {
        }

        public PopupContainer handlePopup(PopupParams popupParams) {
            return new PopupContainer(){

                public void insertBrowser(Browser browser, Rectangle rectangle) {
                }
            };
        }
    }
}

