/*
 * Decompiled with CFR 0.152.
 */
package jxbrowser.impl;

import com.teamdev.jxbrowser.chromium.AuthRequiredParams;
import com.teamdev.jxbrowser.chromium.CustomProxyConfig;
import com.teamdev.jxbrowser.chromium.DefaultNetworkDelegate;
import com.teamdev.jxbrowser.chromium.HostPortPair;
import com.teamdev.jxbrowser.chromium.NetworkDelegate;
import com.teamdev.jxbrowser.chromium.ProxyConfig;
import jxbrowser.api.ChromiumProxyConfig;

public class JxBrowserChromiumProxyConfig
implements ChromiumProxyConfig {
    private NetworkDelegate networkDelegate = new DefaultNetworkDelegate();
    private ProxyConfig proxyConfig;

    @Override
    public void setProxy(String proxyHost, int proxyPort, final String userName, final String password, boolean useProxyAuth) {
        HostPortPair httpServer = new HostPortPair(proxyHost, proxyPort);
        HostPortPair httpsServer = new HostPortPair(proxyHost, proxyPort);
        HostPortPair ftpServer = new HostPortPair(proxyHost, proxyPort);
        this.proxyConfig = new CustomProxyConfig(httpServer, httpsServer, ftpServer);
        if (useProxyAuth) {
            this.networkDelegate = new DefaultNetworkDelegate(){

                public boolean onAuthRequired(AuthRequiredParams params) {
                    if (params.isProxy()) {
                        params.setUsername(userName);
                        params.setPassword(password);
                        return false;
                    }
                    return true;
                }
            };
        }
    }

    @Override
    public void removeProxy() {
        this.proxyConfig = null;
        this.networkDelegate = new DefaultNetworkDelegate();
    }

    @Override
    public ProxyConfig getProxyConfig() {
        return this.proxyConfig;
    }

    @Override
    public NetworkDelegate getNetworkDelegate() {
        return this.networkDelegate;
    }

    public static ChromiumProxyConfig createDefault() {
        return new JxBrowserChromiumProxyConfig();
    }
}

