/*
 * Decompiled with CFR 0.152.
 */
package jxbrowser.util;

import com.teamdev.jxbrowser.chromium.Browser;
import com.teamdev.jxbrowser.chromium.BrowserContext;
import com.teamdev.jxbrowser.chromium.BrowserFactory;
import com.teamdev.jxbrowser.chromium.BrowserPreferences;
import com.teamdev.jxbrowser.chromium.LoggerProvider;
import com.teamdev.jxbrowser.chromium.ProxyConfig;
import com.teamdev.jxbrowser.chromium.internal.ChromiumBuild;
import com.teamdev.jxbrowser.chromium.internal.ChromiumExtractor;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import javax.swing.JFrame;
import jxbrowser.api.ChromiumProxyConfig;
import jxbrowser.impl.JxBrowser;
import jxbrowser.impl.JxBrowserChromiumProxyConfig;
import jxbrowser.impl.JxBrowserCreationCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JxBrowserUtils {
    private static final Logger LOG = LoggerFactory.getLogger(JxBrowserUtils.class);
    private static final String OS_NAME = System.getProperty("os.name").toLowerCase();
    private static final Set<JxBrowser> browsers = Collections.synchronizedSet(new HashSet());
    private static ChromiumProxyConfig proxyConfig;
    private static Throwable initError;
    private static boolean tryAgain;
    public static String appName;
    private static BrowserContext browserContext;

    public static void createBrowser(JxBrowserCreationCallback callBack) {
        BrowserCreator creator = new BrowserCreator(callBack);
        creator.start();
    }

    public static JxBrowser createBrowser() {
        if (initError == null) {
            try {
                return new BrowserCreator().create();
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    public static void registerBrowser(JxBrowser browser) {
        boolean added = browsers.add(browser);
        assert (added);
    }

    public static void unregisterBrowser(JxBrowser browser) {
        boolean removed = browsers.remove(browser);
        assert (removed);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void shutDownAll() {
        Set<JxBrowser> set = browsers;
        synchronized (set) {
            for (JxBrowser browser : new HashSet<JxBrowser>(browsers)) {
                if (browser == null) continue;
                browser.dispose();
            }
        }
    }

    public static boolean initialize(File applicationDir, String appName) throws IOException {
        JxBrowserUtils.appName = appName;
        String chromiumVersion = ChromiumBuild.version();
        String path = applicationDir.getCanonicalPath() + File.separator + "jxbrowser-chromium-" + chromiumVersion;
        String dataPath = path + File.separator + "data";
        dataPath = JxBrowserUtils.correctDataPath(dataPath);
        browserContext = new BrowserContext(dataPath);
        proxyConfig = JxBrowserChromiumProxyConfig.createDefault();
        BrowserPreferences.setChromiumDir((String)path);
        try {
            ChromiumExtractor chromiumExtractor = ChromiumExtractor.create();
            if (chromiumExtractor.shouldExtract(path)) {
                chromiumExtractor.extract(path);
            }
        }
        catch (Exception e) {
            initError = e;
            LOG.error(e.getMessage(), (Throwable)e);
            return false;
        }
        BrowserPreferences.setChromiumSwitches((String[])new String[]{"--automation-channel", "--automation-reinitialize-on-channel-error", "--debug-on-start", "--enable-autologin", "--stable-release-mode", "--enable-file-cookies", "--no-default-browser-check", "--no-experiments", "--touch-events", "--allow-cross-origin-auth-prompt", "--disable-gpu"});
        return true;
    }

    private static String correctDataPath(String dataPath) {
        if (dataPath.length() == 75 && JxBrowserUtils.isOSX()) {
            dataPath = dataPath + 's';
            LOG.error(dataPath);
        }
        return dataPath;
    }

    private static boolean isOSX() {
        return OS_NAME.startsWith("mac os x");
    }

    public static boolean isInitialized() {
        return initError == null;
    }

    public static Throwable getInitError() {
        return initError;
    }

    public static void setManualProxy(String proxyHost, int proxyPort, String userName, String password, boolean useProxyAuth, boolean useProxy) {
        if (useProxy) {
            proxyConfig.setProxy(proxyHost, proxyPort, userName, password, useProxyAuth);
        } else {
            proxyConfig.removeProxy();
        }
    }

    public static boolean isEmpty(String searchString) {
        return searchString == null || searchString.trim().length() == 0;
    }

    public static void main(String[] args) throws InterruptedException {
        JxBrowser browser = JxBrowserUtils.createBrowser();
        Objects.requireNonNull(browser);
        JFrame frame = new JFrame();
        frame.add((Component)browser.getComponent(), "Center");
        frame.setSize(700, 500);
        frame.setLocationRelativeTo(null);
        frame.setDefaultCloseOperation(3);
        frame.setVisible(true);
        browser.navigate("http://tut.by");
        JxBrowserUtils.setManualProxy("192.168.0.254", 3128, null, null, false, true);
        browser.waitReady();
    }

    public static void checkInit() {
        if (initError != null) {
            throw new RuntimeException(initError);
        }
    }

    static {
        tryAgain = true;
        String logLevelProperty = System.getProperty("browserLogLevel");
        Level logLevel = logLevelProperty != null ? Level.parse(logLevelProperty) : Level.WARNING;
        LoggerProvider.getBrowserLogger().setLevel(logLevel);
        LoggerProvider.getIPCLogger().setLevel(logLevel);
        LoggerProvider.getChromiumProcessLogger().setLevel(logLevel);
    }

    private static class BrowserCreator
    extends Thread {
        private JxBrowserCreationCallback callBack;

        BrowserCreator(JxBrowserCreationCallback callBack) {
            this.callBack = callBack;
        }

        BrowserCreator() {
        }

        @Override
        public void run() {
            block3: {
                try {
                    JxBrowser jxBrowser = this.create();
                    if (this.callBack != null) {
                        this.callBack.browserCreated(jxBrowser);
                    }
                }
                catch (Throwable e) {
                    LOG.error(e.getMessage());
                    if (this.callBack == null) break block3;
                    this.callBack.browserCreationFailed(e);
                }
            }
        }

        private JxBrowser create() throws Throwable {
            if (initError == null) {
                try {
                    Browser browser = BrowserFactory.create((BrowserContext)browserContext, (ProxyConfig)proxyConfig.getProxyConfig());
                    browser.getContext().setNetworkDelegate(proxyConfig.getNetworkDelegate());
                    return new JxBrowser(browser);
                }
                catch (Throwable e) {
                    if (tryAgain) {
                        tryAgain = false;
                        return this.create();
                    }
                    throw e;
                }
            }
            throw initError;
        }
    }
}

