/*
 * Decompiled with CFR 0.152.
 */
package org.ftp4che;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PipedInputStream;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.net.ServerSocketFactory;
import javax.net.ssl.KeyManager;
import javax.net.ssl.TrustManager;
import javax.swing.event.EventListenerList;
import org.ftp4che.a;
import org.ftp4che.commands.Command;
import org.ftp4che.commands.ListCommand;
import org.ftp4che.commands.RetrieveCommand;
import org.ftp4che.commands.StoreCommand;
import org.ftp4che.event.FTPEvent;
import org.ftp4che.event.FTPListener;
import org.ftp4che.exception.AuthenticationNotSupportedException;
import org.ftp4che.exception.ConfigurationException;
import org.ftp4che.exception.FtpFileNotFoundException;
import org.ftp4che.exception.FtpIOException;
import org.ftp4che.exception.FtpWorkflowException;
import org.ftp4che.exception.NotConnectedException;
import org.ftp4che.exception.UnkownReplyStateException;
import org.ftp4che.io.ReplyWorker;
import org.ftp4che.io.SocketProvider;
import org.ftp4che.proxy.Proxy;
import org.ftp4che.reply.Reply;
import org.ftp4che.reply.ReplyCode;
import org.ftp4che.util.ReplyFormatter;
import org.ftp4che.util.ftpfile.FTPFile;
import org.ftp4che.util.ftpfile.FTPFileFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class FTPConnection {
    private static final Logger a;
    protected EventListenerList listenerList = new EventListenerList();
    public static final int FTP_CONNECTION = 1;
    public static final int IMPLICIT_SSL_FTP_CONNECTION = 2;
    public static final int AUTH_SSL_FTP_CONNECTION = 3;
    public static final int AUTH_TLS_FTP_CONNECTION = 4;
    public static final int IMPLICIT_TLS_FTP_CONNECTION = 5;
    public static final int IMPLICIT_TLS_WITH_CRYPTED_DATA_FTP_CONNECTION = 6;
    public static final int IMPLICIT_SSL_WITH_CRYPTED_DATA_FTP_CONNECTION = 7;
    public static final int MAX_DOWNLOAD_BANDWIDTH = Integer.MAX_VALUE;
    public static final int MAX_UPLOAD_BANDWIDTH = Integer.MAX_VALUE;
    public static final int CONNECTED = 1001;
    public static final int DISCONNECTED = 1002;
    public static final int IDLE = 1003;
    public static final int BUSY = 1010;
    public static final int RECEIVING_FILE = 1004;
    public static final int SENDING_FILE = 1005;
    public static final int FXP_FILE = 1006;
    public static final int UNKNOWN = 9999;
    public static final int ERROR = 1011;
    public static final int RECEIVING_FILE_STARTED = 2001;
    public static final int RECEIVING_FILE_ENDED = 2002;
    public static final int SENDING_FILE_STARTED = 2003;
    public static final int SENDING_FILE_ENDED = 2004;
    public static final int FXPING_FILE_STARTED = 2005;
    public static final int FXPING_FILE_ENDED = 2006;
    public static final int CSL_DIRECT_CALL = 0;
    public static final int CSL_INDIRECT_CALL = 1;
    public static final int CSL_2WAY_INDIRECT_CALL = 2;
    private int b = 1;
    private String c = null;
    private boolean d = false;
    private InetSocketAddress e = null;
    private String f = "";
    private String g = "";
    private String h = "";
    private boolean i = false;
    private int j = 10000;
    private int k = Integer.MAX_VALUE;
    private int l = Integer.MAX_VALUE;
    private Charset m = Charset.forName(B[7]);
    private CharsetEncoder n = this.m.newEncoder();
    private CharBuffer o = CharBuffer.allocate(1024);
    protected SocketProvider socketProvider = null;
    private int p = 9999;
    private int q = 0;
    private Proxy r = null;
    protected FTPFileFactory factory;
    private String s = null;
    private TrustManager[] t = new TrustManager[0];
    private KeyManager[] u = new KeyManager[0];
    private boolean v = false;
    private boolean w = false;
    private boolean x = false;
    private boolean y = false;
    private String z = B[6];
    public static boolean A;
    private static final String[] B;

    public InetSocketAddress getAddress() {
        return this.e;
    }

    public void setAddress(InetSocketAddress inetSocketAddress) {
        this.e = inetSocketAddress;
    }

    protected String getPassword() {
        return this.g;
    }

    protected void setPassword(String string) {
        this.g = string;
    }

    public String getUser() {
        return this.f;
    }

    protected void setUser(String string) throws ConfigurationException {
        block4: {
            if (string != null && string.length() != 0) break block4;
            throw new ConfigurationException(B[20]);
        }
        this.f = string;
    }

    public String getAccount() {
        return this.h;
    }

    public void setAccount(String string) {
        this.h = string;
    }

    public abstract void connect() throws NotConnectedException, IOException, AuthenticationNotSupportedException, FtpIOException, FtpWorkflowException;

    public void disconnect() {
        try {
            Command command = new Command(B[28]);
            this.sendCommand(command).dumpReply();
            this.socketProvider.close();
        }
        catch (IOException iOException) {
            a.warn(B[29] + this.getAddress().getHostName() + ":" + this.getAddress().getPort(), (Throwable)iOException);
        }
        this.socketProvider = null;
        this.setConnectionStatusLock(0);
        this.setConnectionStatus(1002);
    }

    public Reply sendCommand(Command command) throws IOException {
        Reply reply;
        if (this.getConnectionStatusLock() == 0) {
            this.setConnectionStatus(1010);
        }
        this.o.clear();
        a.debug(B[17] + command.toString().substring(0, command.toString().length() - 2));
        this.o.put(command.toString());
        this.o.flip();
        this.socketProvider.write(this.n.encode(this.o));
        this.o.clear();
        try {
            reply = ReplyWorker.readReply(this.socketProvider);
        }
        catch (IOException iOException) {
            this.setConnectionStatus(1011);
            this.disconnect();
            throw iOException;
        }
        if (this.getConnectionStatusLock() == 0) {
            this.setConnectionStatus(1003);
        }
        if (reply != null) {
            this.fireReplyMessageArrived(new FTPEvent(this, this.getConnectionStatus(), reply));
        }
        return reply;
    }

    public int getConnectionStatus() {
        return this.p;
    }

    protected void setConnectionStatus(int n) {
        this.p = n;
        this.fireConnectionStatusChanged(new FTPEvent(this, n));
    }

    protected void setConnectionStatus(int n, FTPFile fTPFile, FTPFile fTPFile2) {
        this.p = n;
        this.fireConnectionStatusChanged(new FTPEvent(this, n, fTPFile, fTPFile2));
    }

    public int getConnectionStatusLock() {
        return this.q;
    }

    protected void setConnectionStatusLock(int n) {
        this.q = n;
    }

    protected void setTimeout(int n) {
        this.j = n;
    }

    protected int getTimeout() {
        return this.j;
    }

    public void changeDirectory(String string) throws IOException, FtpWorkflowException, FtpIOException {
        Command command = new Command(B[78], string);
        Reply reply = this.sendCommand(command);
        reply.dumpReply();
        reply.validate();
        this.s = null;
    }

    public String getWorkDirectory() throws IOException, UnkownReplyStateException, FtpWorkflowException, FtpIOException {
        if (this.s == null) {
            Command command = new Command(B[5]);
            Reply reply = this.sendCommand(command);
            reply.dumpReply();
            reply.validate();
            this.s = ReplyFormatter.parsePWDReply(reply);
        }
        return this.s;
    }

    public void changeToParentDirectory() throws IOException, FtpWorkflowException, FtpIOException {
        Command command = new Command(B[82]);
        Reply reply = this.sendCommand(command);
        reply.dumpReply();
        reply.validate();
        this.s = null;
    }

    public void makeDirectory(String string) throws IOException, FtpWorkflowException, FtpIOException {
        Command command = new Command(B[10], string);
        Reply reply = this.sendCommand(command);
        reply.dumpReply();
        reply.validate();
    }

    public void removeDirectory(String string) throws IOException, FtpWorkflowException, FtpIOException {
        Command command = new Command(B[4], string);
        Reply reply = this.sendCommand(command);
        reply.dumpReply();
        reply.validate();
    }

    public void noOperation() throws IOException, FtpWorkflowException, FtpIOException {
        Command command = new Command(B[27]);
        Reply reply = this.sendCommand(command);
        reply.dumpReply();
        reply.validate();
    }

    public InetSocketAddress sendPassiveMode() throws IOException, FtpWorkflowException, FtpIOException {
        Command command = new Command(B[93]);
        try {
            Reply reply = this.sendCommand(command);
            reply.dumpReply();
            reply.validate();
            return ReplyFormatter.parsePASVCommand(reply);
        }
        catch (UnkownReplyStateException unkownReplyStateException) {
            a.error(B[94], (Throwable)unkownReplyStateException);
            return null;
        }
    }

    public void setPassiveMode(boolean bl) {
        this.i = bl;
    }

    public boolean isPassiveMode() {
        return this.i;
    }

    public List getDirectoryListing() throws IOException, FtpWorkflowException, FtpIOException {
        return this.getDirectoryListing(this.getWorkDirectory());
    }

    public List getFastDirectoryListing() throws IOException, FtpWorkflowException, FtpIOException {
        String string = this.getWorkDirectory();
        Command command = new Command(B[36], B[37]);
        Reply reply = this.sendCommand(command);
        reply.validate();
        return this.factory.parse(reply.getLines(), string);
    }

    public List getFastDirectoryListing(String string) throws IOException, FtpWorkflowException, FtpIOException {
        Command command = new Command(B[39], B[38] + string);
        Reply reply = this.sendCommand(command);
        reply.validate();
        return this.factory.parse(reply.getLines(), string);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List getDirectoryListing(String string) throws IOException, FtpWorkflowException, FtpIOException {
        SocketProvider socketProvider;
        Object object;
        Object object2;
        String string2;
        ListCommand listCommand;
        block13: {
            block12: {
                this.setConnectionStatusLock(1);
                this.setConnectionStatus(1010);
                listCommand = new ListCommand(string);
                string2 = this.getWorkDirectory();
                if (this.getConnectionType() == 3 || this.getConnectionType() == 4 || this.getConnectionType() == 7) {
                    object2 = new Command(B[0], "0");
                    this.sendCommand((Command)object2).dumpReply();
                    object = new Command(B[1], "P");
                    this.sendCommand((Command)object).dumpReply();
                }
                object2 = new Reply();
                if (!this.isPassiveMode()) break block12;
                socketProvider = this.a(listCommand, (Reply)object2);
                if (!A) break block13;
            }
            socketProvider = this.sendPortCommand(listCommand, (Reply)object2);
        }
        listCommand.setDataSocket(socketProvider);
        try {
            object = this.factory.parse(listCommand.fetchDataConnectionReply().getLines(), string2);
        }
        catch (IOException iOException) {
            this.setConnectionStatus(1011);
            this.disconnect();
            throw iOException;
        }
        if (((Reply)object2).getLines().size() == 1) {
            try {
                ReplyWorker.readReply(this.socketProvider).dumpReply();
            }
            catch (IOException iOException) {
                this.setConnectionStatus(1011);
                this.disconnect();
                throw iOException;
            }
        }
        this.setConnectionStatus(1003);
        this.setConnectionStatusLock(0);
        return object;
    }

    public SocketProvider sendPortCommand(Command command, Reply reply) throws IOException, FtpWorkflowException, FtpIOException {
        SocketProvider socketProvider;
        block16: {
            boolean bl;
            block18: {
                block17: {
                    SocketProvider socketProvider2;
                    boolean bl2;
                    block15: {
                        block14: {
                            block20: {
                                Reply reply2;
                                Command command2;
                                StringBuilder stringBuilder;
                                int n;
                                Object object;
                                Object object2;
                                block19: {
                                    bl2 = A;
                                    this.setConnectionStatusLock(1);
                                    this.setConnectionStatus(1010);
                                    if (this.getProxy() != null) break block19;
                                    object2 = ServerSocketFactory.getDefault().createServerSocket();
                                    object = new InetSocketAddress(this.socketProvider.socket().getLocalAddress(), 0);
                                    ((ServerSocket)object2).bind((SocketAddress)object);
                                    n = ((ServerSocket)object2).getLocalPort();
                                    stringBuilder = new StringBuilder();
                                    stringBuilder.append(((ServerSocket)object2).getInetAddress().getHostAddress().replace('.', ','));
                                    stringBuilder.append(",");
                                    stringBuilder.append(n >> 8);
                                    stringBuilder.append(",");
                                    stringBuilder.append(n & 0xFF);
                                    command2 = new Command(B[65], stringBuilder.toString());
                                    reply2 = this.sendCommand(command2);
                                    reply2.dumpReply();
                                    reply2.validate();
                                    reply.setLines(this.sendCommand(command).getLines());
                                    reply.dumpReply();
                                    reply.validate();
                                    socketProvider2 = new SocketProvider(((ServerSocket)object2).accept(), false, this.getDownloadBandwidth(), this.getUploadBandwidth());
                                    if (!bl2) break block20;
                                }
                                object2 = new InetSocketAddress(this.getAddress().getAddress(), 0);
                                object = this.getProxy().bind((InetSocketAddress)object2);
                                n = this.getProxy().getBindAddress().getPort();
                                stringBuilder = new StringBuilder();
                                stringBuilder.append(this.getProxy().getProxyAddress().getAddress().getHostAddress().replace('.', ','));
                                stringBuilder.append(",");
                                stringBuilder.append(n >> 8);
                                stringBuilder.append(",");
                                stringBuilder.append(n & 0xFF);
                                command2 = new Command(B[64], stringBuilder.toString());
                                reply2 = this.sendCommand(command2);
                                reply2.dumpReply();
                                reply2.validate();
                                reply.setLines(this.sendCommand(command).getLines());
                                reply.dumpReply();
                                reply.validate();
                                socketProvider2 = new SocketProvider((Socket)object, false, this.getDownloadBandwidth(), this.getUploadBandwidth());
                            }
                            socketProvider2.socket().setReceiveBufferSize(65536);
                            socketProvider2.socket().setSendBufferSize(65536);
                            socketProvider2.setSSLMode(this.getConnectionType());
                            if (this.b == 4 || this.b == 3) break block14;
                            if (this.b == 7) break block14;
                            if (this.b != 6) break block15;
                        }
                        socketProvider2.negotiate(this.getTrustManagers(), this.getKeyManagers());
                    }
                    this.setConnectionStatus(1003);
                    this.setConnectionStatusLock(0);
                    socketProvider = socketProvider2;
                    if (Command.d == 0) break block16;
                    if (!bl2) break block17;
                    bl = false;
                    break block18;
                }
                bl = true;
            }
            A = bl;
        }
        return socketProvider;
    }

    public void downloadFile(FTPFile fTPFile, FTPFile fTPFile2) throws IOException, FtpWorkflowException, FtpIOException {
        this.downloadFile(fTPFile, fTPFile2, false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void downloadFile(FTPFile fTPFile, FTPFile fTPFile2, boolean bl) throws IOException, FtpWorkflowException, FtpIOException {
        SocketProvider socketProvider;
        Object object;
        RetrieveCommand retrieveCommand;
        block27: {
            block26: {
                Object object2;
                boolean bl2;
                block24: {
                    block25: {
                        bl2 = A;
                        this.setConnectionStatusLock(1);
                        this.setConnectionStatus(2001, fTPFile, fTPFile2);
                        this.setConnectionStatus(1004);
                        retrieveCommand = new RetrieveCommand(B[16], fTPFile, fTPFile2);
                        if (this.getConnectionType() == 3 || this.getConnectionType() == 4) {
                            object2 = new Command(B[11], "0");
                            this.sendCommand((Command)object2).dumpReply();
                            object = new Command(B[14], "P");
                            this.sendCommand((Command)object).dumpReply();
                        }
                        if (!bl && !this.v) break block24;
                        if (fTPFile.getSize() <= 0L) {
                            object2 = this.getDirectoryListing(fTPFile.getPath());
                            object = object2.iterator();
                            while (object.hasNext()) {
                                FTPFile fTPFile3 = (FTPFile)object.next();
                                if (fTPFile3.getName().equals(fTPFile.getName())) {
                                    fTPFile.setSize(fTPFile3.getSize());
                                }
                                if (!bl2) continue;
                            }
                        }
                        if (fTPFile.getSize() == fTPFile2.getSize()) break block25;
                        retrieveCommand.setResumePosition(fTPFile2.getSize());
                        object2 = new Command(B[13], "" + fTPFile2.getSize());
                        object = this.sendCommand((Command)object2);
                        ((Reply)object).dumpReply();
                        try {
                            ((Reply)object).validate();
                        }
                        catch (FtpWorkflowException ftpWorkflowException) {
                            a.error(B[15] + ftpWorkflowException.getMessage());
                        }
                        catch (FtpIOException ftpIOException) {
                            a.error(B[12] + ftpIOException.getMessage());
                        }
                        if (!bl2) break block24;
                    }
                    return;
                }
                object2 = new Command(this.z);
                this.sendCommand((Command)object2).dumpReply();
                object = new Reply();
                if (!this.isPassiveMode()) break block26;
                socketProvider = this.a(retrieveCommand, (Reply)object);
                if (!bl2) break block27;
            }
            socketProvider = this.sendPortCommand(retrieveCommand, (Reply)object);
        }
        retrieveCommand.setDataSocket(socketProvider);
        try {
            retrieveCommand.fetchDataConnectionReply();
        }
        catch (IOException iOException) {
            this.setConnectionStatus(1011);
            this.disconnect();
            throw iOException;
        }
        if (((Reply)object).getLines().size() == 1) {
            try {
                ReplyWorker.readReply(this.socketProvider).dumpReply();
            }
            catch (IOException iOException) {
                this.setConnectionStatus(1011);
                this.disconnect();
                throw iOException;
            }
        }
        this.setConnectionStatus(2002, fTPFile, fTPFile2);
        this.setConnectionStatus(1003);
        this.setConnectionStatusLock(0);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public InputStream downloadStream(FTPFile fTPFile) throws IOException, FtpWorkflowException, FtpIOException {
        boolean bl = A;
        PipedInputStream pipedInputStream = new PipedInputStream();
        new a(this, this, fTPFile, pipedInputStream).start();
        try {
            for (int i = 0; i < 60; ++i) {
                try {
                    if (pipedInputStream.available() > 0) return pipedInputStream;
                    Thread.sleep(1000L);
                    if (!bl) continue;
                    return pipedInputStream;
                }
                catch (Exception exception) {
                    throw exception;
                    return pipedInputStream;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return pipedInputStream;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void a(FTPFile fTPFile, PipedInputStream pipedInputStream) throws IOException, FtpWorkflowException, FtpIOException {
        SocketProvider socketProvider;
        Object object;
        RetrieveCommand retrieveCommand;
        block12: {
            block11: {
                Command command;
                this.setConnectionStatusLock(1);
                this.setConnectionStatus(2001, fTPFile, null);
                this.setConnectionStatus(1004);
                retrieveCommand = new RetrieveCommand(B[90], fTPFile, pipedInputStream);
                if (this.getConnectionType() == 3 || this.getConnectionType() == 4) {
                    command = new Command(B[92], "0");
                    this.sendCommand(command).dumpReply();
                    object = new Command(B[91], "P");
                    this.sendCommand((Command)object).dumpReply();
                }
                command = new Command(this.z);
                this.sendCommand(command).dumpReply();
                object = new Reply();
                if (!this.isPassiveMode()) break block11;
                socketProvider = this.a(retrieveCommand, (Reply)object);
                if (!A) break block12;
            }
            socketProvider = this.sendPortCommand(retrieveCommand, (Reply)object);
        }
        retrieveCommand.setDataSocket(socketProvider);
        try {
            retrieveCommand.fetchDataConnectionReply(1);
        }
        catch (IOException iOException) {
            this.setConnectionStatus(1011);
            this.disconnect();
            throw iOException;
        }
        if (((Reply)object).getLines().size() == 1) {
            try {
                ReplyWorker.readReply(this.socketProvider).dumpReply();
            }
            catch (IOException iOException) {
                this.setConnectionStatus(1011);
                this.disconnect();
                throw iOException;
            }
        }
        this.setConnectionStatus(2002, fTPFile, null);
        this.setConnectionStatus(1003);
        this.setConnectionStatusLock(0);
    }

    public void downloadDirectory(FTPFile fTPFile, FTPFile fTPFile2) throws IOException, FtpWorkflowException, FtpIOException {
        boolean bl = A;
        if (!fTPFile.isDirectory()) {
            throw new FtpFileNotFoundException(B[59] + fTPFile.getName() + B[58]);
        }
        new File(fTPFile2.toString()).mkdir();
        String string = fTPFile.toString();
        String string2 = string.endsWith("/") ? string.substring(0, string.length() - 1) : string;
        string = string2;
        List list = this.getDirectoryListing(string);
        Collections.sort(list);
        for (FTPFile fTPFile3 : list) {
            block11: {
                block10: {
                    fTPFile3.setPath(fTPFile.toString());
                    if (fTPFile3.isDirectory()) break block10;
                    this.downloadFile(fTPFile3, new FTPFile(fTPFile2.toString(), fTPFile3.getName(), false));
                    if (!bl) break block11;
                }
                this.downloadDirectory(fTPFile3, new FTPFile(fTPFile2.toString(), fTPFile3.getName(), true));
            }
            if (!bl) continue;
        }
    }

    public void uploadFile(FTPFile fTPFile, FTPFile fTPFile2) throws IOException, FtpWorkflowException, FtpIOException {
        this.uploadFile(fTPFile, fTPFile2, false);
    }

    public void uploadFile(FTPFile fTPFile, FTPFile fTPFile2, boolean bl) throws IOException, FtpWorkflowException, FtpIOException {
        this.a(fTPFile, fTPFile2, bl);
    }

    public void uploadStream(InputStream inputStream, FTPFile fTPFile) throws IOException, FtpWorkflowException, FtpIOException {
        this.a(inputStream, fTPFile, false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void a(Object object, FTPFile fTPFile, boolean bl) throws IOException, FtpWorkflowException, FtpIOException {
        SocketProvider socketProvider;
        Object object2;
        StoreCommand storeCommand;
        FTPFile fTPFile2;
        block31: {
            block30: {
                Object object3;
                boolean bl2;
                block28: {
                    block29: {
                        bl2 = A;
                        fTPFile2 = null;
                        if (object instanceof FTPFile) {
                            fTPFile2 = (FTPFile)object;
                        } else if (object instanceof InputStream && bl) {
                            bl = false;
                            a.warn(B[76]);
                        }
                        this.setConnectionStatusLock(1);
                        this.setConnectionStatus(2003, fTPFile2, fTPFile);
                        this.setConnectionStatus(1005);
                        storeCommand = new StoreCommand(B[77], object, fTPFile);
                        if (this.getConnectionType() == 3 || this.getConnectionType() == 4) {
                            object3 = new Command(B[75], "0");
                            this.sendCommand((Command)object3).dumpReply();
                            object2 = new Command(B[71], "P");
                            this.sendCommand((Command)object2).dumpReply();
                        }
                        if (!bl && !this.v) break block28;
                        if (fTPFile.getSize() <= 0L) {
                            object3 = this.getDirectoryListing(fTPFile.getPath());
                            object2 = object3.iterator();
                            while (object2.hasNext()) {
                                FTPFile fTPFile3 = (FTPFile)object2.next();
                                if (fTPFile3.getName().equals(fTPFile.getName())) {
                                    fTPFile.setSize(fTPFile3.getSize());
                                }
                                if (!bl2) continue;
                            }
                        }
                        if (fTPFile2.getSize() == fTPFile.getSize()) break block29;
                        storeCommand.setResumePosition(fTPFile.getSize());
                        object3 = new Command(B[73], "" + fTPFile.getSize());
                        object2 = this.sendCommand((Command)object3);
                        ((Reply)object2).dumpReply();
                        try {
                            ((Reply)object2).validate();
                        }
                        catch (FtpWorkflowException ftpWorkflowException) {
                            a.error(B[72] + ftpWorkflowException.getMessage());
                        }
                        catch (FtpIOException ftpIOException) {
                            a.error(B[74] + ftpIOException.getMessage());
                        }
                        if (!bl2) break block28;
                    }
                    return;
                }
                object3 = new Command(this.z);
                this.sendCommand((Command)object3).dumpReply();
                object2 = new Reply();
                if (!this.isPassiveMode()) break block30;
                socketProvider = this.a(storeCommand, (Reply)object2);
                if (!bl2) break block31;
            }
            socketProvider = this.sendPortCommand(storeCommand, (Reply)object2);
        }
        storeCommand.setDataSocket(socketProvider);
        try {
            storeCommand.fetchDataConnectionReply();
        }
        catch (IOException iOException) {
            this.setConnectionStatus(1011);
            this.disconnect();
            throw iOException;
        }
        if (((Reply)object2).getLines().size() == 1) {
            try {
                ReplyWorker.readReply(this.socketProvider).dumpReply();
            }
            catch (IOException iOException) {
                this.setConnectionStatus(1011);
                this.disconnect();
                throw iOException;
            }
        }
        this.setConnectionStatus(2004, fTPFile2, fTPFile);
        this.setConnectionStatus(1003);
        this.setConnectionStatusLock(0);
    }

    public void uploadDirectory(FTPFile fTPFile, FTPFile fTPFile2) throws IOException, FtpWorkflowException, FtpIOException {
        boolean bl = A;
        if (!fTPFile.isDirectory()) {
            throw new FtpFileNotFoundException(B[2] + fTPFile.getName() + B[3]);
        }
        this.makeDirectory(fTPFile2.toString());
        File[] fileArray = fTPFile.getFile().listFiles();
        ArrayList<FTPFile> arrayList = new ArrayList<FTPFile>();
        for (int i = 0; i < fileArray.length; ++i) {
            arrayList.add(new FTPFile(fileArray[i]));
            if (!bl) continue;
        }
        Collections.sort(arrayList);
        for (FTPFile fTPFile3 : arrayList) {
            block10: {
                block9: {
                    if (fTPFile3.isDirectory()) break block9;
                    this.uploadFile(fTPFile3, new FTPFile(fTPFile2.toString(), fTPFile3.getName()));
                    if (!bl) break block10;
                }
                this.uploadDirectory(fTPFile3, new FTPFile(fTPFile2.toString(), fTPFile3.getName(), true));
            }
            if (!bl) continue;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void fxpFile(FTPConnection fTPConnection, FTPFile fTPFile, FTPFile fTPFile2) throws IOException, FtpWorkflowException, FtpIOException {
        Reply reply2;
        Command command;
        Reply reply3;
        Command command2;
        block23: {
            block22: {
                boolean bl = A;
                this.setConnectionStatusLock(1);
                this.setConnectionStatus(2005, fTPFile, fTPFile2);
                this.setConnectionStatus(1006);
                if (this.isPretSupport()) {
                    command2 = new Command(B[52], new String[]{B[41], fTPFile.toString()});
                    reply3 = this.sendCommand(command2);
                    reply3.dumpReply();
                    reply3.validate();
                }
                if (fTPConnection.isPretSupport()) {
                    command2 = new Command(B[45], new String[]{B[48], fTPFile.toString()});
                    reply3 = fTPConnection.sendCommand(command2);
                    reply3.dumpReply();
                    reply3.validate();
                }
                command2 = new Command(B[43]);
                if (this.getSecureFXPType() != B[49] || this.d) break block22;
                this.setSSCNFxp(true);
                this.d = true;
                command2 = new Command(B[54]);
                if (!bl) break block23;
                int n = Command.d;
                Command.d = ++n;
            }
            if (this.getSecureFXPType() == B[57]) {
                command2 = new Command(B[40]);
            }
        }
        reply3 = this.sendCommand(command2);
        reply3.dumpReply();
        reply3.validate();
        List list = reply3.getLines();
        if (list.size() != 1) {
            throw new UnkownReplyStateException(B[55] + list.size());
        }
        String string = (String)list.get(0);
        string = string.substring(string.indexOf(40) + 1, string.lastIndexOf(41));
        if (this.getSecureFXPType() == B[47]) {
            command = new Command(B[46], "P");
            reply2 = fTPConnection.sendCommand(command);
            reply2.dumpReply();
            reply2.validate();
            reply2 = this.sendCommand(command);
            reply2.dumpReply();
            reply2.validate();
        }
        command = new Command(B[51], string);
        reply2 = fTPConnection.sendCommand(command);
        reply2.dumpReply();
        reply2.validate();
        Command command3 = new Command(B[56], fTPFile2.toString());
        Reply reply = fTPConnection.sendCommand(command3);
        reply.dumpReply();
        reply.validate();
        Command command4 = new Command(B[44], fTPFile.toString());
        Reply reply4 = this.sendCommand(command4);
        reply4.dumpReply();
        reply4.validate();
        if (reply4.getLines().size() == 1) {
            try {
                ReplyWorker.readReply(this.socketProvider).dumpReply();
            }
            catch (IOException iOException) {
                this.setConnectionStatus(1011);
                this.disconnect();
                throw iOException;
            }
        }
        if (reply.getLines().size() == 1) {
            try {
                ReplyWorker.readReply(fTPConnection.socketProvider).dumpReply();
            }
            catch (IOException iOException) {
                fTPConnection.setConnectionStatus(1011);
                fTPConnection.disconnect();
                throw iOException;
            }
        }
        if (this.getSecureFXPType() == B[50]) {
            command = new Command(B[42], "O");
            reply = fTPConnection.sendCommand(command);
            reply.dumpReply();
            reply.validate();
            reply = this.sendCommand(command);
            reply.dumpReply();
            reply.validate();
        }
        if (this.getSecureFXPType() == B[53] && this.d) {
            this.setSSCNFxp(false);
            this.d = false;
        }
        this.setConnectionStatus(2006, fTPFile, fTPFile2);
        this.setConnectionStatus(1003);
        this.setConnectionStatusLock(0);
    }

    public void fxpDirectory(FTPConnection fTPConnection, FTPFile fTPFile, FTPFile fTPFile2) throws IOException, FtpWorkflowException, FtpIOException {
        block21: {
            boolean bl;
            block18: {
                bl = A;
                if (!fTPFile.isDirectory()) {
                    throw new FtpFileNotFoundException(B[63] + fTPFile.getName() + B[61]);
                }
                if (this.getSecureFXPType() != B[60] || this.d) break block18;
                this.setSSCNFxp(true);
                this.d = true;
            }
            fTPConnection.makeDirectory(fTPFile2.toString());
            String string = fTPFile.toString();
            String string2 = string.endsWith("/") ? string.substring(0, string.length() - 1) : string;
            string = string2;
            List list = this.getDirectoryListing(string);
            Collections.sort(list);
            for (FTPFile fTPFile3 : list) {
                block20: {
                    block19: {
                        fTPFile3.setPath(fTPFile.toString());
                        if (fTPFile3.isDirectory()) break block19;
                        this.fxpFile(fTPConnection, fTPFile3, new FTPFile(fTPFile2.toString(), fTPFile3.getName()));
                        if (!bl) break block20;
                    }
                    this.fxpDirectory(fTPConnection, fTPFile3, new FTPFile(fTPFile2.toString(), fTPFile3.getName(), true));
                }
                if (!bl) continue;
            }
            if (this.getSecureFXPType() != B[62] || !this.d) break block21;
            this.setSSCNFxp(false);
            this.d = false;
        }
    }

    private SocketProvider a(Command command, Reply reply) throws IOException, FtpIOException, FtpWorkflowException {
        SocketProvider socketProvider;
        block11: {
            block10: {
                Object object;
                this.setConnectionStatusLock(1);
                this.setConnectionStatus(1010);
                if (this.isPretSupport()) {
                    object = new Command(B[19], command.toString());
                    this.sendCommand((Command)object).dumpReply();
                }
                if (((InetSocketAddress)(object = this.sendPassiveMode())).getAddress().isSiteLocalAddress()) {
                    a.info(B[18] + this.getAddress().getAddress());
                    object = new InetSocketAddress(this.getAddress().getHostName(), ((InetSocketAddress)object).getPort());
                }
                socketProvider = new SocketProvider(false);
                socketProvider.connect((SocketAddress)object, this.getProxy(), this.getDownloadBandwidth(), this.getUploadBandwidth());
                socketProvider.setSSLMode(this.getConnectionType());
                reply.setLines(this.sendCommand(command).getLines());
                reply.dumpReply();
                reply.validate();
                if (this.b == 4 || this.b == 3) break block10;
                if (this.b == 7) break block10;
                if (this.b != 6) break block11;
            }
            socketProvider.negotiate(this.getTrustManagers(), this.getKeyManagers());
        }
        this.setConnectionStatus(1003);
        this.setConnectionStatusLock(0);
        return socketProvider;
    }

    public int getConnectionType() {
        return this.b;
    }

    protected void setConnectionType(int n) {
        this.b = n;
    }

    public void sendSiteCommand(String string) throws IOException, FtpIOException, FtpWorkflowException {
        Command command = new Command(B[79], string);
        Reply reply = this.sendCommand(command);
        reply.dumpReply();
        reply.validate();
    }

    protected int getDownloadBandwidth() {
        return this.k;
    }

    protected void setDownloadBandwidth(int n) {
        this.k = n;
    }

    protected int getUploadBandwidth() {
        return this.l;
    }

    protected void setUploadBandwidth(int n) {
        this.l = n;
    }

    public void addFTPStatusListener(FTPListener fTPListener) {
        this.listenerList.add(FTPListener.class, fTPListener);
    }

    public void removeFTPStatusListener(FTPListener fTPListener) {
        this.listenerList.remove(FTPListener.class, fTPListener);
    }

    public FTPListener[] getFTPStatusListeners() {
        return (FTPListener[])this.listenerList.getListeners(FTPListener.class);
    }

    protected void fireConnectionStatusChanged(FTPEvent fTPEvent) {
        boolean bl = A;
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            block3: {
                if (objectArray[i] != FTPListener.class) continue;
                if (fTPEvent != null) break block3;
                fTPEvent = new FTPEvent(this, this.getConnectionStatus(), null);
            }
            ((FTPListener)objectArray[i + 1]).connectionStatusChanged(fTPEvent);
            if (!bl) continue;
        }
    }

    protected void fireReplyMessageArrived(FTPEvent fTPEvent) {
        boolean bl = A;
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            block3: {
                if (objectArray[i] != FTPListener.class) continue;
                if (fTPEvent != null) break block3;
                fTPEvent = new FTPEvent(this, this.getConnectionStatus(), null);
            }
            ((FTPListener)objectArray[i + 1]).replyMessageArrived(fTPEvent);
            if (!bl) continue;
        }
    }

    public String getSecureFXPType() {
        return this.c;
    }

    public void setSecureFXPType(String string) {
        this.c = string;
    }

    public void setSSCNFxp(boolean bl) throws IOException, FtpIOException, FtpWorkflowException {
        Command command;
        block3: {
            block2: {
                if (!bl) break block2;
                command = new Command(B[26], B[25]);
                if (!A) break block3;
            }
            command = new Command(B[24], B[23]);
        }
        Reply reply = this.sendCommand(command);
        reply.dumpReply();
        reply.validate();
    }

    public boolean isSecuredFxp() throws IOException {
        Command command = new Command(B[96]);
        Reply reply = this.sendCommand(command);
        reply.dumpReply();
        if (((String)reply.getLines().get(0)).indexOf(B[95]) >= 0) {
            return true;
        }
        return false;
    }

    public void renameFile(FTPFile fTPFile, FTPFile fTPFile2) throws IOException, FtpIOException, FtpWorkflowException {
        this.setConnectionStatusLock(1);
        this.setConnectionStatus(1010);
        Command command = new Command(B[80], fTPFile.toString());
        Reply reply = this.sendCommand(command);
        reply.dumpReply();
        reply.validate();
        Command command2 = new Command(B[81], fTPFile2.toString());
        Reply reply2 = this.sendCommand(command2);
        reply2.dumpReply();
        reply2.validate();
        this.setConnectionStatus(1003);
        this.setConnectionStatusLock(0);
    }

    public void deleteFile(FTPFile fTPFile) throws IOException, FtpIOException, FtpWorkflowException {
        Command command = new Command(B[69], fTPFile.toString());
        Reply reply = this.sendCommand(command);
        reply.dumpReply();
        reply.validate();
    }

    public void deleteDirectory(FTPFile fTPFile) throws IOException, FtpIOException, FtpWorkflowException {
        boolean bl = A;
        if (!fTPFile.isDirectory()) {
            throw new FtpFileNotFoundException(B[67] + fTPFile.getName() + B[68]);
        }
        List list = this.getDirectoryListing(fTPFile.toString());
        Collections.sort(list);
        for (FTPFile fTPFile2 : list) {
            block9: {
                block8: {
                    fTPFile2.setPath(fTPFile.toString());
                    if (fTPFile2.isDirectory()) break block8;
                    this.deleteFile(fTPFile2);
                    if (!bl) break block9;
                }
                this.deleteDirectory(fTPFile2);
            }
            if (!bl) continue;
        }
        this.removeDirectory(fTPFile);
    }

    public void removeDirectory(FTPFile fTPFile) throws IOException, FtpIOException, FtpWorkflowException {
        Command command = new Command(B[85], fTPFile.toString());
        Reply reply = this.sendCommand(command);
        reply.dumpReply();
        reply.validate();
    }

    public void setTransferType(boolean bl) throws IOException, FtpIOException, FtpWorkflowException {
        FTPConnection fTPConnection = this;
        String string = bl ? B[89] : B[88];
        fTPConnection.z = string;
        Command command = new Command(this.z);
        Reply reply = this.sendCommand(command);
        reply.dumpReply();
        reply.validate();
    }

    public Proxy getProxy() {
        return this.r;
    }

    public void setProxy(Proxy proxy) {
        this.r = proxy;
    }

    public void checkSystem() throws IOException, FtpIOException {
        try {
            Command command = new Command(B[87]);
            Reply reply = this.sendCommand(command);
            reply.dumpReply();
            reply.validate();
            this.factory = new FTPFileFactory((String)reply.getLines().get(0));
        }
        catch (FtpWorkflowException ftpWorkflowException) {
            this.factory = new FTPFileFactory(B[86]);
        }
    }

    public TrustManager[] getTrustManagers() {
        return this.t;
    }

    public void setTrustManagers(TrustManager[] trustManagerArray) {
        this.t = trustManagerArray;
    }

    public KeyManager[] getKeyManagers() {
        return this.u;
    }

    public void setKeyManagers(KeyManager[] keyManagerArray) {
        this.u = keyManagerArray;
    }

    public boolean isTryResume() {
        return this.v;
    }

    public void setTryResume(boolean bl) {
        this.v = bl;
    }

    public Date getModificationTime(FTPFile fTPFile) throws IOException, FtpIOException, FtpWorkflowException, ParseException {
        Command command = new Command(B[70], fTPFile.toString());
        Reply reply = this.sendCommand(command);
        reply.dumpReply();
        reply.validate();
        return ReplyFormatter.parseMDTMReply(reply);
    }

    public void setModificationTime(FTPFile fTPFile, Date date) throws IOException, FtpIOException, FtpWorkflowException, ParseException {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(B[8]);
        String string = simpleDateFormat.format(date);
        Command command = new Command(B[9], string + " " + fTPFile.toString());
        Reply reply = this.sendCommand(command);
        reply.dumpReply();
        reply.validate();
    }

    public void setClientName(String string) throws FtpIOException, FtpWorkflowException, IOException {
        Command command = new Command(B[66], string);
        Reply reply = this.sendCommand(command);
        reply.dumpReply();
        reply.validate();
    }

    public String getCRC(FTPFile fTPFile) throws FtpIOException, FtpWorkflowException, IOException {
        return this.getCRC(fTPFile, 0L, -1L);
    }

    public String getCRC(FTPFile fTPFile, long l, long l2) throws FtpIOException, FtpWorkflowException, IOException {
        Command command = new Command(B[22], "\"" + fTPFile.toString() + B[21] + l + " " + l2);
        Reply reply = this.sendCommand(command);
        reply.dumpReply();
        reply.validate();
        return ReplyFormatter.parseXCRCReply(reply);
    }

    public String getMD5(FTPFile fTPFile) throws FtpIOException, FtpWorkflowException, IOException {
        return this.getMD5(fTPFile, 0L, -1L);
    }

    public String getMD5(FTPFile fTPFile, long l, long l2) throws FtpIOException, FtpWorkflowException, IOException {
        Command command = new Command(B[84], "\"" + fTPFile.toString() + B[83] + l + " " + l2);
        Reply reply = this.sendCommand(command);
        reply.dumpReply();
        reply.validate();
        return ReplyFormatter.parseXMD5Reply(reply);
    }

    public boolean isPretSupport() {
        return this.w;
    }

    public void setPretSupport(boolean bl) {
        this.w = bl;
    }

    public void checkFeatures() throws IOException {
        boolean bl = A;
        Reply reply = this.sendCommand(new Command(B[33]));
        reply.dumpReply();
        if (ReplyCode.isPositiveCompletionReply(reply)) {
            List list = reply.getLines();
            for (String string : list) {
                block13: {
                    block14: {
                        block12: {
                            if (string.indexOf(B[32]) <= -1) break block12;
                            this.setSscnSupport(true);
                            this.setSecureFXPType(B[30]);
                            if (!bl) break block13;
                        }
                        if (string.indexOf(B[35]) <= -1) break block14;
                        this.setPretSupport(true);
                        if (!bl) break block13;
                    }
                    if (string.indexOf(B[34]) <= -1) break block13;
                    this.setCpsvSupport(true);
                    this.setSecureFXPType(B[31]);
                }
                if (!bl) continue;
            }
        }
    }

    public boolean isCpsvSupport() {
        return this.x;
    }

    public void setCpsvSupport(boolean bl) {
        this.x = bl;
    }

    public boolean isSscnSupport() {
        return this.y;
    }

    public void setSscnSupport(boolean bl) {
        this.y = bl;
    }

    public void moveFile(FTPFile fTPFile, FTPFile fTPFile2) throws FtpWorkflowException, FtpIOException, IOException {
        this.renameFile(fTPFile, fTPFile2);
    }

    static void a(FTPConnection fTPConnection, FTPFile fTPFile, PipedInputStream pipedInputStream) throws IOException, FtpWorkflowException, FtpIOException {
        fTPConnection.a(fTPFile, pipedInputStream);
    }

    static Logger a() {
        return a;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[97];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n = 0;
        String string2 = "SZ!1";
        int n2 = -1;
        block104: while (true) {
            char[] cArray;
            block109: {
                int n3;
                int n4;
                char[] cArray2;
                int n5;
                block108: {
                    char[] cArray3 = string2.toCharArray();
                    n5 = 0;
                    int n6 = cArray3.length;
                    cArray2 = cArray3;
                    n4 = n6;
                    if (n6 <= 1) break block108;
                    cArray = cArray2;
                    n3 = n4;
                    if (n4 <= n5) break block109;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n7 = n5;
                    while (true) {
                        int n8;
                        char c = cArray4[n7];
                        switch (n5 % 5) {
                            case 0: {
                                n8 = 3;
                                break;
                            }
                            case 1: {
                                n8 = 24;
                                break;
                            }
                            case 2: {
                                n8 = 114;
                                break;
                            }
                            case 3: {
                                n8 = 107;
                                break;
                            }
                            default: {
                                n8 = 68;
                            }
                        }
                        cArray4[n7] = (char)(c ^ n8);
                        ++n5;
                        cArray2 = cArray5;
                        n4 = n4;
                        if (n4 != 0) break;
                        cArray5 = cArray2;
                        n3 = n4;
                        n7 = n4;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n3 = n4;
                } while (n4 > n5);
            }
            string = new String(cArray);
            switch (n2) {
                default: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 1;
                    string2 = "SJ=?";
                    n2 = 0;
                    continue block104;
                }
                case 0: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 2;
                    string2 = "Vh\u001e\u0004%gq\u001c\f~#";
                    n2 = 1;
                    continue block104;
                }
                case 1: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 3;
                    string2 = "#q\u0001K*llR\u001b+pk\u001b\t(f4R\u00020$kR\u0005+w8\u0013K jj\u0017\b0lj\u000bJ";
                    n2 = 2;
                    continue block104;
                }
                case 2: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 4;
                    string2 = "QU6";
                    n2 = 3;
                    continue block104;
                }
                case 3: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 5;
                    string2 = "SO6";
                    n2 = 4;
                    continue block104;
                }
                case 4: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 6;
                    string2 = "WA\".dJ";
                    n2 = 5;
                    continue block104;
                }
                case 5: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 7;
                    string2 = "JK=F|;-KFu";
                    n2 = 6;
                    continue block104;
                }
                case 6: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 8;
                    string2 = "za\u000b\u0012\tN|\u0016#\fnu\u0001\u0018";
                    n2 = 7;
                    continue block104;
                }
                case 7: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 9;
                    string2 = "N\\&&";
                    n2 = 8;
                    continue block104;
                }
                case 8: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 10;
                    string2 = "NS6";
                    n2 = 9;
                    continue block104;
                }
                case 9: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 11;
                    string2 = "SZ!1";
                    n2 = 10;
                    continue block104;
                }
                case 10: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 12;
                    string2 = "@w\u0007\u0007 m?\u0006K6fk\u0007\u0006!#~\u001b\u0007!/8\u0017\u00196ljR\u001c%p\"R";
                    n2 = 11;
                    continue block104;
                }
                case 11: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 13;
                    string2 = "Q]!?";
                    n2 = 12;
                    continue block104;
                }
                case 12: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 14;
                    string2 = "SJ=?";
                    n2 = 13;
                    continue block104;
                }
                case 13: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 15;
                    string2 = "@w\u0007\u0007 m?\u0006K6fk\u0007\u0006!#~\u001b\u0007!/8\u0017\u00196ljR\u001c%p\"R";
                    n2 = 14;
                    continue block104;
                }
                case 14: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 16;
                    string2 = "Q]&9";
                    n2 = 15;
                    continue block104;
                }
                case 15: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 17;
                    string2 = "P}\u001c\u000f-m\u007fR\b+nu\u0013\u0005 98";
                    n2 = 16;
                    continue block104;
                }
                case 16: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 18;
                    string2 = "P}\u0000\u001d!q8\u0000\u000e4lj\u0006\u0018dow\u0011\n(#Q\"Ki=8 \u000e jj\u0017\b0#l\u001dQ";
                    n2 = 17;
                    continue block104;
                }
                case 17: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 19;
                    string2 = "SJ7?";
                    n2 = 18;
                    continue block104;
                }
                case 18: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 20;
                    string2 = "vk\u0017\u0019dnm\u0001\u001fdmwR\t!#v\u0007\u0007(#w\u0000K,bkR\ndo}\u001c\f0k8\u001d\rd3";
                    n2 = 19;
                    continue block104;
                }
                case 19: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 21;
                    string2 = "!8";
                    n2 = 20;
                    continue block104;
                }
                case 20: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 22;
                    string2 = "[[ (";
                    n2 = 21;
                    continue block104;
                }
                case 21: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 23;
                    string2 = "L^4";
                    n2 = 22;
                    continue block104;
                }
                case 22: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 24;
                    string2 = "PK1%";
                    n2 = 23;
                    continue block104;
                }
                case 23: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 25;
                    string2 = "LV";
                    n2 = 24;
                    continue block104;
                }
                case 24: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 26;
                    string2 = "PK1%";
                    n2 = 25;
                    continue block104;
                }
                case 25: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 27;
                    string2 = "MW=;";
                    n2 = 26;
                    continue block104;
                }
                case 26: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 28;
                    string2 = "RM;?";
                    n2 = 27;
                    continue block104;
                }
                case 27: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 29;
                    string2 = "Fj\u0000\u00046#{\u001e\u00047jv\u0015K'lv\u001c\u000e'wq\u001d\u0005~#";
                    n2 = 28;
                    continue block104;
                }
                case 28: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 30;
                    string2 = "PK1%";
                    n2 = 29;
                    continue block104;
                }
                case 29: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 31;
                    string2 = "@H!=";
                    n2 = 30;
                    continue block104;
                }
                case 30: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 32;
                    string2 = "PK1%";
                    n2 = 31;
                    continue block104;
                }
                case 31: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 33;
                    string2 = "E]3?";
                    n2 = 32;
                    continue block104;
                }
                case 32: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 34;
                    string2 = "@H!=";
                    n2 = 33;
                    continue block104;
                }
                case 33: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 35;
                    string2 = "SJ7?";
                    n2 = 34;
                    continue block104;
                }
                case 34: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 36;
                    string2 = "PL3?";
                    n2 = 35;
                    continue block104;
                }
                case 35: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 37;
                    string2 = ".T3";
                    n2 = 36;
                    continue block104;
                }
                case 36: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 38;
                    string2 = ".T3K";
                    n2 = 37;
                    continue block104;
                }
                case 37: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 39;
                    string2 = "PL3?";
                    n2 = 38;
                    continue block104;
                }
                case 38: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 40;
                    string2 = "@H!=";
                    n2 = 39;
                    continue block104;
                }
                case 39: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 41;
                    string2 = "Q]&9";
                    n2 = 40;
                    continue block104;
                }
                case 40: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 42;
                    string2 = "SJ=?";
                    n2 = 41;
                    continue block104;
                }
                case 41: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 43;
                    string2 = "SY!=";
                    n2 = 42;
                    continue block104;
                }
                case 42: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 44;
                    string2 = "Q]&9";
                    n2 = 43;
                    continue block104;
                }
                case 43: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 45;
                    string2 = "SJ7?";
                    n2 = 44;
                    continue block104;
                }
                case 44: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 46;
                    string2 = "SJ=?";
                    n2 = 45;
                    continue block104;
                }
                case 45: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 47;
                    string2 = "@H!=";
                    n2 = 46;
                    continue block104;
                }
                case 46: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 48;
                    string2 = "PL=9";
                    n2 = 47;
                    continue block104;
                }
                case 47: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 49;
                    string2 = "PK1%";
                    n2 = 48;
                    continue block104;
                }
                case 48: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 50;
                    string2 = "@H!=";
                    n2 = 49;
                    continue block104;
                }
                case 49: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 51;
                    string2 = "SW ?";
                    n2 = 50;
                    continue block104;
                }
                case 50: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 52;
                    string2 = "SJ7?";
                    n2 = 51;
                    continue block104;
                }
                case 51: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 53;
                    string2 = "PK1%";
                    n2 = 52;
                    continue block104;
                }
                case 52: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 54;
                    string2 = "SY!=";
                    n2 = 53;
                    continue block104;
                }
                case 53: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 55;
                    string2 = "SY!=dQ}\u0002\u0007=#p\u0013\u0018dwwR\u0003%u}R\ndpq\b\u000edl~RZdfv\u0006\u0019=#z\u0007\u001fdjlR\u0003%p\"R";
                    n2 = 54;
                    continue block104;
                }
                case 54: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 56;
                    string2 = "PL=9";
                    n2 = 55;
                    continue block104;
                }
                case 55: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 57;
                    string2 = "@H!=";
                    n2 = 56;
                    continue block104;
                }
                case 56: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 58;
                    string2 = "#q\u0001K*llR\u001b+pk\u001b\t(f4R\u00020$kR\u0005+w8\u0013K jj\u0017\b0lj\u000bJ";
                    n2 = 57;
                    continue block104;
                }
                case 57: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 59;
                    string2 = "Gw\u0005\u0005(ly\u0016\u0002*d\"R";
                    n2 = 58;
                    continue block104;
                }
                case 58: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 60;
                    string2 = "PK1%";
                    n2 = 59;
                    continue block104;
                }
                case 59: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 61;
                    string2 = "#q\u0001K*llR\u001b+pk\u001b\t(f4R\u00020$kR\u0005+w8\u0013K jj\u0017\b0lj\u000bJ";
                    n2 = 60;
                    continue block104;
                }
                case 60: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 62;
                    string2 = "PK1%";
                    n2 = 61;
                    continue block104;
                }
                case 61: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 63;
                    string2 = "Gw\u0005\u0005(ly\u0016\u0002*d\"R";
                    n2 = 62;
                    continue block104;
                }
                case 62: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 64;
                    string2 = "SW ?";
                    n2 = 63;
                    continue block104;
                }
                case 63: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 65;
                    string2 = "SW ?";
                    n2 = 64;
                    continue block104;
                }
                case 64: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 66;
                    string2 = "@T<?";
                    n2 = 65;
                    continue block104;
                }
                case 65: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 67;
                    string2 = "G}\u001e\u000e0jv\u0015Qd";
                    n2 = 66;
                    continue block104;
                }
                case 66: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 68;
                    string2 = "#q\u0001K*llR\u001b+pk\u001b\t(f4R\u00020$kR\u0005+w8\u0013K jj\u0017\b0lj\u000bJ";
                    n2 = 67;
                    continue block104;
                }
                case 67: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 69;
                    string2 = "G]>.";
                    n2 = 68;
                    continue block104;
                }
                case 68: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 70;
                    string2 = "N\\&&";
                    n2 = 69;
                    continue block104;
                }
                case 69: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 71;
                    string2 = "SJ=?";
                    n2 = 70;
                    continue block104;
                }
                case 70: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 72;
                    string2 = "@w\u0007\u0007 m?\u0006K6fk\u0007\u0006!#~\u001b\u0007!/8\u0017\u00196ljR\u001c%p\"R";
                    n2 = 71;
                    continue block104;
                }
                case 71: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 73;
                    string2 = "Q]!?";
                    n2 = 72;
                    continue block104;
                }
                case 72: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 74;
                    string2 = "@w\u0007\u0007 m?\u0006K6fk\u0007\u0006!#~\u001b\u0007!/8\u0017\u00196ljR\u001c%p\"R";
                    n2 = 73;
                    continue block104;
                }
                case 73: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 75;
                    string2 = "SZ!1";
                    n2 = 74;
                    continue block104;
                }
                case 74: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 76;
                    string2 = "MwR\u0019!pm\u001f\u000edsw\u0001\u0018-at\u0017K+m8\u0007\u001b(ly\u001680q}\u0013\u0006";
                    n2 = 75;
                    continue block104;
                }
                case 75: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 77;
                    string2 = "PL=9";
                    n2 = 76;
                    continue block104;
                }
                case 76: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 78;
                    string2 = "@O6";
                    n2 = 77;
                    continue block104;
                }
                case 77: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 79;
                    string2 = "PQ&.";
                    n2 = 78;
                    continue block104;
                }
                case 78: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 80;
                    string2 = "QV49";
                    n2 = 79;
                    continue block104;
                }
                case 79: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 81;
                    string2 = "QV&$";
                    n2 = 80;
                    continue block104;
                }
                case 80: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 82;
                    string2 = "@\\';";
                    n2 = 81;
                    continue block104;
                }
                case 81: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 83;
                    string2 = "!8";
                    n2 = 82;
                    continue block104;
                }
                case 82: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 84;
                    string2 = "[U6^";
                    n2 = 83;
                    continue block104;
                }
                case 83: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 85;
                    string2 = "QU6";
                    n2 = 84;
                    continue block104;
                }
                case 84: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 86;
                    string2 = "VV9%\u000bTV";
                    n2 = 85;
                    continue block104;
                }
                case 85: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 87;
                    string2 = "PA!?";
                    n2 = 86;
                    continue block104;
                }
                case 86: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 88;
                    string2 = "WA\".dB";
                    n2 = 87;
                    continue block104;
                }
                case 87: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 89;
                    string2 = "WA\".dJ";
                    n2 = 88;
                    continue block104;
                }
                case 88: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 90;
                    string2 = "Q]&9";
                    n2 = 89;
                    continue block104;
                }
                case 89: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 91;
                    string2 = "SJ=?";
                    n2 = 90;
                    continue block104;
                }
                case 90: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 92;
                    string2 = "SZ!1";
                    n2 = 91;
                    continue block104;
                }
                case 91: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 93;
                    string2 = "SY!=";
                    n2 = 92;
                    continue block104;
                }
                case 92: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 94;
                    string2 = "Wp\u0017K7wy\u0006\u000edl~R\u001f,f8\u0000\u000e4oaR\r6luR\u001b%pnR\b+nu\u0013\u0005 #q\u0001K1ms\u001c\u00043m9";
                    n2 = 93;
                    continue block104;
                }
                case 93: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 95;
                    string2 = "@T;.\nW";
                    n2 = 94;
                    continue block104;
                }
                case 94: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 96;
                    string2 = "PK1%";
                    n2 = 95;
                    continue block104;
                }
                case 95: 
            }
            break;
        }
        stringArray2[n] = string.intern();
        B = stringArray3;
        a = LoggerFactory.getLogger(FTPConnection.class);
    }
}

