/*
 * Decompiled with CFR 0.152.
 */
package org.ftp4che.commands;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PipedInputStream;
import java.nio.ByteBuffer;
import org.ftp4che.commands.Command;
import org.ftp4che.commands.DataConnectionCommand;
import org.ftp4che.io.ReplyWorker;
import org.ftp4che.reply.Reply;
import org.ftp4che.util.ftpfile.FTPFile;

public class RetrieveCommand
extends DataConnectionCommand {
    public static final int FILE_BASED = 0;
    public static final int STREAM_BASED = 1;
    public static final int BYTEBUFFER_BASED = 2;
    private FTPFile g;
    private FTPFile h;
    private PipedInputStream i;
    private ByteBuffer j;
    private long k;

    public RetrieveCommand(String string, FTPFile fTPFile) {
        super(string, fTPFile.getName());
        this.k = -1L;
        this.setFromFile(fTPFile);
    }

    public RetrieveCommand(String string, FTPFile fTPFile, FTPFile fTPFile2) {
        super(string, fTPFile.toString());
        this.k = -1L;
        this.setFromFile(fTPFile);
        this.setToFile(fTPFile2);
    }

    public RetrieveCommand(String string, FTPFile fTPFile, PipedInputStream pipedInputStream) {
        super(string, fTPFile.toString());
        this.k = -1L;
        this.setFromFile(fTPFile);
        this.setInputPipe(pipedInputStream);
    }

    public RetrieveCommand(String string, FTPFile fTPFile, ByteBuffer byteBuffer) {
        int n = DataConnectionCommand.f;
        super(string, fTPFile.toString());
        this.k = -1L;
        this.setFromFile(fTPFile);
        this.setByteBuffer(byteBuffer);
        if (Command.d != 0) {
            DataConnectionCommand.f = ++n;
        }
    }

    @Override
    public Reply fetchDataConnectionReply() throws FileNotFoundException, IOException {
        return this.fetchDataConnectionReply(0);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Reply fetchDataConnectionReply(int n) throws FileNotFoundException, IOException {
        int n2 = DataConnectionCommand.f;
        ReplyWorker replyWorker = null;
        switch (n) {
            case 1: {
                replyWorker = new ReplyWorker(this.getDataSocket(), this, this.i, n);
                break;
            }
            case 2: {
                replyWorker = new ReplyWorker(this.getDataSocket(), this, this.j, n);
                break;
            }
            default: {
                replyWorker = new ReplyWorker(this.getDataSocket(), this, null, 0);
            }
        }
        replyWorker.start();
        while (replyWorker.getStatus() == -1) {
            try {
                Thread.sleep(20L);
            }
            catch (InterruptedException interruptedException) {
                if (n2 == 0) continue;
            }
        }
        if (replyWorker.getStatus() == 1) {
            return replyWorker.getReply();
        }
        if (replyWorker.getCaughtException() instanceof FileNotFoundException) {
            throw (FileNotFoundException)replyWorker.getCaughtException();
        }
        throw (IOException)replyWorker.getCaughtException();
    }

    public FTPFile getFromFile() {
        return this.g;
    }

    public void setFromFile(FTPFile fTPFile) {
        this.g = fTPFile;
    }

    public FTPFile getToFile() {
        return this.h;
    }

    public void setToFile(FTPFile fTPFile) {
        this.h = fTPFile;
    }

    public long getResumePosition() {
        return this.k;
    }

    public void setResumePosition(long l) {
        this.k = l;
    }

    public void setInputPipe(PipedInputStream pipedInputStream) {
        this.i = pipedInputStream;
    }

    public void setByteBuffer(ByteBuffer byteBuffer) {
        this.j = byteBuffer;
    }
}

