/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.stream;

import com.twelvemonkeys.imageio.stream.BufferedImageInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Locale;
import javax.imageio.spi.ImageInputStreamSpi;
import javax.imageio.stream.FileCacheImageInputStream;
import javax.imageio.stream.FileImageInputStream;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.MemoryCacheImageInputStream;

public class URLImageInputStreamSpi
extends ImageInputStreamSpi {
    public URLImageInputStreamSpi() {
        super("TwelveMonkeys", "1.0 BETA", URL.class);
    }

    public ImageInputStream createInputStreamInstance(Object pInput, boolean pUseCache, File pCacheDir) throws IOException {
        if (pInput instanceof URL) {
            URL url = (URL)pInput;
            if ("file".equals(url.getProtocol())) {
                try {
                    return new BufferedImageInputStream(new FileImageInputStream(new File(url.toURI())));
                }
                catch (URISyntaxException ignore) {
                    ignore.printStackTrace();
                }
            }
            final InputStream stream = url.openStream();
            if (pUseCache) {
                return new BufferedImageInputStream(new FileCacheImageInputStream(stream, pCacheDir){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void close() throws IOException {
                        try {
                            super.close();
                        }
                        finally {
                            stream.close();
                        }
                    }
                });
            }
            return new MemoryCacheImageInputStream(stream){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void close() throws IOException {
                    try {
                        super.close();
                    }
                    finally {
                        stream.close();
                    }
                }
            };
        }
        throw new IllegalArgumentException("Expected input of type URL: " + pInput);
    }

    public String getDescription(Locale pLocale) {
        return "Service provider that instantiates an ImageInputStream from a URL";
    }
}

