/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.util;

import com.twelvemonkeys.io.FileUtil;
import com.twelvemonkeys.lang.StringUtil;
import java.io.File;
import java.io.FileFilter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;

public final class ReaderFileSuffixFilter
extends javax.swing.filechooser.FileFilter
implements FileFilter {
    private final String mDescription;
    private final Map<String, Boolean> mKnownSuffixes = new HashMap<String, Boolean>(32);

    public ReaderFileSuffixFilter() {
        this("Images (all supported input formats)");
    }

    public ReaderFileSuffixFilter(String pDescription) {
        this.mDescription = pDescription;
    }

    public boolean accept(File pFile) {
        if (pFile.isDirectory()) {
            return true;
        }
        String suffix = FileUtil.getExtension((File)pFile);
        return !StringUtil.isEmpty((String)suffix) && this.hasReaderForSuffix(suffix);
    }

    private boolean hasReaderForSuffix(String pSuffix) {
        if (this.mKnownSuffixes.get(pSuffix) == Boolean.TRUE) {
            return true;
        }
        try {
            Iterator<ImageReader> iterator = ImageIO.getImageReadersBySuffix(pSuffix);
            if (iterator.hasNext()) {
                this.mKnownSuffixes.put(pSuffix, Boolean.TRUE);
                return true;
            }
            this.mKnownSuffixes.put(pSuffix, Boolean.FALSE);
            return false;
        }
        catch (IllegalArgumentException iae) {
            return false;
        }
    }

    public String getDescription() {
        return this.mDescription;
    }
}

