/*
 * Decompiled with CFR 0.152.
 */
package com.agilemind.commons.application.modules.audit.page.onpage;

import com.agilemind.commons.application.modules.audit.AuditStatusType;
import com.agilemind.commons.application.modules.audit.page.IAuditPage;
import com.agilemind.commons.application.modules.audit.page.LengthAuditResult;
import com.agilemind.commons.application.modules.audit.page.PageAuditFactor;
import com.agilemind.commons.application.modules.audit.page.PageAuditResult;
import com.agilemind.commons.application.modules.audit.page.onpage.KeywordsInTagAuditFactor;
import com.agilemind.htmlparser.data.HTMLElementInfo;
import com.agilemind.htmlparser.data.HTMLTag;
import com.agilemind.htmlparser.data.IImportantKeyword;
import java.util.List;
import org.htmlparser.util.ParserException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TitleLengthAuditFactor
implements PageAuditFactor {
    public static final int TITLE_LENGTH = 55;
    private static final Logger a = LoggerFactory.getLogger(TitleLengthAuditFactor.class);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public PageAuditResult getResult(IAuditPage iAuditPage, List<? extends IImportantKeyword> list) {
        boolean bl2 = KeywordsInTagAuditFactor.c;
        int n2 = 0;
        AuditStatusType auditStatusType = AuditStatusType.N_A;
        try {
            HTMLElementInfo.Simple simple = (HTMLElementInfo.Simple)iAuditPage.getTags(HTMLTag.TITLE);
            n2 = simple.getTagText().length();
            if (n2 == 0) {
                auditStatusType = AuditStatusType.ERROR;
                if (!bl2) return new LengthAuditResult(auditStatusType, n2);
            }
            if (n2 > 55) {
                auditStatusType = AuditStatusType.WARNING;
                if (!bl2) return new LengthAuditResult(auditStatusType, n2);
            }
            auditStatusType = AuditStatusType.OK;
            return new LengthAuditResult(auditStatusType, n2);
        }
        catch (ParserException parserException) {
            a.error("", (Throwable)parserException);
        }
        return new LengthAuditResult(auditStatusType, n2);
    }
}

