/*
 * Decompiled with CFR 0.152.
 */
package com.agilemind.commons.application.modules.audit.page.technical;

import com.agilemind.commons.application.modules.audit.AuditStatusType;
import com.agilemind.commons.application.modules.audit.page.IAuditPage;
import com.agilemind.commons.application.modules.audit.page.PageAuditFactor;
import com.agilemind.commons.application.modules.audit.page.PageAuditResult;
import com.agilemind.commons.application.modules.audit.page.technical.PageRestrictedFromIndexingAuditFactor;
import com.agilemind.commons.application.modules.audit.page.technical.result.PageUsesCanonicalAuditResult;
import com.agilemind.commons.io.searchengine.analyzers.SearchEngineFactorsList;
import com.agilemind.commons.io.searchengine.analyzers.data.FactorType;
import com.agilemind.commons.io.searchengine.analyzers.data.ISearchEngineFactor;
import com.agilemind.commons.io.searchengine.analyzers.parsers.IFactorParser;
import com.agilemind.commons.util.StringUtil;
import com.agilemind.commons.util.UnicodeURL;
import com.agilemind.htmlparser.data.IImportantKeyword;
import java.net.MalformedURLException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PageUsesRelCanonicalAuditFactor
implements PageAuditFactor {
    public static final String CANONICAL_SEPARATOR = ";";
    private static final Logger a = LoggerFactory.getLogger(PageUsesRelCanonicalAuditFactor.class);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public PageAuditResult getResult(IAuditPage iAuditPage, List<? extends IImportantKeyword> list) {
        UnicodeURL unicodeURL = null;
        AuditStatusType auditStatusType = AuditStatusType.NOT_YET_CHECKED;
        ISearchEngineFactor iSearchEngineFactor = iAuditPage.getPopularityMap().getFactor((FactorType)SearchEngineFactorsList.CANONICAL_FACTOR_TYPE);
        if (iSearchEngineFactor == null) return new PageUsesCanonicalAuditResult(auditStatusType, unicodeURL);
        String string = (String)((Object)iSearchEngineFactor.getFactorValue());
        if (string.equals(IFactorParser.NA_DATA)) {
            auditStatusType = AuditStatusType.N_A;
            if (!PageRestrictedFromIndexingAuditFactor.b) return new PageUsesCanonicalAuditResult(auditStatusType, unicodeURL);
        }
        if (StringUtil.isEmpty((String)string)) {
            auditStatusType = AuditStatusType.OK;
            return new PageUsesCanonicalAuditResult(auditStatusType, unicodeURL);
        }
        String[] stringArray = StringUtil.decode((String)string).split(CANONICAL_SEPARATOR);
        int n2 = stringArray.length;
        if (n2 != 1) {
            auditStatusType = AuditStatusType.OK;
            return new PageUsesCanonicalAuditResult(auditStatusType, unicodeURL);
        }
        try {
            unicodeURL = new UnicodeURL(stringArray[0]);
        }
        catch (MalformedURLException malformedURLException) {
            a.error("", (Throwable)malformedURLException);
        }
        auditStatusType = AuditStatusType.INFO;
        return new PageUsesCanonicalAuditResult(auditStatusType, unicodeURL);
    }
}

