/*
 * Decompiled with CFR 0.152.
 */
package com.agilemind.commons.application.modules.factors.data;

import com.agilemind.commons.application.modules.factors.data.SEOFactorsSettings;
import com.agilemind.commons.application.modules.factors.data.a;
import com.agilemind.commons.application.modules.factors.data.b;
import com.agilemind.commons.application.modules.factors.data.f;
import com.agilemind.commons.io.searchengine.analyzers.SearchEngineFactorsList;
import com.agilemind.commons.io.searchengine.analyzers.data.AlexaPopularityResult;
import com.agilemind.commons.io.searchengine.analyzers.data.IMozAuthorityResult;
import com.agilemind.commons.io.searchengine.analyzers.data.IPopularityMap;
import com.agilemind.commons.io.searchengine.analyzers.data.ISearchEngineFactor;
import com.agilemind.commons.io.searchengine.analyzers.data.SearchEngineFactorType;
import com.agilemind.commons.io.searchengine.analyzers.parsers.IFactorParser;
import com.agilemind.commons.mvc.controllers.Controller;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class DomainStrengthUtil {
    private static final DecimalFormatSymbols a;
    public static final DecimalFormat NUMBER_FORMAT;
    public static final double NA = -1.0;
    private static final String b;

    private DomainStrengthUtil() {
    }

    public static double getStrength(IPopularityMap iPopularityMap, boolean bl2) {
        boolean bl3 = SEOFactorsSettings.t;
        int n2 = 0;
        for (FactorStrength factorStrength : DomainStrengthUtil.a(bl2)) {
            int n3 = factorStrength.getStrength(iPopularityMap);
            if (n3 == -1) {
                return -1.0;
            }
            n2 += n3;
            if (!bl3) continue;
        }
        return (double)n2 / 100.0;
    }

    private static List<FactorStrength> a(boolean bl2) {
        ArrayList<FactorStrength> arrayList;
        block3: {
            block2: {
                arrayList = new ArrayList<FactorStrength>();
                arrayList.add(new AlexaFactorStrength());
                arrayList.add(new SocialPopularityFactorStrength());
                arrayList.add(new DomainAgeFactorStrength());
                arrayList.add(new BacklinkDomainsFactorStrength());
                if (!bl2) break block2;
                arrayList.add(new MozDomainAuthorityFactor());
                if (!SEOFactorsSettings.t) break block3;
            }
            arrayList.add(new GooglePRFactorStrength());
        }
        return arrayList;
    }

    @Nullable
    private static <T extends Comparable> T a(SearchEngineFactorType<T> searchEngineFactorType, IPopularityMap iPopularityMap) {
        ISearchEngineFactor iSearchEngineFactor = iPopularityMap.getFactor(searchEngineFactorType);
        if (iSearchEngineFactor == null) {
            return null;
        }
        return (T)iSearchEngineFactor.getFactorValue();
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        char[] cArray;
        block10: {
            int n2;
            int n3;
            char[] cArray2;
            int n4;
            block9: {
                char[] cArray3 = "SaC#".toCharArray();
                n4 = 0;
                int n5 = cArray3.length;
                cArray2 = cArray3;
                n3 = n5;
                if (n5 <= 1) break block9;
                cArray = cArray2;
                n2 = n3;
                if (n3 <= n4) break block10;
            }
            do {
                char[] cArray4 = cArray2;
                char[] cArray5 = cArray2;
                int n6 = n4;
                while (true) {
                    int n7;
                    char c3 = cArray4[n6];
                    switch (n4 % 5) {
                        case 0: {
                            n7 = 99;
                            break;
                        }
                        case 1: {
                            n7 = 79;
                            break;
                        }
                        case 2: {
                            n7 = 115;
                            break;
                        }
                        case 3: {
                            n7 = 19;
                            break;
                        }
                        default: {
                            n7 = 34;
                        }
                    }
                    cArray4[n6] = (char)(c3 ^ n7);
                    ++n4;
                    cArray2 = cArray5;
                    n3 = n3;
                    if (n3 != 0) break;
                    cArray5 = cArray2;
                    n2 = n3;
                    n6 = n3;
                    cArray4 = cArray2;
                }
                cArray = cArray2;
                n2 = n3;
            } while (n3 > n4);
        }
        b = new String(cArray).intern();
        a = new f();
        NUMBER_FORMAT = new DecimalFormat(b, a);
    }

    public static class BacklinkDomainsFactorStrength
    implements FactorStrength {
        private static Integer[] a = new Integer[]{10, 20, 30, 40, 50, 60, 70, 80, 90, 100, 150, 200, 250, 300, 350, 400, 450, 500, 550, 600, 650, 700, 750, 800, 850, 900, 950, 1000, 1100, 1200, 1300, 1400, 1500, 1600, 1700, 1800, 1900, 2000, 2100, 2200, 2300, 2400, 2500, 2600, 2700, 2800, 2900, 3000, 3100, 3200, 3300, 3400, 3500, 3600, 3700, 3800, 3900, 4000, 4100, 4200, 4300, 4400, 4500, 4600, 4700, 4800, 4900, 5000, 5500, 6000, 6500, 7000, 7500, 8000, 8500, 9000, 9500, 10000, 11000, 12000, 13000, 14000, 15000, 16000, 17000, 18000, 19000, 20000, 25000, 30000, 35000, 40000, 45000, 50000, 55000, 60000, 65000, 70000, 75000, 80000, 85000, 90000, 100000};

        @Override
        public int getStrength(IPopularityMap iPopularityMap) {
            Long l2 = (Long)DomainStrengthUtil.a(SearchEngineFactorsList.BACKLINK_DOMAINS, iPopularityMap);
            if (l2 == null) {
                return -1;
            }
            int n2 = Arrays.binarySearch((Object[])a, (Object)l2.intValue());
            return n2 < 0 ? -n2 - 1 : n2 + 1;
        }
    }

    public static class DomainAgeFactorStrength
    implements FactorStrength {
        private static Integer[] a = new Integer[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 42, 48, 54, 60, 66, 72, 78, 84, 90, 96, 102, 108, 114, 120, 132, 144, 156, 168, 180, 192, 204, 216, 228, 240};

        @Override
        public int getStrength(IPopularityMap iPopularityMap) {
            Date date = (Date)DomainStrengthUtil.a(SearchEngineFactorsList.DOMAIN_AGE_FACTOR_TYPE, iPopularityMap);
            if (date == null) {
                return -1;
            }
            if (date.equals(IFactorParser.NA_DATE)) {
                return 0;
            }
            int n2 = this.differenceInMonth(date, new Date());
            int n3 = Arrays.binarySearch((Object[])a, (Object)n2);
            return n3 < 0 ? -n3 - 1 : n3 + 1;
        }

        public int differenceInMonth(Date date, Date date2) {
            boolean bl2 = SEOFactorsSettings.t;
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(date);
            Calendar calendar2 = Calendar.getInstance();
            calendar2.setTime(date2);
            int n2 = calendar2.get(1) - calendar.get(1);
            int n3 = n2 * 12 + calendar2.get(2) - calendar.get(2);
            if (Controller.g != 0) {
                SEOFactorsSettings.t = !bl2;
            }
            return n3;
        }
    }

    public static class SocialPopularityFactorStrength
    implements FactorStrength {
        private static Integer[] a = new Integer[]{10, 50, 60, 70, 80, 90, 100, 150, 200, 250, 300, 350, 400, 450, 500, 550, 600, 650, 700, 750, 800, 850, 900, 950, 1000, 1100, 1200, 1300, 1400, 1500, 1600, 1700, 1800, 1900, 2000, 2500, 3000, 3500, 4000, 4500, 5000, 5500, 6000, 6500, 7000, 7500, 8000, 8500, 9000, 9500, 10000, 11000, 12000, 13000, 14000, 15000, 16000, 17000, 18000, 19000, 20000, 25000, 30000, 35000, 40000, 45000, 50000, 60000, 70000, 80000, 90000, 100000, 500000, 1000000, 2000000, 3000000, 4000000, 5000000};

        @Override
        public int getStrength(IPopularityMap iPopularityMap) {
            Long l2 = (Long)DomainStrengthUtil.a((SearchEngineFactorType)SearchEngineFactorsList.DOMAIN_FACEBOOK_FACTOR_TYPE, iPopularityMap);
            if (l2 == null) {
                return -1;
            }
            Long l3 = (Long)DomainStrengthUtil.a((SearchEngineFactorType)SearchEngineFactorsList.DOMAIN_TWITTER_FACTOR_TYPE, iPopularityMap);
            if (l3 == null) {
                return 0;
            }
            Integer n2 = (Integer)DomainStrengthUtil.a((SearchEngineFactorType)SearchEngineFactorsList.DOMAIN_GOOGLE_PLUS_ONE_FACTOR_TYPE, iPopularityMap);
            if (n2 == null) {
                return -1;
            }
            int n3 = l2.intValue() + l3.intValue() + n2;
            int n4 = Arrays.binarySearch((Object[])a, (Object)n3);
            return n4 < 0 ? -n4 - 1 : n4 + 1;
        }
    }

    public static class AlexaFactorStrength
    implements FactorStrength {
        private static Integer[] a = new Integer[]{10000000, 9500000, 9000000, 8500000, 8000000, 7500000, 7000000, 6500000, 6000000, 5500000, 5000000, 4500000, 4000000, 3500000, 3000000, 2500000, 2000000, 1500000, 1000000, 900000, 800000, 700000, 600000, 500000, 490000, 480000, 470000, 460000, 450000, 440000, 430000, 420000, 410000, 400000, 390000, 380000, 370000, 360000, 350000, 340000, 330000, 320000, 310000, 300000, 290000, 280000, 270000, 260000, 250000, 240000, 230000, 220000, 210000, 200000, 190000, 180000, 170000, 160000, 150000, 140000, 130000, 120000, 110000, 100000, 95000, 90000, 85000, 80000, 75000, 70000, 65000, 60000, 55000, 50000, 49000, 48000, 47000, 46000, 45000, 44000, 43000, 42000, 41000, 40000, 39000, 38000, 37000, 36000, 35000, 34000, 33000, 32000, 31000, 30000, 29000, 28000, 27000, 26000, 25000, 24000, 23000, 22000, 21000, 20000, 19000, 18000, 17000, 16000, 15000, 14000, 13000, 12000, 11000, 10000, 9500, 9000, 8500, 8000, 7500, 7000, 6500, 6000, 5500, 5000, 4500, 4000, 3500, 3000, 2500, 2000, 1500, 1000, 900, 800, 700, 600, 500, 400, 300, 200, 100, 90, 80, 70, 60, 50, 40, 30, 20, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1};

        @Override
        public int getStrength(IPopularityMap iPopularityMap) {
            AlexaPopularityResult alexaPopularityResult = (AlexaPopularityResult)DomainStrengthUtil.a(SearchEngineFactorsList.ALEXA, iPopularityMap);
            if (alexaPopularityResult == null) {
                return -1;
            }
            if (alexaPopularityResult.equals((Object)AlexaPopularityResult.NA)) {
                return 0;
            }
            int n2 = alexaPopularityResult.getGlobalRank();
            int n3 = Arrays.binarySearch(a, n2, new a(this));
            return n3 < 0 ? -n3 - 1 : n3 + 1;
        }
    }

    public static class GooglePRFactorStrength
    extends b {
        public GooglePRFactorStrength() {
            super(null);
        }

        @Override
        public int getStrength(IPopularityMap iPopularityMap) {
            Integer n2 = (Integer)DomainStrengthUtil.a(SearchEngineFactorsList.DOMAIN_GOOGLE_PR, iPopularityMap);
            if (n2 == null) {
                return -1;
            }
            if (n2 == -1) {
                return 0;
            }
            return this.values[n2];
        }
    }

    public static class MozDomainAuthorityFactor
    extends b {
        public MozDomainAuthorityFactor() {
            super(null);
        }

        @Override
        public int getStrength(IPopularityMap iPopularityMap) {
            IMozAuthorityResult iMozAuthorityResult = (IMozAuthorityResult)DomainStrengthUtil.a(SearchEngineFactorsList.MOZ_AUTHORITY_FACTOR_TYPE, iPopularityMap);
            if (iMozAuthorityResult == null) {
                return -1;
            }
            int n2 = (int)Math.round(iMozAuthorityResult.getDomainAuthority() / 10.0);
            return this.values[n2];
        }
    }

    public static interface FactorStrength {
        public static final int NA = -1;

        public int getStrength(IPopularityMap var1);
    }
}

