/*
 * Decompiled with CFR 0.152.
 */
package com.agilemind.commons.application.modules.io.email.util;

import com.agilemind.commons.application.modules.io.email.data.Mail;
import com.agilemind.commons.application.modules.io.email.data.MailBoxSettings;
import com.agilemind.commons.application.modules.io.email.data.MailList;
import com.agilemind.commons.application.modules.io.email.data.MailMessage;
import com.agilemind.commons.application.modules.io.email.providers.OutboxMessagesInfoProvider;
import com.agilemind.commons.application.modules.io.email.util.MailOperation;
import com.agilemind.commons.application.modules.io.email.util.ReceiveMailOperation;
import com.agilemind.commons.application.modules.io.email.util.SendMailOperation;
import com.agilemind.commons.io.email.util.MailUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;

public abstract class MailBox {
    protected MailBox() {
    }

    public abstract Collection<MailMessage> getMessages();

    public abstract void messageSent(MailMessage var1, MimeMessage var2) throws MessagingException;

    public abstract MailBoxSettings getMailBoxSettings();

    public MailOperation createSendOperation() {
        return new SendMailOperation(this);
    }

    public abstract MailOperation createReceiveOperation();

    public static class ArrayListMailBox
    extends MailBox {
        private List<MailMessage> a;
        private MailBoxSettings b;

        public ArrayListMailBox(List<MailMessage> list, MailBoxSettings mailBoxSettings) {
            this.a = list;
            this.b = mailBoxSettings;
        }

        @Override
        public Collection<MailMessage> getMessages() {
            return this.a;
        }

        @Override
        public void messageSent(MailMessage mailMessage, MimeMessage mimeMessage) throws MessagingException {
        }

        @Override
        public MailBoxSettings getMailBoxSettings() {
            return this.b;
        }

        @Override
        public MailOperation createReceiveOperation() {
            throw new UnsupportedOperationException();
        }
    }

    public static class MailRecordMailBox
    extends MailBox {
        private Collection<MailMessage> a;
        private Mail b;

        public MailRecordMailBox(Mail mail, OutboxMessagesInfoProvider outboxMessagesInfoProvider) {
            boolean bl2 = MailOperation.b;
            this.b = mail;
            this.a = new ArrayList<MailMessage>(mail.getOutboxFolder().getMessages().getList());
            if (outboxMessagesInfoProvider != null) {
                Iterator<MailMessage> iterator = this.a.iterator();
                while (iterator.hasNext()) {
                    MailMessage mailMessage = iterator.next();
                    if (!outboxMessagesInfoProvider.mustBeSend(mailMessage)) {
                        iterator.remove();
                    }
                    if (!bl2) continue;
                }
            }
        }

        @Override
        public Collection<MailMessage> getMessages() {
            return this.a;
        }

        @Override
        public void messageSent(MailMessage mailMessage, MimeMessage mimeMessage) throws MessagingException {
            MailList mailList = this.b.getSentFolder().getMessages();
            int n2 = MailUtil.countBytes((Message)mimeMessage);
            MailMessage mailMessage2 = new MailMessage(mailList, (Message)mimeMessage, mimeMessage.getSentDate(), n2);
            mailMessage2.setReadByClient(true);
            this.b.getSentFolder().add(mailMessage2);
            this.b.getOutboxFolder().remove(mailMessage);
        }

        @Override
        public MailBoxSettings getMailBoxSettings() {
            return this.b.getMailBoxSettings();
        }

        @Override
        public MailOperation createReceiveOperation() {
            return new ReceiveMailOperation(this.b);
        }
    }
}

