/*
 * Decompiled with CFR 0.152.
 */
package com.agilemind.commons.application.modules.report.props.data;

import com.agilemind.commons.application.modules.report.props.data.IPersonInformation;
import com.agilemind.commons.data.Database;
import com.agilemind.commons.data.Identifier;
import com.agilemind.commons.data.Record;
import com.agilemind.commons.data.RecordBean;
import com.agilemind.commons.data.field.BinaryFileValueField;
import com.agilemind.commons.data.field.RecordBeanField;
import com.agilemind.commons.data.field.StringValueField;
import com.agilemind.commons.data.field.URLValueField;
import com.agilemind.commons.gui.util.ImageFactory;
import com.agilemind.commons.io.IOUtils;
import com.agilemind.commons.io.utils.BinaryFile;
import com.agilemind.commons.modules.report.util.AdvTemplateStringKey;
import com.agilemind.commons.util.Resource;
import com.agilemind.commons.util.StringUtil;
import com.agilemind.commons.util.UnicodeURL;
import com.agilemind.commons.util.UnicodeURLFactory;
import com.agilemind.commons.util.UnicodeURLUtil;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;

public class PersonInformation
extends RecordBean
implements IPersonInformation {
    public static final StringValueField<PersonInformation> NAME_FIELD;
    public static final StringValueField<PersonInformation> ADDRES_FIELD;
    public static final URLValueField<PersonInformation> WEBSITE_FIELD;
    public static final StringValueField<PersonInformation> EMAIL_FIELD;
    public static final BinaryFileValueField<PersonInformation> LOGO_FIELD;
    public final String DEFAULT_CUSTOMER_NAME;
    public final String DEFAULT_CUSTOMER_EMAIL;
    public final String DEFAULT_CUSTOMER_WEBSITE;
    private static final String[] i;

    public PersonInformation(Database database, Identifier identifier) {
        super(database, identifier);
        this.DEFAULT_CUSTOMER_NAME = new AdvTemplateStringKey(i[8]).getString();
        this.DEFAULT_CUSTOMER_EMAIL = new AdvTemplateStringKey(i[9]).getString();
        this.DEFAULT_CUSTOMER_WEBSITE = new AdvTemplateStringKey(i[7]).getString();
    }

    public PersonInformation(Record record) {
        super(record);
        this.DEFAULT_CUSTOMER_NAME = new AdvTemplateStringKey(i[4]).getString();
        this.DEFAULT_CUSTOMER_EMAIL = new AdvTemplateStringKey(i[6]).getString();
        this.DEFAULT_CUSTOMER_WEBSITE = new AdvTemplateStringKey(i[5]).getString();
    }

    public static PersonInformation createMergedFakeCustomerInformation(PersonInformation personInformation) {
        return PersonInformation.mergePersonInformation(personInformation, PersonInformation.createFakeCustomerInformation());
    }

    public static PersonInformation createMergedFakeCompanyInformation(PersonInformation personInformation) {
        return PersonInformation.mergePersonInformation(personInformation, PersonInformation.createFakeCompanyInformation());
    }

    public static PersonInformation mergePersonInformation(PersonInformation personInformation, PersonInformation personInformation2) {
        if (personInformation != null) {
            if (!StringUtil.isEmpty((String)personInformation.getName())) {
                personInformation2.setName(personInformation.getName());
            }
            if (!StringUtil.isEmpty((String)personInformation.getEmail())) {
                personInformation2.setEmail(personInformation.getEmail());
            }
            if (!UnicodeURLUtil.isEmpty((UnicodeURL)personInformation.getWebsite())) {
                personInformation2.setWebsite(personInformation.getWebsite());
            }
            if (!StringUtil.isEmpty((String)personInformation.getAddress())) {
                personInformation2.setAddress(personInformation.getAddress());
            }
            if (!StringUtil.isEmpty((Object)personInformation.getLogo())) {
                personInformation2.setLogo(personInformation.getLogo());
            }
        }
        return personInformation2;
    }

    public static PersonInformation createFakeCustomerInformation() {
        PersonInformation personInformation = new PersonInformation(null);
        PersonInformation.setDefaultCustomerInformation(personInformation);
        return personInformation;
    }

    public static void setDefaultCustomerInformation(PersonInformation personInformation) {
        personInformation.setAddress(new AdvTemplateStringKey(i[10]).getString());
        personInformation.setEmail(personInformation.DEFAULT_CUSTOMER_EMAIL);
        personInformation.setLogo(null);
        personInformation.setName(personInformation.DEFAULT_CUSTOMER_NAME);
        try {
            personInformation.setWebsite(UnicodeURLFactory.getInstance().createUnicodeURL(personInformation.DEFAULT_CUSTOMER_WEBSITE));
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
    }

    public static PersonInformation createFakeCompanyInformation() {
        PersonInformation personInformation = new PersonInformation(null);
        personInformation.setAddress(new AdvTemplateStringKey(i[1]).getString());
        personInformation.setEmail(new AdvTemplateStringKey(i[3]).getString());
        personInformation.setLogo(null);
        personInformation.setName(new AdvTemplateStringKey(i[2]).getString());
        try {
            personInformation.setWebsite(UnicodeURLFactory.getInstance().createUnicodeURL(new AdvTemplateStringKey(i[0]).getString()));
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return personInformation;
    }

    @Override
    public String getName() {
        return (String)this.get((RecordBeanField)NAME_FIELD);
    }

    public String getFirstName() {
        return StringUtil.getFirstName((String)this.getName());
    }

    public void setName(String string) {
        this.set((RecordBeanField)NAME_FIELD, string);
    }

    @Override
    public String getAddress() {
        return (String)this.get((RecordBeanField)ADDRES_FIELD);
    }

    public void setAddress(String string) {
        this.set((RecordBeanField)ADDRES_FIELD, string);
    }

    @Override
    public UnicodeURL getWebsite() {
        return (UnicodeURL)this.get((RecordBeanField)WEBSITE_FIELD);
    }

    public void setWebsite(UnicodeURL unicodeURL) {
        this.set((RecordBeanField)WEBSITE_FIELD, unicodeURL);
    }

    @Override
    public String getEmail() {
        return (String)this.get((RecordBeanField)EMAIL_FIELD);
    }

    public void setEmail(String string) {
        this.set((RecordBeanField)EMAIL_FIELD, string);
    }

    @Override
    public BinaryFile getLogo() {
        return (BinaryFile)this.get((RecordBeanField)LOGO_FIELD);
    }

    public void setLogo(BinaryFile binaryFile) {
        this.set((RecordBeanField)LOGO_FIELD, binaryFile);
    }

    public void setDefaultSPSLogo() throws IOException, InterruptedException {
        Resource resource = ImageFactory.getResource((String)i[12]);
        this.set((RecordBeanField)LOGO_FIELD, new BinaryFile(i[11], IOUtils.readBytes((InputStream)resource.getInputStream())));
    }

    public boolean isFullyAndProperlyFilledCompanyInfo() {
        return !StringUtil.isEmpty((String)this.getName()) && !StringUtil.isEmpty((String)this.getEmail()) && StringUtil.isValidEmail((String)this.getEmail()) && this.getWebsite() != null && StringUtil.isValideHttpAddress((String)this.getWebsite().toUnicodeString()) && this.getLogo() != null;
    }

    public boolean isFullyAndProperlyFilledCustomerInfo() {
        return !StringUtil.isEmpty((String)this.getName()) && !this.DEFAULT_CUSTOMER_NAME.equals(this.getName()) && !StringUtil.isEmpty((String)this.getEmail()) && !this.DEFAULT_CUSTOMER_EMAIL.equals(this.getEmail()) && StringUtil.isValidEmail((String)this.getEmail()) && this.getWebsite() != null && !this.DEFAULT_CUSTOMER_WEBSITE.equals(this.getWebsite().toUnicodeString()) && StringUtil.isValideWildcardHttpAddress((String)this.getWebsite().toUnicodeString());
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[18];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n2 = 0;
        String string2 = "s\u0018\u0001\u0007M~\u000e%\u0019J\u007fY\b\u0012Jq\u0002\u0000\u0003{u\u0015\u001f\u001eXuY\u0018\u0012Td";
        int n3 = -1;
        block25: while (true) {
            char[] cArray;
            block30: {
                int n4;
                int n5;
                char[] cArray2;
                int n6;
                block29: {
                    char[] cArray3 = string2.toCharArray();
                    n6 = 0;
                    int n7 = cArray3.length;
                    cArray2 = cArray3;
                    n5 = n7;
                    if (n7 <= 1) break block29;
                    cArray = cArray2;
                    n4 = n5;
                    if (n5 <= n6) break block30;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n8 = n6;
                    while (true) {
                        int n9;
                        char c3 = cArray4[n8];
                        switch (n6 % 5) {
                            case 0: {
                                n9 = 16;
                                break;
                            }
                            case 1: {
                                n9 = 119;
                                break;
                            }
                            case 2: {
                                n9 = 108;
                                break;
                            }
                            case 3: {
                                n9 = 119;
                                break;
                            }
                            default: {
                                n9 = 44;
                            }
                        }
                        cArray4[n8] = (char)(c3 ^ n9);
                        ++n6;
                        cArray2 = cArray5;
                        n5 = n5;
                        if (n5 != 0) break;
                        cArray5 = cArray2;
                        n4 = n5;
                        n8 = n5;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n4 = n5;
                } while (n5 > n6);
            }
            string = new String(cArray);
            switch (n3) {
                default: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 1;
                    string2 = "s\u0018\u0001\u0007M~\u000e%\u0019J\u007fY\b\u0012Jq\u0002\u0000\u0003mt\u0013\u001e\u0012_cY\u0018\u0012Td";
                    n3 = 0;
                    continue block25;
                }
                case 0: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 2;
                    string2 = "s\u0018\u0001\u0007M~\u000e%\u0019J\u007fY\b\u0012Jq\u0002\u0000\u0003bq\u001a\tYXu\u000f\u0018";
                    n3 = 1;
                    continue block25;
                }
                case 1: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 3;
                    string2 = "s\u0018\u0001\u0007M~\u000e%\u0019J\u007fY\b\u0012Jq\u0002\u0000\u0003i}\u0016\u0005\u001b\u0002d\u0012\u0014\u0003";
                    n3 = 2;
                    continue block25;
                }
                case 2: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 4;
                    string2 = "s\u0002\u001f\u0003C}\u0012\u001e>Bv\u0018B\u0013Iv\u0016\u0019\u001bX^\u0016\u0001\u0012\u0002d\u0012\u0014\u0003";
                    n3 = 3;
                    continue block25;
                }
                case 3: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 5;
                    string2 = "s\u0002\u001f\u0003C}\u0012\u001e>Bv\u0018B\u0013Iv\u0016\u0019\u001bXG\u0012\u000e\u0004Ed\u0012B\u0003Ih\u0003";
                    n3 = 4;
                    continue block25;
                }
                case 4: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 6;
                    string2 = "s\u0002\u001f\u0003C}\u0012\u001e>Bv\u0018B\u0013Iv\u0016\u0019\u001bXU\u001a\r\u001e@>\u0003\t\u000fX";
                    n3 = 5;
                    continue block25;
                }
                case 5: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 7;
                    string2 = "s\u0002\u001f\u0003C}\u0012\u001e>Bv\u0018B\u0013Iv\u0016\u0019\u001bXG\u0012\u000e\u0004Ed\u0012B\u0003Ih\u0003";
                    n3 = 6;
                    continue block25;
                }
                case 6: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 8;
                    string2 = "s\u0002\u001f\u0003C}\u0012\u001e>Bv\u0018B\u0013Iv\u0016\u0019\u001bX^\u0016\u0001\u0012\u0002d\u0012\u0014\u0003";
                    n3 = 7;
                    continue block25;
                }
                case 7: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 9;
                    string2 = "s\u0002\u001f\u0003C}\u0012\u001e>Bv\u0018B\u0013Iv\u0016\u0019\u001bXU\u001a\r\u001e@>\u0003\t\u000fX";
                    n3 = 8;
                    continue block25;
                }
                case 8: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 10;
                    string2 = "s\u0002\u001f\u0003C}\u0012\u001e>Bv\u0018B\u0013Iv\u0016\u0019\u001bXQ\u0013\b\u0005Ic\u0004B\u0003Ih\u0003";
                    n3 = 9;
                    continue block25;
                }
                case 9: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 11;
                    string2 = "c\u0012\u0003Z\\\u007f\u0000\t\u0005_e\u001e\u0018\u0012\u0002`\u0019\u000b";
                    n3 = 10;
                    continue block25;
                }
                case 10: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 12;
                    string2 = "?\u0014\u0003\u001aA\u007f\u0019\u001fX_u\u0018A\u0007Cg\u0012\u001e\u0004Yy\u0003\tY\\~\u0010";
                    n3 = 11;
                    continue block25;
                }
                case 11: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 13;
                    string2 = "g\u0012\u000e\u0004Ed\u0012";
                    n3 = 12;
                    continue block25;
                }
                case 12: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 14;
                    string2 = "|\u0018\u000b\u0018";
                    n3 = 13;
                    continue block25;
                }
                case 13: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 15;
                    string2 = "~\u0016\u0001\u0012";
                    n3 = 14;
                    continue block25;
                }
                case 14: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 16;
                    string2 = "u\u001a\r\u001e@";
                    n3 = 15;
                    continue block25;
                }
                case 15: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 17;
                    string2 = "q\u0013\b\u0005Ic\u0004";
                    n3 = 16;
                    continue block25;
                }
                case 16: 
            }
            break;
        }
        stringArray2[n2] = string.intern();
        i = stringArray3;
        NAME_FIELD = new StringValueField(i[15], PersonInformation.class);
        ADDRES_FIELD = new StringValueField(i[17], PersonInformation.class);
        WEBSITE_FIELD = new URLValueField(i[13], PersonInformation.class);
        EMAIL_FIELD = new StringValueField(i[16], PersonInformation.class);
        LOGO_FIELD = new BinaryFileValueField(i[14], PersonInformation.class);
    }
}

