/*
 * Decompiled with CFR 0.152.
 */
package com.agilemind.commons.application.modules.scheduler.data;

import com.agilemind.commons.application.controllers.ApplicationControllerImpl;
import com.agilemind.commons.application.data.IProject;
import com.agilemind.commons.application.data.IProjectMetaData;
import com.agilemind.commons.data.ClassMapper;
import com.agilemind.commons.data.Database;
import com.agilemind.commons.modules.storage.StorageType;
import java.io.File;
import java.io.FileNotFoundException;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProjectDescriptor {
    private String a;
    private String b;
    private IProject c;
    private StorageType d;
    private static final Logger e = LoggerFactory.getLogger(ProjectDescriptor.class);

    public ProjectDescriptor(IProject iProject) {
        this.c = iProject;
        this.a = iProject.getProjectName();
        IProjectMetaData iProjectMetaData = iProject.getMetadata();
        if (iProjectMetaData != null) {
            this.b = iProjectMetaData.getLocation().getPath();
            this.d = iProjectMetaData.getLocation().getStorageType();
        }
    }

    public ProjectDescriptor(String string, String string2, String string3, StorageType storageType) {
        this.a = string;
        this.d = storageType;
        string3 = '.' + string3;
        if (string.endsWith(string3)) {
            this.a = string.substring(0, string.length() - string3.length());
        }
        this.b = string2;
    }

    public String getProjectName() {
        return this.a;
    }

    public void setProjectName(String string) {
        this.a = string;
    }

    @Nullable
    public String getProjectPath() {
        return this.b;
    }

    public void setProjectPath(String string) {
        this.b = string;
    }

    @Nullable
    public IProject getProject() {
        return this.c;
    }

    public StorageType getStorageType() {
        if (this.d != null) {
            return this.d;
        }
        if (this.c == null || this.c.getMetadata() == null) {
            return null;
        }
        return this.c.getMetadata().getLocation().getStorageType();
    }

    @Nullable
    public IProject getProjectOrLoad(ApplicationControllerImpl<?> applicationControllerImpl) {
        if (this.c == null) {
            try {
                Database database = new Database((ClassMapper)applicationControllerImpl.getClassMapper(), new File(this.b));
                this.c = (IProject)database.getRootRecord(applicationControllerImpl.getProjectRecordBeanClass());
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
            catch (Throwable throwable) {
                e.error("", throwable);
            }
        }
        return this.c;
    }

    public void setProject(IProject iProject) {
        this.c = iProject;
    }

    public boolean equals(Object object) {
        if (object instanceof ProjectDescriptor) {
            ProjectDescriptor projectDescriptor = (ProjectDescriptor)object;
            if (this.b == null) {
                String string = projectDescriptor.getProjectPath();
                if (string == null) {
                    if (this.a == null) {
                        return projectDescriptor.getProjectName() == null;
                    }
                    return this.a.equals(projectDescriptor.getProjectName());
                }
                return false;
            }
            return this.b.equals(projectDescriptor.getProjectPath());
        }
        return false;
    }

    public int hashCode() {
        return this.b != null ? this.b.hashCode() : this.a.hashCode();
    }
}

