/*
 * Decompiled with CFR 0.152.
 */
package com.agilemind.commons.application.modules.storage;

import com.agilemind.commons.application.controllers.ApplicationControllerImpl;
import com.agilemind.commons.application.modules.concurrent.controllers.nontransactional.SingleOperationDialogController;
import com.agilemind.commons.application.modules.io.proxy.util.ExecuteWithCommonOperation;
import com.agilemind.commons.application.modules.storage.ExceptionMapperImpl;
import com.agilemind.commons.application.modules.storage.b;
import com.agilemind.commons.application.modules.storage.c;
import com.agilemind.commons.application.modules.storage.f;
import com.agilemind.commons.io.pagereader.IConnectionSettings;
import com.agilemind.commons.localization.IStringKey;
import com.agilemind.commons.localization.stringkey.StringKey;
import com.agilemind.commons.modules.concurrent.util.operations.Operation;
import com.agilemind.commons.modules.storage.StorageType;
import com.agilemind.commons.modules.storage.projects.ProjectEntry;
import com.agilemind.commons.modules.storage.projects.ProjectStorage;
import com.agilemind.commons.modules.storage.projects.gui.StorageEntityPresentation;
import com.agilemind.commons.modules.storage.projects.gui.StoragePresentation;
import com.agilemind.commons.mvc.controllers.ApplicationControllerProvider;
import com.agilemind.commons.util.Function;
import com.agilemind.commons.util.Precondition;
import com.agilemind.commons.util.Util;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public abstract class CachedStoragePresentation<T extends ProjectEntry>
implements StoragePresentation<T> {
    private ApplicationControllerProvider a;
    private StorageType b;
    private ProjectStorage<T> c;
    private Map<String, List<T>> d = new HashMap<String, List<T>>();

    public CachedStoragePresentation(ApplicationControllerProvider applicationControllerProvider, StorageType storageType, ProjectStorage<T> projectStorage) {
        this.a = applicationControllerProvider;
        this.b = storageType;
        this.c = projectStorage;
    }

    @Nullable
    public T getStorageEntry(StorageEntityPresentation storageEntityPresentation) {
        return this.a(storageEntityPresentation);
    }

    protected abstract Precondition<T> getSearchStorageEntryPrecondition(StorageEntityPresentation var1);

    public String[] getRootNames() {
        return new String[]{this.getHomeDirectoryName()};
    }

    public String getHomeDirectoryName() {
        return "/";
    }

    public String[] list(StorageEntityPresentation storageEntityPresentation) {
        String string = storageEntityPresentation.getPath();
        List<T> list = this.d.get(string);
        if (list == null) {
            ApplicationControllerImpl applicationControllerImpl = (ApplicationControllerImpl)this.a.getApplicationController();
            SingleOperationDialogController singleOperationDialogController = applicationControllerImpl.createDialog(SingleOperationDialogController.class);
            c<T> c3 = new c<T>(applicationControllerImpl, this.c, this.b, string);
            singleOperationDialogController.show((Operation)new ExecuteWithCommonOperation((IConnectionSettings)applicationControllerImpl.getConnectionSettings(), (Operation)c3, false, applicationControllerImpl));
            list = c3.getStorageEntries();
            this.d.put(string, list);
        }
        return Util.transform(list, (Function)new f(this)).toArray(new String[list.size()]);
    }

    public long getLastModifiedTime(StorageEntityPresentation storageEntityPresentation) {
        T t2 = this.a(storageEntityPresentation);
        if (t2 == null) {
            return 0L;
        }
        return t2.getLastModification();
    }

    public boolean isDirectory(StorageEntityPresentation storageEntityPresentation) {
        if (storageEntityPresentation.getPath().equals("/")) {
            return true;
        }
        T t2 = this.a(storageEntityPresentation);
        if (t2 == null) {
            return false;
        }
        return t2.isDirectory();
    }

    private T a(StorageEntityPresentation storageEntityPresentation) {
        boolean bl2 = ExceptionMapperImpl.b;
        for (List<T> list : this.d.values()) {
            ProjectEntry projectEntry = (ProjectEntry)Util.find(list, this.getSearchStorageEntryPrecondition(storageEntityPresentation));
            if (projectEntry != null) {
                return (T)projectEntry;
            }
            if (!bl2) continue;
        }
        return null;
    }

    public boolean createDirectory(StorageEntityPresentation storageEntityPresentation) {
        ApplicationControllerImpl applicationControllerImpl = (ApplicationControllerImpl)this.a.getApplicationController();
        SingleOperationDialogController singleOperationDialogController = applicationControllerImpl.createDialog(SingleOperationDialogController.class);
        singleOperationDialogController.show((Operation)new b(this, (IStringKey)StringKey.NULL_STRING_KEY, storageEntityPresentation));
        return true;
    }

    public long getLength(StorageEntityPresentation storageEntityPresentation) {
        T t2 = this.a(storageEntityPresentation);
        if (t2 == null) {
            return 0L;
        }
        return this.getLength(t2);
    }

    protected abstract long getLength(T var1);

    public long getCreationTime(StorageEntityPresentation storageEntityPresentation) {
        T t2 = this.a(storageEntityPresentation);
        if (t2 == null) {
            return 0L;
        }
        return this.getCreationTime(t2);
    }

    protected abstract long getCreationTime(T var1);

    public boolean canWrite(StorageEntityPresentation storageEntityPresentation) {
        return true;
    }

    public boolean exists(StorageEntityPresentation storageEntityPresentation) {
        if (storageEntityPresentation.getPath().equals("/")) {
            return true;
        }
        return this.a(storageEntityPresentation) != null;
    }

    public void refresh() {
        this.d.clear();
    }

    static /* synthetic */ ProjectStorage access$000(CachedStoragePresentation cachedStoragePresentation) {
        return cachedStoragePresentation.c;
    }
}

