/*
 * Decompiled with CFR 0.152.
 */
package com.agilemind.commons.application.modules.storage.dropbox;

import com.agilemind.commons.application.modules.storage.dropbox.a;
import com.agilemind.commons.application.modules.storage.dropbox.data.DropboxAccountInfo;
import com.agilemind.commons.application.modules.storage.dropbox.data.DropboxFile;
import com.agilemind.commons.application.modules.storage.dropbox.exceptions.DropboxErrorException;
import com.agilemind.commons.application.modules.storage.dropbox.exceptions.DropboxException;
import com.agilemind.commons.application.modules.storage.dropbox.exceptions.DropboxFileNotFoundException;
import com.agilemind.commons.application.modules.storage.dropbox.exceptions.FolderNotFoundException;
import com.agilemind.commons.application.modules.storage.dropbox.exceptions.StorageQuotaReachedException;
import com.agilemind.commons.application.modules.storage.dropbox.exceptions.WrongAuthorizationException;
import com.agilemind.commons.application.modules.storage.dropbox.f;
import com.agilemind.commons.modules.storage.account.StorageAccountInfo;
import com.agilemind.commons.modules.storage.projects.ProjectStorage;
import com.agilemind.commons.mvc.controllers.Controller;
import com.agilemind.commons.util.Function;
import com.agilemind.commons.util.Util;
import com.dropbox.core.DbxAppInfo;
import com.dropbox.core.DbxAuthFinish;
import com.dropbox.core.DbxClient;
import com.dropbox.core.DbxEntry;
import com.dropbox.core.DbxException;
import com.dropbox.core.DbxHost;
import com.dropbox.core.DbxRequestConfig;
import com.dropbox.core.DbxRequestUtil;
import com.dropbox.core.DbxWriteMode;
import com.dropbox.core.http.HttpRequestor;
import com.dropbox.core.util.StringUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.jetbrains.annotations.NotNull;

public class DropboxProjectStorage
implements ProjectStorage<DropboxFile> {
    public static final String CLIENT_IDENTIFIER;
    private StorageAccountInfo a;
    public static int b;
    private static final String[] c;

    public DropboxProjectStorage(StorageAccountInfo storageAccountInfo) {
        this.a = storageAccountInfo;
    }

    public boolean isFileChanged(DropboxFile dropboxFile) throws IOException, InterruptedException {
        DbxEntry dbxEntry;
        DbxClient dbxClient = this.a(this.a);
        try {
            dbxEntry = dbxClient.getMetadata(dropboxFile.getPath());
            if (dbxEntry == null) {
                return false;
            }
            if (!dbxEntry.isFile()) {
                return false;
            }
        }
        catch (DbxException dbxException) {
            throw this.a(dropboxFile.getPath(), dbxException);
        }
        DbxEntry.File file = dbxEntry.asFile();
        boolean bl2 = !file.rev.equals(dropboxFile.getRevision());
        return bl2;
    }

    public DropboxFile get(String string) throws IOException {
        DbxClient dbxClient = this.a(this.a);
        try {
            DbxEntry dbxEntry;
            if (!string.startsWith("/")) {
                string = "/" + string;
            }
            if ((dbxEntry = dbxClient.getMetadata(string)) == null) {
                return null;
            }
            return this.a(dbxEntry);
        }
        catch (DbxException dbxException) {
            throw this.a(string, dbxException);
        }
    }

    public List<DropboxFile> list() throws IOException {
        return this.list("/");
    }

    public List<DropboxFile> list(String string) throws IOException {
        DbxClient dbxClient = this.a(this.a);
        try {
            DbxEntry.WithChildren withChildren = dbxClient.getMetadataWithChildren(string);
            if (withChildren == null) {
                throw new FolderNotFoundException();
            }
            return Util.transform((Iterable)withChildren.children, (Function)new f(this));
        }
        catch (DbxException dbxException) {
            throw this.a(string, dbxException);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public DropboxFile downloadFile(String string, File file) throws IOException {
        int n2 = b;
        DbxClient dbxClient = this.a(this.a);
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            Throwable throwable = null;
            try {
                DbxEntry.File file2 = dbxClient.getFile(string, null, (OutputStream)fileOutputStream);
                if (file2 == null) {
                    throw new DropboxFileNotFoundException(string);
                }
                DropboxFile dropboxFile = this.a(file2);
                return dropboxFile;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                block19: {
                    if (fileOutputStream != null) {
                        if (throwable != null) {
                            try {
                                fileOutputStream.close();
                                break block19;
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                                if (n2 == 0) break block19;
                            }
                        }
                        fileOutputStream.close();
                    }
                }
            }
        }
        catch (DbxException dbxException) {
            throw this.a(string, dbxException);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public DropboxFile saveFile(String string, String string2, File file) throws IOException, InterruptedException {
        int n2 = b;
        DbxClient dbxClient = this.a(this.a);
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            Throwable throwable = null;
            try {
                DbxEntry.File file2 = dbxClient.uploadFile(string2, DbxWriteMode.force(), file.length(), (InputStream)fileInputStream);
                DropboxFile dropboxFile = this.a(file2);
                return dropboxFile;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                block17: {
                    if (fileInputStream != null) {
                        if (throwable != null) {
                            try {
                                fileInputStream.close();
                                break block17;
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                                if (n2 == 0) break block17;
                            }
                        }
                        fileInputStream.close();
                    }
                }
            }
        }
        catch (DbxException dbxException) {
            throw this.a(string2, dbxException);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public DropboxFile updateFile(DropboxFile dropboxFile, File file) throws IOException, InterruptedException {
        int n2 = b;
        DbxClient dbxClient = this.a(this.a);
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            Throwable throwable = null;
            try {
                DbxEntry.File file2 = dbxClient.uploadFile(dropboxFile.getPath(), DbxWriteMode.force(), file.length(), (InputStream)fileInputStream);
                DropboxFile dropboxFile2 = this.a(file2);
                return dropboxFile2;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                block17: {
                    if (fileInputStream != null) {
                        if (throwable != null) {
                            try {
                                fileInputStream.close();
                                break block17;
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                                if (n2 == 0) break block17;
                            }
                        }
                        fileInputStream.close();
                    }
                }
            }
        }
        catch (DbxException dbxException) {
            throw this.a(dropboxFile.getPath(), dbxException);
        }
    }

    public DropboxFile createFolder(String string) throws IOException {
        DbxClient dbxClient = this.a(this.a);
        try {
            DbxEntry.Folder folder = dbxClient.createFolder(string);
            return this.a(folder);
        }
        catch (DbxException dbxException) {
            throw this.a(string, dbxException);
        }
    }

    public boolean delete(DropboxFile dropboxFile) throws IOException {
        DbxClient dbxClient = this.a(this.a);
        try {
            dbxClient.delete(dropboxFile.getPath());
            return true;
        }
        catch (DbxException dbxException) {
            throw this.a(dropboxFile.getPath(), dbxException);
        }
    }

    public String getSharedLink(String string) throws IOException {
        DbxClient dbxClient = this.a(this.a);
        try {
            String string2 = dbxClient.createShareableUrl(string);
            if (string2 == null) {
                throw new DropboxFileNotFoundException(string);
            }
            return string2;
        }
        catch (DbxException dbxException) {
            throw this.a(string, dbxException);
        }
    }

    public static DropboxAccountInfo getAccountInfo(String string) throws IOException {
        DbxClient dbxClient = DropboxProjectStorage.a(string);
        DbxRequestConfig dbxRequestConfig = dbxClient.getRequestConfig();
        String string2 = c[0];
        try {
            return DropboxProjectStorage.a(string, dbxRequestConfig, DbxHost.Default.api, string2, null, null, DropboxAccountInfo.reader);
        }
        catch (DbxException dbxException) {
            throw new DropboxErrorException(dbxException);
        }
    }

    private DbxClient a(StorageAccountInfo storageAccountInfo) throws WrongAuthorizationException {
        if (storageAccountInfo == null) {
            throw new WrongAuthorizationException();
        }
        return DropboxProjectStorage.a(storageAccountInfo.getAccessToken());
    }

    @NotNull
    private static DbxClient a(String string) throws WrongAuthorizationException {
        String string2 = Locale.getDefault().toString();
        DbxRequestConfig dbxRequestConfig = new DbxRequestConfig(c[16], string2);
        DbxClient dbxClient = new DbxClient(dbxRequestConfig, string, DbxHost.Default);
        if (dbxClient == null) {
            throw new IllegalStateException(String.format(c[15], c[18], c[17]));
        }
        return dbxClient;
    }

    private DropboxFile a(DbxEntry dbxEntry) {
        if (dbxEntry.isFile()) {
            return this.a(dbxEntry.asFile());
        }
        return this.a(dbxEntry.asFolder());
    }

    private DropboxFile a(DbxEntry.File file) {
        return new DropboxFile(file.name, file.path, file.rev, file.lastModified.getTime(), file.numBytes);
    }

    private DropboxFile a(DbxEntry.Folder folder) {
        return new DropboxFile(folder.name, folder.path);
    }

    private static <T> T a(String string, DbxRequestConfig dbxRequestConfig, String string2, String string3, String[] stringArray, ArrayList<HttpRequestor.Header> arrayList, DbxRequestUtil.ResponseHandler<T> responseHandler) throws DbxException {
        return (T)DbxRequestUtil.doGet((DbxRequestConfig)dbxRequestConfig, (String)string, (String)string2, (String)string3, (String[])stringArray, arrayList, responseHandler);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private DropboxException a(String string, DbxException dbxException) throws WrongAuthorizationException, StorageQuotaReachedException, DropboxErrorException, DropboxFileNotFoundException {
        if (dbxException instanceof DbxException.InvalidAccessToken) {
            throw new WrongAuthorizationException();
        }
        if (dbxException instanceof DbxException.BadResponseCode) {
            switch (((DbxException.BadResponseCode)dbxException).statusCode) {
                case 404: {
                    return new DropboxFileNotFoundException(string);
                }
                case 507: {
                    return new StorageQuotaReachedException();
                }
            }
        }
        return new DropboxErrorException(dbxException);
    }

    public static String getAuthorizeUrl(DbxAppInfo dbxAppInfo, String string, String string2, String string3) {
        int n2 = b;
        String string4 = DbxRequestUtil.buildUrlWithParams((String)string, (String)dbxAppInfo.host.web, (String)c[14], (String[])new String[]{c[11], dbxAppInfo.key, c[10], c[12], c[13], string2, c[9], string3});
        if (Controller.g != 0) {
            b = ++n2;
        }
        return string4;
    }

    public static DbxAuthFinish authFinish(DbxAppInfo dbxAppInfo, DbxRequestConfig dbxRequestConfig, String string, String string2) throws IOException {
        DbxAuthFinish dbxAuthFinish;
        block2: {
            int n2 = b;
            String[] stringArray = new String[]{c[4], c[3], c[7], string, c[1], string2, c[6], dbxRequestConfig.userLocale};
            ArrayList<HttpRequestor.Header> arrayList = new ArrayList<HttpRequestor.Header>();
            String string3 = dbxAppInfo.key + ":" + dbxAppInfo.secret;
            String string4 = StringUtil.base64Encode((byte[])StringUtil.stringToUtf8((String)string3));
            arrayList.add(new HttpRequestor.Header(c[5], c[8] + string4));
            try {
                dbxAuthFinish = (DbxAuthFinish)DbxRequestUtil.doPostNoAuth((DbxRequestConfig)dbxRequestConfig, (String)dbxAppInfo.host.api, (String)c[2], (String[])stringArray, arrayList, (DbxRequestUtil.ResponseHandler)new a());
                if (n2 == 0) break block2;
                int n3 = Controller.g;
                Controller.g = ++n3;
            }
            catch (DbxException dbxException) {
                throw new DropboxErrorException(dbxException);
            }
        }
        return dbxAuthFinish;
    }

    static /* synthetic */ DropboxFile access$000(DropboxProjectStorage dropboxProjectStorage, DbxEntry dbxEntry) {
        return dropboxProjectStorage.a(dbxEntry);
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[19];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n2 = 0;
        String string2 = "'vh\u0011X\u0018O^_o";
        int n3 = 18;
        block27: while (true) {
            char[] cArray;
            block32: {
                int n4;
                int n5;
                char[] cArray2;
                int n6;
                block31: {
                    char[] cArray3 = string2.toCharArray();
                    n6 = 0;
                    int n7 = cArray3.length;
                    cArray2 = cArray3;
                    n5 = n7;
                    if (n7 <= 1) break block31;
                    cArray = cArray2;
                    n4 = n5;
                    if (n5 <= n6) break block32;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n8 = n6;
                    while (true) {
                        int n9;
                        char c3 = cArray4[n8];
                        switch (n6 % 5) {
                            case 0: {
                                n9 = 116;
                                break;
                            }
                            case 1: {
                                n9 = 38;
                                break;
                            }
                            case 2: {
                                n9 = 59;
                                break;
                            }
                            case 3: {
                                n9 = 49;
                                break;
                            }
                            default: {
                                n9 = 27;
                            }
                        }
                        cArray4[n8] = (char)(c3 ^ n9);
                        ++n6;
                        cArray2 = cArray5;
                        n5 = n5;
                        if (n5 != 0) break;
                        cArray5 = cArray2;
                        n4 = n5;
                        n8 = n5;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n4 = n5;
                } while (n5 > n6);
            }
            string = new String(cArray);
            switch (n3) {
                case 18: {
                    CLIENT_IDENTIFIER = string.intern();
                    string2 = "E\tZRx\u001bSUE4\u001dH]^";
                    n3 = -1;
                    continue block27;
                }
                default: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 1;
                    string2 = "\u0006C_Xi\u0011EOnn\u0006O";
                    n3 = 0;
                    continue block27;
                }
                case 0: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 2;
                    string2 = "E\tTPn\u0000N\t\u001eo\u001bM^_";
                    n3 = 1;
                    continue block27;
                }
                case 1: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 3;
                    string2 = "\u0015SOYt\u0006OAPo\u001dIUnx\u001bB^";
                    n3 = 2;
                    continue block27;
                }
                case 2: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 4;
                    string2 = "\u0013TZ_o+RBA~";
                    n3 = 3;
                    continue block27;
                }
                case 3: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 5;
                    string2 = "5SOYt\u0006OAPo\u001dIU";
                    n3 = 4;
                    continue block27;
                }
                case 4: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 6;
                    string2 = "\u0018IXPw\u0011";
                    n3 = 5;
                    continue block27;
                }
                case 5: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 7;
                    string2 = "\u0017I_T";
                    n3 = 6;
                    continue block27;
                }
                case 6: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 8;
                    string2 = "6GHXxT";
                    n3 = 7;
                    continue block27;
                }
                case 7: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 9;
                    string2 = "\u0007RZE~";
                    n3 = 8;
                    continue block27;
                }
                case 8: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 10;
                    string2 = "\u0006CHAt\u001aU^no\rV^";
                    n3 = 9;
                    continue block27;
                }
                case 9: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 11;
                    string2 = "\u0017JRTu\u0000yRU";
                    n3 = 10;
                    continue block27;
                }
                case 10: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 12;
                    string2 = "\u0017I_T";
                    n3 = 11;
                    continue block27;
                }
                case 11: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 13;
                    string2 = "\u0006C_Xi\u0011EOnn\u0006O";
                    n3 = 12;
                    continue block27;
                }
                case 12: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 14;
                    string2 = "E\tTPn\u0000N\t\u001ez\u0001RS^i\u001d\\^";
                    n3 = 13;
                    continue block27;
                }
                case 13: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 15;
                    string2 = "4hTEU\u0001JW\u0011v\u0011RS^\u007fT\u0003H\u001f>\u0007\u0006VDh\u0000\u0006U^oTT^En\u0006H\u001b_n\u0018J";
                    n3 = 14;
                    continue block27;
                }
                case 14: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 16;
                    string2 = "'vh\u0011X\u0018O^_o";
                    n3 = 15;
                    continue block27;
                }
                case 15: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 17;
                    string2 = "\u0013COui\u001bVY^c7JRTu\u0000";
                    n3 = 16;
                    continue block27;
                }
                case 16: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 18;
                    string2 = "\u0017IV\u001ez\u0013OWTv\u001dH_\u001ex\u001bKV^u\u0007\tZAk\u0018OXPo\u001dIU\u001ev\u001bBN]~\u0007\tHEt\u0006G\\T4\u0010TTAy\u001b^\u0014ui\u001bVY^c$TT[~\u0017RhEt\u0006G\\T";
                    n3 = 17;
                    continue block27;
                }
                case 17: 
            }
            break;
        }
        stringArray2[n2] = string.intern();
        c = stringArray3;
    }
}

