/*
 * Decompiled with CFR 0.152.
 */
package com.agilemind.commons.application.modules.widget.mapper;

import com.agilemind.commons.application.data.WebProject;
import com.agilemind.commons.application.modules.io.searchengine.data.PopularityHistoryMap;
import com.agilemind.commons.application.modules.io.searchengine.data.UseSearchEngineFactorList;
import com.agilemind.commons.application.modules.report.colorscheme.WidgetColorScheme;
import com.agilemind.commons.application.modules.report.props.data.IPersonInformation;
import com.agilemind.commons.application.modules.widget.core.IWidgetReportSettings;
import com.agilemind.commons.application.modules.widget.core.WidgetType;
import com.agilemind.commons.application.modules.widget.mapper.CommonWidgetFactory;
import com.agilemind.commons.application.modules.widget.service.project.BacklinkFactorsWidgetProjectService;
import com.agilemind.commons.application.modules.widget.service.project.CatalogListingsProjectService;
import com.agilemind.commons.application.modules.widget.service.project.DomainInfoProjectService;
import com.agilemind.commons.application.modules.widget.service.project.ExternalDomainFactorsProjectService;
import com.agilemind.commons.application.modules.widget.service.project.IndexingInSearchEnginesProjectService;
import com.agilemind.commons.application.modules.widget.service.project.SocialMediaPopularityProjectService;
import com.agilemind.commons.application.modules.widget.service.project.TrafficToWebsiteProjectService;
import com.agilemind.commons.application.modules.widget.widget.BacklinkFactorsWidget;
import com.agilemind.commons.application.modules.widget.widget.CatalogListingsWidget;
import com.agilemind.commons.application.modules.widget.widget.DomainInfoWidget;
import com.agilemind.commons.application.modules.widget.widget.ExternalDomainFactorsWidget;
import com.agilemind.commons.application.modules.widget.widget.IWidget;
import com.agilemind.commons.application.modules.widget.widget.IndexingInSearchEngineWidget;
import com.agilemind.commons.application.modules.widget.widget.SocialMediaPopularityWidget;
import com.agilemind.commons.application.modules.widget.widget.TrafficToWebsiteWidget;
import com.agilemind.commons.io.searchengine.searchengines.data.IGoogleAnalyticsSettings;
import com.agilemind.commons.io.searchengine.searchengines.data.mozapi.IMozApiKeysSettings;
import com.agilemind.commons.modules.widget.ReportWidgetLocalizer;

public abstract class DomainWidgetFactory
extends CommonWidgetFactory {
    private PopularityHistoryMap d;
    private UseSearchEngineFactorList e;
    private IGoogleAnalyticsSettings f;
    private IMozApiKeysSettings g;

    public DomainWidgetFactory(WebProject webProject, IMozApiKeysSettings iMozApiKeysSettings, IPersonInformation iPersonInformation, IPersonInformation iPersonInformation2) {
        super(webProject, iPersonInformation, iPersonInformation2);
        this.f = webProject.getGoogleAnalyticsSettings();
        this.d = webProject.getPopularityHistoryMap();
        this.g = iMozApiKeysSettings;
        this.e = webProject.getUseDomainSearchEngineFactorList();
    }

    @Override
    public IWidget createWidget(IWidgetReportSettings iWidgetReportSettings, WidgetType widgetType) {
        ReportWidgetLocalizer reportWidgetLocalizer = this.getWidgetLocalizer(iWidgetReportSettings);
        WidgetColorScheme widgetColorScheme = iWidgetReportSettings.getColorSchema();
        switch (widgetType) {
            case EXTERNAL_DOMAIN_FACTORS: {
                ExternalDomainFactorsProjectService externalDomainFactorsProjectService = new ExternalDomainFactorsProjectService(this.d, this.e, this.getMozApiKeysSettings());
                return new ExternalDomainFactorsWidget(reportWidgetLocalizer, externalDomainFactorsProjectService);
            }
            case DOMAIN_INFO: {
                DomainInfoProjectService domainInfoProjectService = new DomainInfoProjectService(this.d, this.e);
                return new DomainInfoWidget(reportWidgetLocalizer, domainInfoProjectService);
            }
            case INDEXING_IN_SEARCH_ENGINES: {
                IndexingInSearchEnginesProjectService indexingInSearchEnginesProjectService = new IndexingInSearchEnginesProjectService(this.d, this.e);
                return new IndexingInSearchEngineWidget(reportWidgetLocalizer, indexingInSearchEnginesProjectService);
            }
            case CATALOG_LISTINGS: {
                CatalogListingsProjectService catalogListingsProjectService = new CatalogListingsProjectService(this.d, this.e);
                return new CatalogListingsWidget(reportWidgetLocalizer, catalogListingsProjectService);
            }
            case BACKLINK_FACTORS: {
                BacklinkFactorsWidgetProjectService backlinkFactorsWidgetProjectService = new BacklinkFactorsWidgetProjectService(this.d, this.e);
                return new BacklinkFactorsWidget(reportWidgetLocalizer, widgetColorScheme, backlinkFactorsWidgetProjectService);
            }
            case SOCIAL_MEDIA_POPULARITY: {
                SocialMediaPopularityProjectService socialMediaPopularityProjectService = new SocialMediaPopularityProjectService(this.f, this.project.getGaSocialVisitsMap(), this.d, this.e);
                return new SocialMediaPopularityWidget(reportWidgetLocalizer, socialMediaPopularityProjectService);
            }
            case TRAFFIC_TO_WEBSITE: {
                TrafficToWebsiteProjectService trafficToWebsiteProjectService = new TrafficToWebsiteProjectService(this.d, this.e, this.f);
                return new TrafficToWebsiteWidget(reportWidgetLocalizer, widgetColorScheme, trafficToWebsiteProjectService);
            }
        }
        return super.createWidget(iWidgetReportSettings, widgetType);
    }

    public IMozApiKeysSettings getMozApiKeysSettings() {
        return this.g;
    }
}

