/*
 * Decompiled with CFR 0.152.
 */
package com.agilemind.commons.application.modules.widget.service.project;

import com.agilemind.commons.application.modules.io.searchengine.data.PopularityHistoryMap;
import com.agilemind.commons.application.modules.io.searchengine.data.UseSearchEngineFactorList;
import com.agilemind.commons.application.modules.widget.service.BacklinkFactorsWidgetService;
import com.agilemind.commons.application.modules.widget.service.project.FactorsProjectService;
import com.agilemind.commons.application.modules.widget.util.to.ValuePercent;
import com.agilemind.commons.io.searchengine.analyzers.SearchEngineFactorsList;
import com.agilemind.commons.util.MathUtil;
import java.util.Arrays;
import java.util.List;

public class BacklinkFactorsWidgetProjectService
extends FactorsProjectService
implements BacklinkFactorsWidgetService {
    public BacklinkFactorsWidgetProjectService(PopularityHistoryMap popularityHistoryMap, UseSearchEngineFactorList useSearchEngineFactorList) {
        super(popularityHistoryMap, useSearchEngineFactorList);
    }

    @Override
    public Long getBacklinks() {
        return (Long)this.getUsedFactorValue(SearchEngineFactorsList.BACKLINKS_TOTAL);
    }

    @Override
    public Long getBacklinkDomains() {
        return (Long)this.getUsedFactorValue(SearchEngineFactorsList.BACKLINK_DOMAINS);
    }

    @Override
    public Long getIPs() {
        return (Long)this.getUsedFactorValue(SearchEngineFactorsList.BACKLINK_IPS);
    }

    @Override
    public Long getCBlocks() {
        return (Long)this.getUsedFactorValue(SearchEngineFactorsList.BACKLINK_C_BLOCKS);
    }

    @Override
    public ValuePercent getDofollowValuePercent() {
        Long l2 = (Long)this.getUsedFactorValue(SearchEngineFactorsList.BACKLINKS_TOTAL);
        if (l2 == null || l2 == 0L) {
            return null;
        }
        Long l3 = (Long)this.getFactorValue(SearchEngineFactorsList.DOFOLLOW_BACKLINKS);
        if (l3 == null) {
            return null;
        }
        return new ValuePercent(l3, MathUtil.getPercent((double)l2.longValue(), (double)l3.longValue()));
    }

    @Override
    public ValuePercent getNofollowValuePercent() {
        Long l2 = (Long)this.getUsedFactorValue(SearchEngineFactorsList.BACKLINKS_TOTAL);
        if (l2 == null || l2 == 0L) {
            return null;
        }
        Long l3 = (Long)this.getFactorValue(SearchEngineFactorsList.DOFOLLOW_BACKLINKS);
        if (l3 == null) {
            return null;
        }
        long l4 = l2 - l3;
        return new ValuePercent(l4, MathUtil.getPercent((double)l2.longValue(), (double)l4));
    }

    @Override
    public List<Double> getBacklinksData() {
        ValuePercent valuePercent = this.getDofollowValuePercent();
        if (valuePercent == null) {
            return null;
        }
        ValuePercent valuePercent2 = this.getNofollowValuePercent();
        if (valuePercent2 == null) {
            return null;
        }
        return Arrays.asList(valuePercent.getPercent(), valuePercent2.getPercent());
    }
}

