/*
 * Decompiled with CFR 0.152.
 */
package com.agilemind.commons.application.modules.widget.service.project;

import com.agilemind.commons.application.modules.factors.data.DomainStrengthUtil;
import com.agilemind.commons.application.modules.io.searchengine.data.PopularityHistoryMap;
import com.agilemind.commons.application.modules.io.searchengine.data.UseSearchEngineFactorList;
import com.agilemind.commons.application.modules.widget.service.ExternalDomainFactorsService;
import com.agilemind.commons.application.modules.widget.service.project.FactorsProjectService;
import com.agilemind.commons.io.searchengine.analyzers.SearchEngineFactorsList;
import com.agilemind.commons.io.searchengine.analyzers.data.AlexaPopularityResult;
import com.agilemind.commons.io.searchengine.analyzers.data.IMozAuthorityResult;
import com.agilemind.commons.io.searchengine.searchengines.data.mozapi.IMozApiKeysSettings;

public class ExternalDomainFactorsProjectService
extends FactorsProjectService
implements ExternalDomainFactorsService {
    private IMozApiKeysSettings c;

    public ExternalDomainFactorsProjectService(PopularityHistoryMap popularityHistoryMap, UseSearchEngineFactorList useSearchEngineFactorList, IMozApiKeysSettings iMozApiKeysSettings) {
        super(popularityHistoryMap, useSearchEngineFactorList);
        this.c = iMozApiKeysSettings;
    }

    @Override
    public Double getDomainStrength() {
        return DomainStrengthUtil.getStrength(this.c(), this.c.isUseInsteadPR());
    }

    @Override
    public double getDomainStrengthPercent(Double d2) {
        if (d2 == null || d2 == -1.0) {
            return 0.0;
        }
        return d2 * 10.0;
    }

    @Override
    public Integer getGooglePR() {
        return (Integer)this.getUsedFactorValue(SearchEngineFactorsList.DOMAIN_GOOGLE_PR);
    }

    @Override
    public double getPRPercent(Integer n2) {
        if (n2 == null || n2 == -1) {
            return 0.0;
        }
        return n2 * 10;
    }

    @Override
    public Double getDomainAuthority() {
        IMozAuthorityResult iMozAuthorityResult = (IMozAuthorityResult)this.getUsedFactorValue(SearchEngineFactorsList.MOZ_AUTHORITY_FACTOR_TYPE);
        if (iMozAuthorityResult == null) {
            return null;
        }
        return iMozAuthorityResult.getDomainAuthority();
    }

    @Override
    public double getDomainAuthorityPercent(Double d2) {
        if (d2 == null) {
            return 0.0;
        }
        return d2;
    }

    @Override
    public AlexaPopularityResult getAlexaPopularityResult() {
        return (AlexaPopularityResult)this.getUsedFactorValue(SearchEngineFactorsList.ALEXA);
    }

    @Override
    public Long getCompeteRank() {
        return (Long)this.getUsedFactorValue(SearchEngineFactorsList.SITEANALYTICS_COMPETE_FACTOR_TYPE);
    }

    @Override
    public Long getCompeteTraffic() {
        return (Long)this.getUsedFactorValue(SearchEngineFactorsList.SITEANALYTICS_TRAFFIC_FACTOR_TYPE);
    }

    @Override
    public Long getGooglePopularity() {
        return (Long)this.getUsedFactorValue(SearchEngineFactorsList.GOOGLE);
    }

    @Override
    public Integer getYandexCY() {
        return (Integer)this.getUsedFactorValue(SearchEngineFactorsList.YANDEX_CY);
    }

    protected IMozApiKeysSettings getMozApiKeysSettings() {
        return this.c;
    }
}

