/*
 * Decompiled with CFR 0.152.
 */
package com.agilemind.commons.application.util;

import com.agilemind.commons.application.controllers.ApplicationControllerImpl;
import com.agilemind.commons.application.data.IProjectLocation;
import com.agilemind.commons.application.data.IProjectMetaData;
import com.agilemind.commons.application.data.Project;
import com.agilemind.commons.application.data.ProjectMetaData;
import com.agilemind.commons.application.modules.storage.ProjectStorageFactory;
import com.agilemind.commons.application.util.BrowserPreviewSettings;
import com.agilemind.commons.application.util.CompressedProjectFileFilter;
import com.agilemind.commons.application.util.ProjectCorruptException;
import com.agilemind.commons.application.util.ProjectLoaderSaver;
import com.agilemind.commons.application.util.c;
import com.agilemind.commons.application.util.d;
import com.agilemind.commons.application.util.e;
import com.agilemind.commons.io.IOUtils;
import com.agilemind.commons.modules.storage.StorageType;
import com.agilemind.commons.modules.storage.projects.ProjectEntry;
import com.agilemind.commons.modules.storage.projects.ProjectStorage;
import com.agilemind.commons.mvc.controllers.Controller;
import com.agilemind.commons.mvc.util.ApplicationIOUtils;
import com.agilemind.commons.util.ThreadSafeUtil;
import com.agilemind.commons.util.errorproof.ExecuteAndReturn;
import com.agilemind.commons.util.errorproof.Executor;
import java.io.File;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OnlineStorageProjectLoaderSaver<P extends Project>
implements ProjectLoaderSaver<P> {
    private static final Logger a;
    private static final File b;
    private final ApplicationControllerImpl<P> c;
    private final StorageType d;
    private static final String[] f;

    public OnlineStorageProjectLoaderSaver(ApplicationControllerImpl<P> applicationControllerImpl, StorageType storageType) {
        this.c = applicationControllerImpl;
        this.d = storageType;
    }

    @Override
    public P loadProject(String string) throws IOException, InterruptedException {
        File file = OnlineStorageProjectLoaderSaver.createTmpProjectFolder(this.d);
        File file2 = OnlineStorageProjectLoaderSaver.createTmpProjectFile(file);
        ProjectEntry projectEntry = this.c().downloadFile(string, file2);
        File file3 = file2;
        if (IOUtils.isZipFile((File)file3)) {
            file3 = OnlineStorageProjectLoaderSaver.createTmpProjectFile(file);
            try {
                IOUtils.unzipFile((File)file2, (File)file3);
            }
            catch (IOException iOException) {
                throw new ProjectCorruptException(iOException, file2);
            }
            if (!file2.delete()) {
                a.error(f[2], (Object)file2.getAbsolutePath());
            }
        }
        File file4 = file3;
        return (P)((Project)ThreadSafeUtil.invokeWaitAndReturn((ExecuteAndReturn)new c(this, file4, projectEntry)));
    }

    @Override
    public boolean saveProject(P p2) throws IOException, InterruptedException {
        int n2;
        block19: {
            File file;
            boolean bl2;
            block18: {
                IProjectMetaData iProjectMetaData;
                File file2;
                block17: {
                    File file3;
                    block16: {
                        n2 = BrowserPreviewSettings.f;
                        file2 = p2.getDatabase().getFile();
                        if (e || file2 != null) break block16;
                        throw new AssertionError();
                    }
                    if (!file2.exists()) {
                        file3 = OnlineStorageProjectLoaderSaver.createTmpProjectFolder(this.d);
                        file2 = OnlineStorageProjectLoaderSaver.createTmpProjectFile(file3);
                    }
                    file3 = file2;
                    ThreadSafeUtil.invokeAndWait((Executor)new d(this, (Project)p2, file3));
                    iProjectMetaData = ((Project)p2).getMetadata();
                    if (e || iProjectMetaData != null) break block17;
                    throw new AssertionError();
                }
                bl2 = false;
                file = file2;
                IProjectLocation iProjectLocation = iProjectMetaData.getLocation();
                if (iProjectLocation.getStorageType() != this.d || !this.a(iProjectLocation.getPath())) break block18;
                file = OnlineStorageProjectLoaderSaver.createTmpProjectFile(file2.getParentFile());
                IOUtils.zipFile((File)file2, (File)file);
                bl2 = true;
            }
            ProjectEntry projectEntry = this.c().updateFile(((Project)p2).getMetadata().getProjectEntry(), file);
            ((Project)p2).setMetadata(new ProjectMetaData(this.d, projectEntry));
            if (!bl2 || file.delete()) break block19;
            a.error(f[1] + file.getAbsolutePath());
        }
        if (n2 != 0) {
            int n3 = Controller.g;
            Controller.g = ++n3;
        }
        return true;
    }

    @Override
    public boolean saveAsProject(P p2, String string, String string2) throws IOException, InterruptedException {
        File file = OnlineStorageProjectLoaderSaver.createTmpProjectFolder(this.d);
        File file2 = OnlineStorageProjectLoaderSaver.createTmpProjectFile(file);
        ThreadSafeUtil.invokeAndWait((Executor)new e(this, (Project)p2, file2));
        File file3 = OnlineStorageProjectLoaderSaver.createTmpProjectFile(file);
        IOUtils.zipFile((File)file2, (File)file3);
        ProjectEntry projectEntry = this.c().saveFile(string, string2, file3);
        ((Project)p2).setMetadata(new ProjectMetaData(this.d, projectEntry));
        if (!file3.delete()) {
            a.error(f[0] + file3.getAbsolutePath());
        }
        return true;
    }

    private ProjectStorage<ProjectEntry> c() throws IOException {
        ProjectStorageFactory projectStorageFactory = this.c.getProjectStorageFactory();
        return projectStorageFactory.getStorage(this.d);
    }

    private boolean a(String string) {
        CompressedProjectFileFilter compressedProjectFileFilter = this.c.getCompressedProjectFileFilter();
        return compressedProjectFileFilter.isCompressedFile(string);
    }

    public static File createTmpProjectFile(File file) throws IOException {
        File file2 = IOUtils.createRandomFile((File)file, (String)"");
        file2.deleteOnExit();
        return file2;
    }

    public static File createTmpProjectFolder(StorageType storageType) {
        File file = IOUtils.createRandomFolder((File)new File(b, storageType.getId()));
        file.deleteOnExit();
        return file;
    }

    static /* synthetic */ ApplicationControllerImpl access$000(OnlineStorageProjectLoaderSaver onlineStorageProjectLoaderSaver) {
        return onlineStorageProjectLoaderSaver.c;
    }

    static /* synthetic */ StorageType access$100(OnlineStorageProjectLoaderSaver onlineStorageProjectLoaderSaver) {
        return onlineStorageProjectLoaderSaver.d;
    }

    static /* synthetic */ Logger access$200() {
        return a;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[4];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n2 = 0;
        String string2 = "y\fd\nLIBq\u0007\u0000H\u0007i\rTIBq\u0005P\f\u0012w\u0007JI\u0001qHFE\u000e`H";
        int n3 = -1;
        block11: while (true) {
            char[] cArray;
            block16: {
                int n4;
                int n5;
                char[] cArray2;
                int n6;
                block15: {
                    char[] cArray3 = string2.toCharArray();
                    n6 = 0;
                    int n7 = cArray3.length;
                    cArray2 = cArray3;
                    n5 = n7;
                    if (n7 <= 1) break block15;
                    cArray = cArray2;
                    n4 = n5;
                    if (n5 <= n6) break block16;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n8 = n6;
                    while (true) {
                        int n9;
                        char c3 = cArray4[n8];
                        switch (n6 % 5) {
                            case 0: {
                                n9 = 44;
                                break;
                            }
                            case 1: {
                                n9 = 98;
                                break;
                            }
                            case 2: {
                                n9 = 5;
                                break;
                            }
                            case 3: {
                                n9 = 104;
                                break;
                            }
                            default: {
                                n9 = 32;
                            }
                        }
                        cArray4[n8] = (char)(c3 ^ n9);
                        ++n6;
                        cArray2 = cArray5;
                        n5 = n5;
                        if (n5 != 0) break;
                        cArray5 = cArray2;
                        n4 = n5;
                        n8 = n5;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n4 = n5;
                } while (n5 > n6);
            }
            string = new String(cArray);
            switch (n3) {
                default: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 1;
                    string2 = "y\fd\nLIBq\u0007\u0000H\u0007i\rTIBq\u0005P\f\u0012w\u0007JI\u0001qHFE\u000e`H";
                    n3 = 0;
                    continue block11;
                }
                case 0: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 2;
                    string2 = "y\fd\nLIBq\u0007\u0000H\u0007i\rTIBq\u0005P\f\u0012w\u0007JI\u0001qHFE\u000e`H[Q";
                    n3 = 1;
                    continue block11;
                }
                case 1: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 3;
                    string2 = "X\u000fu\u0018RC\b`\u000bT_";
                    n3 = 2;
                    continue block11;
                }
                case 2: 
            }
            break;
        }
        stringArray2[n2] = string.intern();
        f = stringArray3;
        a = LoggerFactory.getLogger(OnlineStorageProjectLoaderSaver.class);
        b = new File(ApplicationIOUtils.getUserTMPDir(), f[3]);
    }
}

