/*
 * Decompiled with CFR 0.152.
 */
package com.agilemind.commons.application.util;

import com.agilemind.commons.data.field.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class RecordUtil {
    public static <H, T> List<H> sort(Collection<H> collection, Field<H, T> field) {
        return RecordUtil.sort(collection, field, false);
    }

    public static <H, T> List<H> sort(Collection<H> collection, Field<H, T> field, boolean bl2) {
        ArrayList<H> arrayList = new ArrayList<H>(collection);
        FieldComparator<H, T> fieldComparator = new FieldComparator<H, T>(field, bl2);
        Collections.sort(arrayList, fieldComparator);
        return arrayList;
    }

    public static <H, T1, T2> List<H> sort(Collection<H> collection, Field<H, T1> field, Field<H, T2> field2, boolean bl2, boolean bl3) {
        ArrayList<H> arrayList = new ArrayList<H>(collection);
        TwoFieldsComparator<H, T1, T2> twoFieldsComparator = new TwoFieldsComparator<H, T1, T2>(field, field2, bl2, bl3);
        Collections.sort(arrayList, twoFieldsComparator);
        return arrayList;
    }

    public static class FieldComparator<H, T>
    implements Comparator<H> {
        private Field<H, T> a;
        private boolean b;

        public FieldComparator(Field<H, T> field, boolean bl2) {
            this.a = field;
            this.b = bl2;
        }

        @Override
        public int compare(H h2, H h3) {
            Object object = this.a.getObject(h2);
            Object object2 = this.a.getObject(h3);
            return this.b ? this.a.compare(object2, object) : this.a.compare(object, object2);
        }
    }

    public static class TwoFieldsComparator<H, T1, T2>
    implements Comparator<H> {
        private Comparator<H> a;
        private Comparator<H> b;

        public TwoFieldsComparator(Field<H, T1> field, Field<H, T2> field2, boolean bl2, boolean bl3) {
            this.a = new FieldComparator<H, T1>(field, bl2);
            this.b = new FieldComparator<H, T2>(field2, bl3);
        }

        @Override
        public int compare(H h2, H h3) {
            int n2 = this.a.compare(h2, h3);
            if (n2 == 0) {
                n2 = this.b.compare(h2, h3);
            }
            return n2;
        }
    }
}

