/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.common.authentication;

import com.sshtools.common.ui.IconWrapperPanel;
import com.sshtools.common.ui.ResourceIcon;
import com.sshtools.common.ui.UIUtil;
import com.sshtools.common.ui.XTextField;
import com.sshtools.j2ssh.authentication.AuthenticationProtocolException;
import com.sshtools.j2ssh.authentication.PasswordAuthenticationClient;
import com.sshtools.j2ssh.authentication.SshAuthenticationClient;
import com.sshtools.j2ssh.authentication.SshAuthenticationPrompt;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.lang.reflect.Method;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;

public class PasswordAuthenticationDialog
extends JDialog
implements SshAuthenticationPrompt {
    static final String KEY_ICON = "largecard.png";
    PasswordAuthenticationClient instance;
    JButton jButtonCancel = new JButton();
    JButton jButtonOK = new JButton();
    JPasswordField jPasswordField = new JPasswordField(20);
    XTextField jTextUsername = new XTextField(20);
    boolean userCancelled = false;

    public PasswordAuthenticationDialog() {
        super((Frame)null, "Password Authentication", true);
        this.init(null);
    }

    public PasswordAuthenticationDialog(Frame frame) {
        super(frame, "Password Authentication", true);
        this.init(frame);
    }

    public PasswordAuthenticationDialog(Dialog dialog) {
        super(dialog, "Password Authentication", true);
        this.init(dialog);
    }

    public String getPassword() {
        return String.valueOf(this.jPasswordField.getPassword());
    }

    public String getUsername() {
        return this.jTextUsername.getText();
    }

    public void setUsername(String string) {
        if (string != null) {
            this.jTextUsername.setText(string);
        }
    }

    public void setInstance(SshAuthenticationClient sshAuthenticationClient) throws AuthenticationProtocolException {
        if (!(sshAuthenticationClient instanceof PasswordAuthenticationClient)) {
            throw new AuthenticationProtocolException("PasswordAuthenticationClient instance required");
        }
        this.instance = (PasswordAuthenticationClient)sshAuthenticationClient;
    }

    public boolean showPrompt(SshAuthenticationClient sshAuthenticationClient) throws AuthenticationProtocolException {
        if (sshAuthenticationClient instanceof PasswordAuthenticationClient) {
            this.instance = (PasswordAuthenticationClient)sshAuthenticationClient;
            if (this.instance.getUsername() != null) {
                this.jTextUsername.setText(this.instance.getUsername());
            }
            if (!this.jTextUsername.getText().equals("")) {
                this.jPasswordField.grabFocus();
            }
            UIUtil.positionComponent(0, this);
            this.setVisible(true);
            if (!this.userCancelled) {
                this.instance.setUsername(this.getUsername());
                this.instance.setPassword(this.getPassword());
                return true;
            }
            return false;
        }
        throw new AuthenticationProtocolException("PasswordAuthenticationClient instance required");
    }

    void init(Window window) {
        this.setModal(true);
        this.getContentPane().setLayout(new GridLayout(1, 1));
        if (window != null) {
            try {
                Method method = this.getClass().getMethod("setLocationRelativeTo", window.getClass());
                method.invoke((Object)this, window);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        try {
            this.jbInit();
            this.pack();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    void jButtonCancel_actionPerformed(ActionEvent actionEvent) {
        this.userCancelled = true;
        this.setVisible(false);
    }

    void jButtonOK_actionPerformed(ActionEvent actionEvent) {
        if (this.jTextUsername.getText().trim().equals("")) {
            JOptionPane.showMessageDialog(this, "You must enter a username!", "Password Authentication", 0);
            return;
        }
        this.setVisible(false);
    }

    void jbInit() throws Exception {
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                PasswordAuthenticationDialog.this.userCancelled = true;
            }
        });
        this.jButtonOK.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PasswordAuthenticationDialog.this.jButtonOK_actionPerformed(actionEvent);
            }
        });
        this.jButtonOK.setText("OK");
        this.jButtonOK.setMnemonic('o');
        this.getRootPane().setDefaultButton(this.jButtonOK);
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.setMnemonic('c');
        this.jButtonCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PasswordAuthenticationDialog.this.jButtonCancel_actionPerformed(actionEvent);
            }
        });
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 2, 2, 2);
        gridBagConstraints.weightx = 1.0;
        UIUtil.jGridBagAdd(jPanel, new JLabel("User"), gridBagConstraints, 0);
        gridBagConstraints.fill = 2;
        UIUtil.jGridBagAdd(jPanel, this.jTextUsername, gridBagConstraints, 0);
        gridBagConstraints.fill = 0;
        UIUtil.jGridBagAdd(jPanel, new JLabel("Password"), gridBagConstraints, 0);
        gridBagConstraints.fill = 2;
        UIUtil.jGridBagAdd(jPanel, this.jPasswordField, gridBagConstraints, 0);
        gridBagConstraints.fill = 0;
        IconWrapperPanel iconWrapperPanel = new IconWrapperPanel(new ResourceIcon(PasswordAuthenticationDialog.class, KEY_ICON), jPanel);
        iconWrapperPanel.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        gridBagConstraints.weighty = 1.0;
        UIUtil.jGridBagAdd(jPanel2, this.jButtonOK, gridBagConstraints, -1);
        UIUtil.jGridBagAdd(jPanel2, this.jButtonCancel, gridBagConstraints, 0);
        JPanel jPanel3 = new JPanel(new FlowLayout(2, 0, 0));
        jPanel3.add(jPanel2);
        JPanel jPanel4 = new JPanel(new BorderLayout());
        jPanel4.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        jPanel4.add((Component)iconWrapperPanel, "Center");
        jPanel4.add((Component)jPanel3, "South");
        this.getContentPane().add(jPanel4);
        this.jPasswordField.grabFocus();
    }
}

