/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.common.hosts;

import com.sshtools.j2ssh.transport.AbstractKnownHostsKeyVerification;
import com.sshtools.j2ssh.transport.InvalidHostFileException;
import com.sshtools.j2ssh.transport.TransportProtocolException;
import com.sshtools.j2ssh.transport.publickey.SshPublicKey;
import java.awt.Component;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

public class DialogKnownHostsKeyVerification
extends AbstractKnownHostsKeyVerification {
    Component parent;
    private boolean verificationEnabled = true;

    public DialogKnownHostsKeyVerification(Component component) throws InvalidHostFileException {
        super(new File(System.getProperty("user.home"), ".ssh" + File.separator + "known_hosts").getAbsolutePath());
        this.parent = component;
    }

    public DialogKnownHostsKeyVerification(Component component, String string) throws InvalidHostFileException {
        super(string);
        this.parent = component;
    }

    public void setVerificationEnabled(boolean bl) {
        this.verificationEnabled = this.verificationEnabled;
    }

    public void onDeniedHost(final String string) throws TransportProtocolException {
        try {
            if (this.verificationEnabled) {
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        JOptionPane.showMessageDialog(DialogKnownHostsKeyVerification.this.parent, "Access to '" + string + "' is denied.\n" + "Verify the access granted/denied in the allowed hosts file.", "Remote Host Authentication", 0);
                    }
                });
            }
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new TransportProtocolException("Invocation Exception: " + invocationTargetException.getMessage());
        }
        catch (InterruptedException interruptedException) {
            throw new TransportProtocolException("SwingUtilities thread interrupted!");
        }
    }

    public void onHostKeyMismatch(final String string, final SshPublicKey sshPublicKey, final SshPublicKey sshPublicKey2) throws TransportProtocolException {
        try {
            if (this.verificationEnabled) {
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        Object[] objectArray = DialogKnownHostsKeyVerification.this.getOptions();
                        int n = JOptionPane.showOptionDialog(DialogKnownHostsKeyVerification.this.parent, "The host '" + string + "' has provided a different host key.\nThe host key" + " fingerprint provided is '" + sshPublicKey2.getFingerprint() + "'.\n" + "The allowed host key fingerprint is " + sshPublicKey.getFingerprint() + ".\nDo you want to allow this host?", "Remote host authentication", 1, 3, null, objectArray, objectArray[0]);
                        try {
                            if (objectArray.length == 3 && n == 0) {
                                DialogKnownHostsKeyVerification.this.allowHost(string, sshPublicKey2, true);
                            } else if (objectArray.length == 2 && n == 0 || objectArray.length == 3 && n == 1) {
                                DialogKnownHostsKeyVerification.this.allowHost(string, sshPublicKey2, false);
                            }
                        }
                        catch (InvalidHostFileException invalidHostFileException) {
                            DialogKnownHostsKeyVerification.this.showExceptionMessage((Exception)((Object)invalidHostFileException));
                        }
                    }
                });
            }
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new TransportProtocolException("Invocation Exception: " + invocationTargetException.getMessage());
        }
        catch (InterruptedException interruptedException) {
            throw new TransportProtocolException("SwingUtilities thread interrupted!");
        }
    }

    public void onUnknownHost(final String string, final SshPublicKey sshPublicKey) throws TransportProtocolException {
        try {
            if (this.verificationEnabled) {
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        Object[] objectArray = DialogKnownHostsKeyVerification.this.getOptions();
                        int n = JOptionPane.showOptionDialog(DialogKnownHostsKeyVerification.this.parent, "The host '" + string + "' is unknown. The host key" + " fingerprint is\n'" + sshPublicKey.getFingerprint() + "'.\nDo you want to allow this host?", "Remote host authentication", 1, 3, null, objectArray, objectArray[0]);
                        try {
                            if (objectArray.length == 3 && n == 0) {
                                DialogKnownHostsKeyVerification.this.allowHost(string, sshPublicKey, true);
                            } else if (objectArray.length == 2 && n == 0 || objectArray.length == 3 && n == 1) {
                                DialogKnownHostsKeyVerification.this.allowHost(string, sshPublicKey, false);
                            }
                        }
                        catch (InvalidHostFileException invalidHostFileException) {
                            DialogKnownHostsKeyVerification.this.showExceptionMessage((Exception)((Object)invalidHostFileException));
                        }
                    }
                });
            }
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new TransportProtocolException("Invocation Exception: " + invocationTargetException.getMessage());
        }
        catch (InterruptedException interruptedException) {
            throw new TransportProtocolException("SwingUtilities thread interrupted!");
        }
    }

    private String[] getOptions() {
        String[] stringArray;
        if (this.isHostFileWriteable()) {
            String[] stringArray2 = new String[3];
            stringArray2[0] = "Always";
            stringArray2[1] = "Yes";
            stringArray = stringArray2;
            stringArray2[2] = "No";
        } else {
            String[] stringArray3 = new String[2];
            stringArray3[0] = "Yes";
            stringArray = stringArray3;
            stringArray3[1] = "No";
        }
        return stringArray;
    }

    private void showExceptionMessage(Exception exception) {
        JOptionPane.showMessageDialog(this.parent, "An unexpected error occured!\n\n" + exception.getMessage(), "Host Verification", 0);
    }
}

