/*
 * Decompiled with CFR 0.152.
 */
package org.htmlparser;

import java.io.Serializable;
import org.htmlparser.PrototypicalNodeFactory;
import org.htmlparser.Text;
import org.htmlparser.lexer.Page;
import org.htmlparser.nodeDecorators.DecodingNode;
import org.htmlparser.nodeDecorators.EscapeCharacterRemovingNode;
import org.htmlparser.nodeDecorators.NonBreakingSpaceConvertingNode;

public class StringNodeFactory
extends PrototypicalNodeFactory
implements Serializable {
    protected boolean mDecode = false;
    protected boolean mRemoveEscapes = false;
    protected boolean mConvertNonBreakingSpaces = false;

    @Override
    public Text createStringNode(Page page, int n, int n2) {
        Text text = super.createStringNode(page, n, n2);
        if (this.getDecode()) {
            text = new DecodingNode(text);
        }
        if (this.getRemoveEscapes()) {
            text = new EscapeCharacterRemovingNode(text);
        }
        if (this.getConvertNonBreakingSpaces()) {
            text = new NonBreakingSpaceConvertingNode(text);
        }
        return text;
    }

    public void setDecode(boolean bl) {
        this.mDecode = bl;
    }

    public boolean getDecode() {
        return this.mDecode;
    }

    public void setRemoveEscapes(boolean bl) {
        this.mRemoveEscapes = bl;
    }

    public boolean getRemoveEscapes() {
        return this.mRemoveEscapes;
    }

    public void setConvertNonBreakingSpaces(boolean bl) {
        this.mConvertNonBreakingSpaces = bl;
    }

    public boolean getConvertNonBreakingSpaces() {
        return this.mConvertNonBreakingSpaces;
    }
}

