/*
 * Decompiled with CFR 0.152.
 */
package org.htmlparser.filters;

import java.util.Locale;
import org.htmlparser.Node;
import org.htmlparser.NodeFilter;
import org.htmlparser.Text;
import org.htmlparser.filters.NodeClassFilter;

public class StringFilter
implements NodeFilter {
    protected String mPattern;
    protected String mUpperPattern;
    protected boolean mCaseSensitive;
    protected Locale mLocale;

    public StringFilter() {
        this("", false);
    }

    public StringFilter(String string) {
        this(string, false);
    }

    public StringFilter(String string, boolean bl) {
        this(string, bl, null);
    }

    public StringFilter(String string, boolean bl, Locale locale) {
        this.mPattern = string;
        this.mCaseSensitive = bl;
        this.mLocale = null == locale ? Locale.getDefault() : locale;
        this.setUpperPattern();
    }

    protected void setUpperPattern() {
        block3: {
            block2: {
                if (!this.getCaseSensitive()) break block2;
                this.mUpperPattern = this.getPattern();
                if (!NodeClassFilter.b) break block3;
            }
            this.mUpperPattern = this.getPattern().toUpperCase(this.getLocale());
        }
    }

    public boolean getCaseSensitive() {
        return this.mCaseSensitive;
    }

    public void setCaseSensitive(boolean bl) {
        this.mCaseSensitive = bl;
        this.setUpperPattern();
    }

    public Locale getLocale() {
        return this.mLocale;
    }

    public void setLocale(Locale locale) {
        this.mLocale = locale;
        this.setUpperPattern();
    }

    public String getPattern() {
        return this.mPattern;
    }

    public void setPattern(String string) {
        this.mPattern = string;
        this.setUpperPattern();
    }

    @Override
    public boolean accept(Node node) {
        boolean bl = false;
        if (node instanceof Text) {
            String string = ((Text)node).getText();
            if (!this.getCaseSensitive()) {
                string = string.toUpperCase(this.getLocale());
            }
            bl = -1 != string.indexOf(this.mUpperPattern);
        }
        return bl;
    }
}

