/*
 * Decompiled with CFR 0.152.
 */
package org.htmlparser.lexerapplications.thumbelina;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Enumeration;
import java.util.HashSet;
import javax.swing.JPanel;
import javax.swing.JViewport;
import javax.swing.Scrollable;
import javax.swing.border.BevelBorder;
import org.htmlparser.lexerapplications.thumbelina.Picture;
import org.htmlparser.lexerapplications.thumbelina.Thumbelina;
import org.htmlparser.lexerapplications.thumbelina.TileSet;

public class PicturePanel
extends JPanel
implements MouseListener,
Scrollable,
ComponentListener,
HierarchyListener {
    protected static final int UNIT_INCREMENT = 10;
    protected static final int BLOCK_INCREMENT = 100;
    protected Thumbelina mThumbelina;
    protected TileSet mMosaic;
    protected Dimension mPreferredSize;

    public PicturePanel(Thumbelina thumbelina) {
        this.mThumbelina = thumbelina;
        this.mMosaic = new TileSet();
        this.mPreferredSize = null;
        this.setBorder(new BevelBorder(1));
        this.addMouseListener(this);
        this.addHierarchyListener(this);
    }

    public void reset() {
        this.mMosaic = new TileSet();
        this.repaint();
    }

    public void bringToTop(Picture picture) {
        picture.reset();
        this.mMosaic.bringToTop(picture);
        this.repaint(picture.x, picture.y, picture.width, picture.height);
        this.mThumbelina.mUrlText.setText(picture.getURL().toExternalForm());
    }

    public Picture find(String string) {
        boolean bl = Thumbelina.d;
        Picture picture = null;
        Enumeration enumeration = this.mMosaic.getPictures();
        while (null == picture && enumeration.hasMoreElements()) {
            Picture picture2 = (Picture)enumeration.nextElement();
            if (!string.equals(picture2.getURL().toExternalForm())) continue;
            picture = picture2;
            if (!bl) continue;
        }
        return picture;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void draw(Picture picture, boolean bl) {
        boolean bl2;
        block19: {
            boolean bl3 = Thumbelina.d;
            Container container = this.getParent();
            bl2 = false;
            TileSet tileSet = this.mMosaic;
            synchronized (tileSet) {
                block14: {
                    Dimension dimension;
                    block18: {
                        Dimension dimension2;
                        block17: {
                            block16: {
                                block15: {
                                    if (!(container instanceof JViewport)) break block14;
                                    dimension2 = this.getPreferredSize();
                                    this.mMosaic.add(picture);
                                    dimension = this.calculatePreferredSize();
                                    if (dimension.width <= dimension2.width) break block15;
                                    bl2 = true;
                                    if (!bl3) break block16;
                                }
                                dimension.width = dimension2.width;
                            }
                            if (dimension.height <= dimension2.height) break block17;
                            bl2 = true;
                            if (!bl3) break block18;
                        }
                        dimension.height = dimension2.height;
                    }
                    if (!bl2) break block19;
                    this.mPreferredSize = dimension;
                    if (!bl3) break block19;
                }
                this.mMosaic.add(picture);
            }
        }
        if (bl2) {
            this.revalidate();
        }
        this.repaint(picture.x, picture.y, picture.width, picture.height);
        if (bl) {
            this.mThumbelina.addHistory(picture.getURL().toExternalForm());
        }
    }

    @Override
    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void adjustClipForInsets(Graphics graphics) {
        Dimension dimension = this.getSize();
        Insets insets = this.getInsets();
        Rectangle rectangle = graphics.getClipBounds();
        if (rectangle.x < insets.left) {
            rectangle.x = insets.left;
        }
        if (rectangle.y < insets.top) {
            rectangle.y = insets.top;
        }
        if (rectangle.x + rectangle.width > dimension.width - insets.right) {
            rectangle.width = dimension.width - insets.right - rectangle.x;
        }
        if (rectangle.y + rectangle.height > dimension.height - insets.bottom) {
            rectangle.height = dimension.height - insets.bottom - rectangle.y;
        }
        graphics.setClip(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paint(Graphics graphics) {
        block7: {
            boolean bl = Thumbelina.d;
            this.adjustClipForInsets(graphics);
            Rectangle rectangle = graphics.getClipBounds();
            TileSet tileSet = this.mMosaic;
            synchronized (tileSet) {
                block6: {
                    if (0 != this.mMosaic.getSize()) break block6;
                    super.paint(graphics);
                    if (!bl) break block7;
                }
                super.paint(graphics);
                Enumeration enumeration = this.mMosaic.getPictures();
                HashSet<Image> hashSet = new HashSet<Image>();
                while (enumeration.hasMoreElements()) {
                    Image image;
                    Picture picture = (Picture)enumeration.nextElement();
                    if (null != rectangle && !rectangle.intersects(picture) || hashSet.contains(image = picture.getImage())) continue;
                    Point point = picture.getOrigin();
                    int n = image.getWidth(this);
                    int n2 = image.getHeight(this);
                    graphics.drawImage(picture.getImage(), point.x, point.y, point.x + n, point.y + n2, 0, 0, n, n2, this);
                    hashSet.add(image);
                    if (!bl) continue;
                }
            }
        }
    }

    @Override
    public Dimension getPreferredSize() {
        block5: {
            block4: {
                if (null != this.mPreferredSize) break block4;
                this.setPreferredSize(this.calculatePreferredSize());
                if (!Thumbelina.d) break block5;
            }
            if (0 == this.mPreferredSize.width || 0 == this.mPreferredSize.height) {
                this.setPreferredSize(this.calculatePreferredSize());
            }
        }
        return this.mPreferredSize;
    }

    @Override
    public void setPreferredSize(Dimension dimension) {
        this.mPreferredSize = dimension;
    }

    protected Dimension calculatePreferredSize() {
        Dimension dimension;
        block8: {
            Insets insets;
            block7: {
                Container container;
                boolean bl = Thumbelina.d;
                Enumeration enumeration = this.mMosaic.getPictures();
                int n = 0;
                int n2 = 0;
                Picture picture = null;
                while (enumeration.hasMoreElements()) {
                    picture = (Picture)enumeration.nextElement();
                    if (picture.x + picture.width > n) {
                        n = picture.x + picture.width;
                    }
                    if (picture.y + picture.height <= n2) continue;
                    n2 = picture.y + picture.height;
                    if (!bl) continue;
                }
                if (!((container = this.getParent()) instanceof JViewport)) break block7;
                dimension = container.getSize();
                insets = ((JViewport)container).getInsets();
                dimension.width -= insets.left + insets.right;
                dimension.height -= insets.top + insets.bottom;
                if (0 != dimension.width || 0 != dimension.height) {
                    dimension.width -= 2;
                }
                if (dimension.width < n) {
                    dimension.width = n;
                }
                if (dimension.height >= n2) break block8;
                dimension.height = n2;
                if (!bl) break block8;
            }
            insets = this.getInsets();
            dimension = new Dimension(n += insets.left + insets.right, n2 += insets.top + insets.bottom);
        }
        return dimension;
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        Picture picture;
        if (!mouseEvent.isMetaDown() && null != (picture = this.mMosaic.pictureAt(mouseEvent.getX(), mouseEvent.getY()))) {
            this.bringToTop(picture);
        }
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle rectangle, int n, int n2) {
        return 10;
    }

    @Override
    public int getScrollableBlockIncrement(Rectangle rectangle, int n, int n2) {
        return 100;
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        return false;
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        return false;
    }

    @Override
    public void componentResized(ComponentEvent componentEvent) {
        this.setPreferredSize(null);
    }

    @Override
    public void componentMoved(ComponentEvent componentEvent) {
    }

    @Override
    public void componentShown(ComponentEvent componentEvent) {
    }

    @Override
    public void componentHidden(ComponentEvent componentEvent) {
    }

    @Override
    public void hierarchyChanged(HierarchyEvent hierarchyEvent) {
        if (0L != (hierarchyEvent.getChangeFlags() & 1L)) {
            Component component = hierarchyEvent.getChanged();
            Container container = this.getParent();
            if (null != container && container.getParent() == component) {
                component.addComponentListener(this);
            }
        }
    }
}

