/*
 * Decompiled with CFR 0.152.
 */
package com.toedter.calendar;

import com.toedter.calendar.IDateEvaluator;
import com.toedter.calendar.MinMaxDateEvaluator;
import com.toedter.calendar.e;
import com.toedter.calendar.f;
import com.toedter.components.GenericBeanInfo;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.text.DateFormatSymbols;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.UIManager;

public class JDayChooser
extends JPanel
implements ActionListener,
KeyListener,
FocusListener {
    private static final long serialVersionUID = 5876398337018781820L;
    protected JButton[] days;
    protected JButton[] weeks;
    protected JButton selectedDay;
    protected JPanel weekPanel;
    protected JPanel dayPanel;
    protected int day;
    protected Color oldDayBackgroundColor;
    protected Color selectedColor;
    protected Color sundayForeground;
    protected Color weekdayForeground;
    protected Color decorationBackgroundColor;
    protected String[] dayNames;
    protected Calendar calendar;
    protected Calendar today;
    protected Locale locale;
    protected boolean initialized;
    protected boolean weekOfYearVisible;
    protected boolean decorationBackgroundVisible;
    protected boolean decorationBordersVisible;
    protected boolean dayBordersVisible;
    private boolean a;
    protected int maxDayCharacters;
    protected List dateEvaluators;
    protected MinMaxDateEvaluator minMaxDateEvaluator;
    public static boolean b;
    private static final String[] c;

    public JDayChooser() {
        this(false);
    }

    public JDayChooser(boolean bl) {
        int n;
        boolean bl2 = b;
        this.decorationBackgroundVisible = true;
        this.setName(c[4]);
        this.setBackground(Color.blue);
        this.dateEvaluators = new ArrayList(1);
        this.minMaxDateEvaluator = new MinMaxDateEvaluator();
        this.addDateEvaluator(this.minMaxDateEvaluator);
        this.weekOfYearVisible = bl;
        this.locale = Locale.getDefault();
        this.days = new JButton[49];
        this.selectedDay = null;
        this.calendar = Calendar.getInstance(this.locale);
        this.today = (Calendar)this.calendar.clone();
        this.setLayout(new BorderLayout());
        this.dayPanel = new JPanel();
        this.dayPanel.setLayout(new GridLayout(7, 7));
        this.sundayForeground = new Color(164, 0, 0);
        this.weekdayForeground = new Color(0, 90, 164);
        this.decorationBackgroundColor = new Color(210, 228, 238);
        for (n = 0; n < 7; ++n) {
            for (int i = 0; i < 7; ++i) {
                int n2;
                block10: {
                    block9: {
                        n2 = i + 7 * n;
                        if (n != 0) break block9;
                        this.days[n2] = new f(this);
                        if (!bl2) break block10;
                    }
                    this.days[n2] = new e(this, "x");
                    this.days[n2].addActionListener(this);
                    this.days[n2].addKeyListener(this);
                    this.days[n2].addFocusListener(this);
                }
                this.days[n2].setMargin(new Insets(0, 0, 0, 0));
                this.days[n2].setFocusPainted(false);
                this.dayPanel.add(this.days[n2]);
                if (!bl2) continue;
            }
            if (!bl2) continue;
        }
        this.weekPanel = new JPanel();
        this.weekPanel.setLayout(new GridLayout(7, 1));
        this.weeks = new JButton[7];
        for (n = 0; n < 7; ++n) {
            this.weeks[n] = new f(this);
            this.weeks[n].setMargin(new Insets(0, 0, 0, 0));
            this.weeks[n].setFocusPainted(false);
            this.weeks[n].setForeground(new Color(100, 100, 100));
            if (n != 0) {
                this.weeks[n].setText("0" + (n + 1));
            }
            this.weekPanel.add(this.weeks[n]);
            if (!bl2) continue;
        }
        this.init();
        this.setDay(Calendar.getInstance().get(5));
        this.add((Component)this.dayPanel, c[6]);
        if (bl) {
            this.add((Component)this.weekPanel, c[5]);
        }
        this.initialized = true;
        this.updateUI();
        if (GenericBeanInfo.b) {
            b = !bl2;
        }
    }

    protected void init() {
        JButton jButton = new JButton();
        this.oldDayBackgroundColor = jButton.getBackground();
        this.selectedColor = new Color(160, 160, 160);
        Date date = this.calendar.getTime();
        this.calendar = Calendar.getInstance(this.locale);
        this.calendar.setTime(date);
        this.a();
        this.drawDays();
    }

    private void a() {
        boolean bl = b;
        int n = this.calendar.getFirstDayOfWeek();
        DateFormatSymbols dateFormatSymbols = new DateFormatSymbols(this.locale);
        this.dayNames = dateFormatSymbols.getShortWeekdays();
        int n2 = n;
        for (int i = 0; i < 7; ++i) {
            block7: {
                block6: {
                    if (this.maxDayCharacters > 0 && this.maxDayCharacters < 5 && this.dayNames[n2].length() >= this.maxDayCharacters) {
                        this.dayNames[n2] = this.dayNames[n2].substring(0, this.maxDayCharacters);
                    }
                    this.days[i].setText(this.dayNames[n2]);
                    if (n2 != 1) break block6;
                    this.days[i].setForeground(this.sundayForeground);
                    if (!bl) break block7;
                }
                this.days[i].setForeground(this.weekdayForeground);
            }
            if (n2 < 7) {
                ++n2;
                if (!bl) continue;
            }
            n2 -= 6;
            if (!bl) continue;
        }
    }

    protected void initDecorations() {
        boolean bl = b;
        for (int i = 0; i < 7; ++i) {
            this.days[i].setContentAreaFilled(this.decorationBackgroundVisible);
            this.days[i].setBorderPainted(this.decorationBordersVisible);
            this.days[i].invalidate();
            this.days[i].repaint();
            this.weeks[i].setContentAreaFilled(this.decorationBackgroundVisible);
            this.weeks[i].setBorderPainted(this.decorationBordersVisible);
            this.weeks[i].invalidate();
            this.weeks[i].repaint();
            if (!bl) continue;
        }
    }

    protected void drawWeeks() {
        boolean bl = b;
        Calendar calendar = (Calendar)this.calendar.clone();
        for (int i = 1; i < 7; ++i) {
            calendar.set(5, i * 7 - 6);
            int n = calendar.get(3);
            String string = Integer.toString(n);
            if (n < 10) {
                string = "0" + string;
            }
            this.weeks[i].setText(string);
            if (i != 5 && i != 6) continue;
            this.weeks[i].setVisible(this.days[i * 7].isVisible());
            if (!bl) continue;
        }
    }

    protected void drawDays() {
        int n;
        boolean bl = b;
        Calendar calendar = (Calendar)this.calendar.clone();
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        int n2 = calendar.getFirstDayOfWeek();
        calendar.set(5, 1);
        int n3 = calendar.get(7) - n2;
        if (n3 < 0) {
            n3 += 7;
        }
        for (n = 0; n < n3; ++n) {
            this.days[n + 7].setVisible(false);
            this.days[n + 7].setText("");
            if (!bl) continue;
        }
        calendar.add(2, 1);
        Date date = calendar.getTime();
        calendar.add(2, -1);
        Date date2 = calendar.getTime();
        int n4 = 0;
        Color color = this.getForeground();
        while (date2.before(date)) {
            block16: {
                block15: {
                    block14: {
                        block13: {
                            this.days[n + n4 + 7].setText(Integer.toString(n4 + 1));
                            this.days[n + n4 + 7].setVisible(true);
                            if (calendar.get(6) != this.today.get(6) || calendar.get(1) != this.today.get(1)) break block13;
                            this.days[n + n4 + 7].setForeground(this.sundayForeground);
                            if (!bl) break block14;
                        }
                        this.days[n + n4 + 7].setForeground(color);
                    }
                    if (n4 + 1 != this.day) break block15;
                    this.days[n + n4 + 7].setBackground(this.selectedColor);
                    this.selectedDay = this.days[n + n4 + 7];
                    if (!bl) break block16;
                }
                this.days[n + n4 + 7].setBackground(this.oldDayBackgroundColor);
            }
            Iterator iterator = this.dateEvaluators.iterator();
            this.days[n + n4 + 7].setEnabled(true);
            while (iterator.hasNext()) {
                IDateEvaluator iDateEvaluator = (IDateEvaluator)iterator.next();
                if (iDateEvaluator.isSpecial(date2)) {
                    this.days[n + n4 + 7].setForeground(iDateEvaluator.getSpecialForegroundColor());
                    this.days[n + n4 + 7].setBackground(iDateEvaluator.getSpecialBackroundColor());
                    this.days[n + n4 + 7].setToolTipText(iDateEvaluator.getSpecialTooltip());
                    this.days[n + n4 + 7].setEnabled(true);
                }
                if (iDateEvaluator.isInvalid(date2)) {
                    this.days[n + n4 + 7].setForeground(iDateEvaluator.getInvalidForegroundColor());
                    this.days[n + n4 + 7].setBackground(iDateEvaluator.getInvalidBackroundColor());
                    this.days[n + n4 + 7].setToolTipText(iDateEvaluator.getInvalidTooltip());
                    this.days[n + n4 + 7].setEnabled(false);
                }
                if (!bl) continue;
            }
            ++n4;
            calendar.add(5, 1);
            date2 = calendar.getTime();
            if (!bl) continue;
        }
        for (int i = n4 + n + 7; i < 49; ++i) {
            this.days[i].setVisible(false);
            this.days[i].setText("");
            if (!bl) continue;
        }
        this.drawWeeks();
    }

    @Override
    public Locale getLocale() {
        return this.locale;
    }

    @Override
    public void setLocale(Locale locale) {
        block3: {
            block2: {
                if (this.initialized) break block2;
                super.setLocale(locale);
                if (!b) break block3;
            }
            this.locale = locale;
            super.setLocale(locale);
            this.init();
        }
    }

    public void setDay(int n) {
        block8: {
            int n2;
            block7: {
                boolean bl = b;
                if (n < 1) {
                    n = 1;
                }
                Calendar calendar = (Calendar)this.calendar.clone();
                calendar.set(5, 1);
                calendar.add(2, 1);
                calendar.add(5, -1);
                int n3 = calendar.get(5);
                if (n > n3) {
                    n = n3;
                }
                n2 = this.day;
                this.day = n;
                if (this.selectedDay != null) {
                    this.selectedDay.setBackground(this.oldDayBackgroundColor);
                    this.selectedDay.repaint();
                }
                for (int i = 7; i < 49; ++i) {
                    if (!this.days[i].getText().equals(Integer.toString(this.day))) continue;
                    this.selectedDay = this.days[i];
                    this.selectedDay.setBackground(this.selectedColor);
                    if (!bl) break;
                    if (!bl) continue;
                }
                if (!this.a) break block7;
                this.firePropertyChange(c[2], 0, this.day);
                if (!bl) break block8;
            }
            this.firePropertyChange(c[3], n2, this.day);
        }
    }

    public void setAlwaysFireDayProperty(boolean bl) {
        this.a = bl;
    }

    public int getDay() {
        return this.day;
    }

    public void setMonth(int n) {
        this.calendar.set(2, n);
        int n2 = this.calendar.getActualMaximum(5);
        if (this.day > n2) {
            this.day = n2;
        }
        this.drawDays();
    }

    public void setYear(int n) {
        this.calendar.set(1, n);
        this.drawDays();
    }

    public void setCalendar(Calendar calendar) {
        this.calendar = calendar;
        this.drawDays();
    }

    @Override
    public void setFont(Font font) {
        int n;
        boolean bl = b;
        if (this.days != null) {
            for (n = 0; n < 49; ++n) {
                this.days[n].setFont(font);
                if (!bl) continue;
            }
        }
        if (this.weeks != null) {
            for (n = 0; n < 7; ++n) {
                this.weeks[n].setFont(font);
                if (!bl) continue;
            }
        }
    }

    @Override
    public void setForeground(Color color) {
        boolean bl = b;
        super.setForeground(color);
        if (this.days != null) {
            for (int i = 7; i < 49; ++i) {
                this.days[i].setForeground(color);
                if (!bl) continue;
            }
            this.drawDays();
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        JButton jButton = (JButton)actionEvent.getSource();
        String string = jButton.getText();
        int n = new Integer(string);
        this.setDay(n);
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode() == 38 ? -7 : (keyEvent.getKeyCode() == 40 ? 7 : (keyEvent.getKeyCode() == 37 ? -1 : (keyEvent.getKeyCode() == 39 ? 1 : 0)));
        int n2 = this.getDay() + n;
        if (n2 >= 1 && n2 <= this.calendar.getMaximum(5)) {
            this.setDay(n2);
        }
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    @Override
    public void setEnabled(boolean bl) {
        int n;
        boolean bl2 = b;
        super.setEnabled(bl);
        for (n = 0; n < this.days.length; n = (int)((short)(n + 1))) {
            if (this.days[n] == null) continue;
            this.days[n].setEnabled(bl);
            if (!bl2) continue;
        }
        for (n = 0; n < this.weeks.length; n = (int)((short)(n + 1))) {
            if (this.weeks[n] == null) continue;
            this.weeks[n].setEnabled(bl);
            if (!bl2) continue;
        }
    }

    public boolean isWeekOfYearVisible() {
        return this.weekOfYearVisible;
    }

    public void setWeekOfYearVisible(boolean bl) {
        block5: {
            block4: {
                if (bl == this.weekOfYearVisible) {
                    return;
                }
                if (!bl) break block4;
                this.add((Component)this.weekPanel, c[0]);
                if (!b) break block5;
            }
            this.remove(this.weekPanel);
        }
        this.weekOfYearVisible = bl;
        this.validate();
        this.dayPanel.validate();
    }

    public JPanel getDayPanel() {
        return this.dayPanel;
    }

    public Color getDecorationBackgroundColor() {
        return this.decorationBackgroundColor;
    }

    public void setDecorationBackgroundColor(Color color) {
        int n;
        boolean bl = b;
        this.decorationBackgroundColor = color;
        if (this.days != null) {
            for (n = 0; n < 7; ++n) {
                this.days[n].setBackground(color);
                if (!bl) continue;
            }
        }
        if (this.weeks != null) {
            for (n = 0; n < 7; ++n) {
                this.weeks[n].setBackground(color);
                if (!bl) continue;
            }
        }
    }

    public Color getSundayForeground() {
        return this.sundayForeground;
    }

    public Color getWeekdayForeground() {
        return this.weekdayForeground;
    }

    public void setSundayForeground(Color color) {
        this.sundayForeground = color;
        this.a();
        this.drawDays();
    }

    public void setWeekdayForeground(Color color) {
        this.weekdayForeground = color;
        this.a();
        this.drawDays();
    }

    public void setFocus() {
        if (this.selectedDay != null) {
            this.selectedDay.requestFocus();
        }
    }

    public boolean isDecorationBackgroundVisible() {
        return this.decorationBackgroundVisible;
    }

    public void setDecorationBackgroundVisible(boolean bl) {
        this.decorationBackgroundVisible = bl;
        this.initDecorations();
    }

    public boolean isDecorationBordersVisible() {
        return this.decorationBordersVisible;
    }

    public boolean isDayBordersVisible() {
        return this.dayBordersVisible;
    }

    public void setDecorationBordersVisible(boolean bl) {
        this.decorationBordersVisible = bl;
        this.initDecorations();
    }

    public void setDayBordersVisible(boolean bl) {
        block3: {
            boolean bl2 = b;
            this.dayBordersVisible = bl;
            if (!this.initialized) break block3;
            for (int i = 7; i < 49; ++i) {
                block5: {
                    block4: {
                        if (!c[9].equals(UIManager.getLookAndFeel().getID())) break block4;
                        this.days[i].setContentAreaFilled(bl);
                        if (!bl2) break block5;
                    }
                    this.days[i].setContentAreaFilled(true);
                }
                this.days[i].setBorderPainted(bl);
                if (!bl2) continue;
            }
        }
    }

    @Override
    public void updateUI() {
        block4: {
            block5: {
                super.updateUI();
                this.setFont(Font.decode(c[7]));
                if (this.weekPanel != null) {
                    this.weekPanel.updateUI();
                }
                if (!this.initialized) break block4;
                if (!c[8].equals(UIManager.getLookAndFeel().getID())) break block5;
                this.setDayBordersVisible(false);
                this.setDecorationBackgroundVisible(true);
                this.setDecorationBordersVisible(false);
                if (!b) break block4;
            }
            this.setDayBordersVisible(true);
            this.setDecorationBackgroundVisible(this.decorationBackgroundVisible);
            this.setDecorationBordersVisible(this.decorationBordersVisible);
        }
    }

    public void setSelectableDateRange(Date date, Date date2) {
        this.minMaxDateEvaluator.setMaxSelectableDate(date2);
        this.minMaxDateEvaluator.setMinSelectableDate(date);
        this.drawDays();
    }

    public Date setMaxSelectableDate(Date date) {
        Date date2 = this.minMaxDateEvaluator.setMaxSelectableDate(date);
        this.drawDays();
        return date2;
    }

    public Date setMinSelectableDate(Date date) {
        Date date2 = this.minMaxDateEvaluator.setMinSelectableDate(date);
        this.drawDays();
        return date2;
    }

    public Date getMaxSelectableDate() {
        return this.minMaxDateEvaluator.getMaxSelectableDate();
    }

    public Date getMinSelectableDate() {
        return this.minMaxDateEvaluator.getMinSelectableDate();
    }

    public int getMaxDayCharacters() {
        return this.maxDayCharacters;
    }

    public void setMaxDayCharacters(int n) {
        block5: {
            block4: {
                if (n == this.maxDayCharacters) {
                    return;
                }
                if (n >= 0 && n <= 4) break block4;
                this.maxDayCharacters = 0;
                if (!b) break block5;
            }
            this.maxDayCharacters = n;
        }
        this.a();
        this.drawDays();
        this.invalidate();
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame(c[1]);
        jFrame.getContentPane().add(new JDayChooser());
        jFrame.pack();
        jFrame.setVisible(true);
    }

    public void addDateEvaluator(IDateEvaluator iDateEvaluator) {
        this.dateEvaluators.add(iDateEvaluator);
    }

    public void removeDateEvaluator(IDateEvaluator iDateEvaluator) {
        this.dateEvaluators.remove(iDateEvaluator);
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[10];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n = 0;
        String string2 = "\u0001NNc";
        int n2 = -1;
        block17: while (true) {
            char[] cArray;
            block22: {
                int n3;
                int n4;
                char[] cArray2;
                int n5;
                block21: {
                    char[] cArray3 = string2.toCharArray();
                    n5 = 0;
                    int n6 = cArray3.length;
                    cArray2 = cArray3;
                    n4 = n6;
                    if (n6 <= 1) break block21;
                    cArray = cArray2;
                    n3 = n4;
                    if (n4 <= n5) break block22;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n7 = n5;
                    while (true) {
                        int n8;
                        char c2 = cArray4[n7];
                        switch (n5 % 5) {
                            case 0: {
                                n8 = 86;
                                break;
                            }
                            case 1: {
                                n8 = 43;
                                break;
                            }
                            case 2: {
                                n8 = 61;
                                break;
                            }
                            case 3: {
                                n8 = 23;
                                break;
                            }
                            default: {
                                n8 = 56;
                            }
                        }
                        cArray4[n7] = (char)(c2 ^ n8);
                        ++n5;
                        cArray2 = cArray5;
                        n4 = n4;
                        if (n4 != 0) break;
                        cArray5 = cArray2;
                        n3 = n4;
                        n7 = n4;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n3 = n4;
                } while (n4 > n5);
            }
            string = new String(cArray);
            switch (n2) {
                default: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 1;
                    string2 = "\u001co\\n{>DRd]$";
                    n2 = 0;
                    continue block17;
                }
                case 0: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 2;
                    string2 = "2JD";
                    n2 = 1;
                    continue block17;
                }
                case 1: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 3;
                    string2 = "2JD";
                    n2 = 2;
                    continue block17;
                }
                case 2: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 4;
                    string2 = "\u001co\\n{>DRd]$";
                    n2 = 3;
                    continue block17;
                }
                case 3: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 5;
                    string2 = "\u0001NNc";
                    n2 = 4;
                    continue block17;
                }
                case 4: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 6;
                    string2 = "\u0015NSc]$";
                    n2 = 5;
                    continue block17;
                }
                case 5: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 7;
                    string2 = "\u0012B\\{W1\u000bm{Y?E\u001d&\t";
                    n2 = 6;
                    continue block17;
                }
                case 6: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 8;
                    string2 = "\u0001BSsW!X";
                    n2 = 7;
                    continue block17;
                }
                case 7: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 9;
                    string2 = "\u0001BSsW!X";
                    n2 = 8;
                    continue block17;
                }
                case 8: 
            }
            break;
        }
        stringArray2[n] = string.intern();
        c = stringArray3;
    }
}

