/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.image;

import java.awt.image.RGBImageFilter;

public class GrayFilter
extends RGBImageFilter {
    private int mLow;
    private float mRange;

    public GrayFilter() {
        this.canFilterIndexColorModel = true;
        this.mLow = 0;
        this.mRange = 1.0f;
    }

    public GrayFilter(float pLow, float pHigh) {
        this.canFilterIndexColorModel = true;
        this.mLow = 0;
        this.mRange = 1.0f;
        if (pLow > pHigh) {
            pLow = 0.0f;
        }
        if (pLow < 0.0f) {
            pLow = 0.0f;
        } else if (pLow > 1.0f) {
            pLow = 1.0f;
        }
        if (pHigh < 0.0f) {
            pHigh = 0.0f;
        } else if (pHigh > 1.0f) {
            pHigh = 1.0f;
        }
        this.mLow = (int)(pLow * 255.0f);
        this.mRange = pHigh - pLow;
    }

    public GrayFilter(int pLow, int pHigh) {
        this((float)pLow / 255.0f, (float)pHigh / 255.0f);
    }

    public int filterRGB(int pX, int pY, int pARGB) {
        int r = pARGB >> 16 & 0xFF;
        int g = pARGB >> 8 & 0xFF;
        int b = pARGB & 0xFF;
        int gray = (222 * r + 707 * g + 71 * b) / 1000;
        if (this.mRange != 1.0f) {
            gray = this.mLow + (int)((float)gray * this.mRange);
        }
        return pARGB & 0xFF000000 | gray << 16 | gray << 8 | gray;
    }
}

