/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.io;

import com.twelvemonkeys.io.FastByteArrayOutputStream;
import com.twelvemonkeys.io.FileSystem;
import com.twelvemonkeys.io.FilenameMaskFilter;
import com.twelvemonkeys.io.Win32File;
import com.twelvemonkeys.lang.StringUtil;
import com.twelvemonkeys.lang.Validate;
import com.twelvemonkeys.util.Visitor;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.URL;
import java.text.NumberFormat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FileUtil {
    public static final int BUF_SIZE = 1024;
    private static String TEMP_DIR = null;
    private static final FileSystem FS = FileSystem.get();
    private static ThreadLocal<NumberFormat> sNumberFormat = new ThreadLocal<NumberFormat>(){

        @Override
        protected NumberFormat initialValue() {
            NumberFormat format = NumberFormat.getNumberInstance();
            format.setMaximumFractionDigits(0);
            return format;
        }
    };

    public static void main(String[] pArgs) throws IOException {
        File file;
        if (pArgs[0].startsWith("file:")) {
            file = FileUtil.toFile(new URL(pArgs[0]));
            System.out.println(file);
        } else {
            file = new File(pArgs[0]);
            System.out.println(file.toURL());
        }
        System.out.println("Free space: " + FileUtil.getFreeSpace(file) + "/" + FileUtil.getTotalSpace(file) + " bytes");
    }

    public static void main0(String[] pArgs) {
        if (pArgs.length != 2) {
            System.out.println("usage: java Copy in out");
            return;
        }
        try {
            if (!FileUtil.copy(pArgs[0], pArgs[1])) {
                System.out.println("Error copying");
            }
        }
        catch (IOException e) {
            System.out.println(e.getMessage());
        }
    }

    private FileUtil() {
    }

    public static boolean copy(String pFromFileName, String pToFileName) throws IOException {
        return FileUtil.copy(new File(pFromFileName), new File(pToFileName), false);
    }

    public static boolean copy(String pFromFileName, String pToFileName, boolean pOverWrite) throws IOException {
        return FileUtil.copy(new File(pFromFileName), new File(pToFileName), pOverWrite);
    }

    public static boolean copy(File pFromFile, File pToFile) throws IOException {
        return FileUtil.copy(pFromFile, pToFile, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean copy(File pFromFile, File pToFile, boolean pOverWrite) throws IOException {
        if (pFromFile.isDirectory()) {
            return FileUtil.copyDir(pFromFile, pToFile, pOverWrite);
        }
        if (pToFile.isDirectory()) {
            pToFile = new File(pToFile, pFromFile.getName());
        }
        if (!pOverWrite && pToFile.exists()) {
            return false;
        }
        FileInputStream in = null;
        FileOutputStream out = null;
        try {
            in = new FileInputStream(pFromFile);
            out = new FileOutputStream(pToFile);
            FileUtil.copy(in, out);
        }
        catch (Throwable throwable) {
            FileUtil.close(in);
            FileUtil.close(out);
            throw throwable;
        }
        FileUtil.close(in);
        FileUtil.close(out);
        return true;
    }

    public static void close(InputStream pInput) {
        try {
            if (pInput != null) {
                pInput.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void close(OutputStream pOutput) {
        try {
            if (pOutput != null) {
                pOutput.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    static void close(Reader pReader) {
        try {
            if (pReader != null) {
                pReader.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    static void close(Writer pWriter) {
        try {
            if (pWriter != null) {
                pWriter.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static boolean copyDir(File pFrom, File pTo, boolean pOverWrite) throws IOException {
        File[] files;
        if (pTo.exists() && !pTo.isDirectory()) {
            throw new IOException("A directory may only be copied to another directory, not to a file");
        }
        pTo.mkdirs();
        boolean allOkay = true;
        for (File file : files = pFrom.listFiles()) {
            if (FileUtil.copy(file, new File(pTo, file.getName()), pOverWrite)) continue;
            allOkay = false;
        }
        return allOkay;
    }

    public static boolean copy(InputStream pFrom, OutputStream pTo) throws IOException {
        int count;
        Validate.notNull(pFrom, "from");
        Validate.notNull(pTo, "to");
        BufferedInputStream in = new BufferedInputStream(pFrom, 2048);
        BufferedOutputStream out = new BufferedOutputStream(pTo, 2048);
        byte[] buffer = new byte[1024];
        while ((count = ((InputStream)in).read(buffer)) != -1) {
            ((OutputStream)out).write(buffer, 0, count);
        }
        ((OutputStream)out).flush();
        return true;
    }

    public static String getExtension(String pFileName) {
        return FileUtil.getExtension0(FileUtil.getFilename(pFileName));
    }

    public static String getExtension(File pFile) {
        return FileUtil.getExtension0(pFile.getName());
    }

    private static String getExtension0(String pFileName) {
        int index = pFileName.lastIndexOf(46);
        if (index >= 0) {
            return pFileName.substring(index + 1);
        }
        return null;
    }

    public static String getBasename(String pFileName) {
        return FileUtil.getBasename0(FileUtil.getFilename(pFileName));
    }

    public static String getBasename(File pFile) {
        return FileUtil.getBasename0(pFile.getName());
    }

    public static String getBasename0(String pFileName) {
        int index = pFileName.lastIndexOf(46);
        if (index >= 0) {
            return pFileName.substring(0, index);
        }
        return pFileName;
    }

    public static String getDirectoryname(String pPath) {
        return FileUtil.getDirectoryname(pPath, File.separatorChar);
    }

    public static String getDirectoryname(String pPath, char pSeparator) {
        int index = pPath.lastIndexOf(pSeparator);
        if (index < 0) {
            return "";
        }
        return pPath.substring(0, index);
    }

    public static String getFilename(String pPath) {
        return FileUtil.getFilename(pPath, File.separatorChar);
    }

    public static String getFilename(String pPath, char pSeparator) {
        int index = pPath.lastIndexOf(pSeparator);
        if (index < 0) {
            return pPath;
        }
        return pPath.substring(index + 1);
    }

    public static boolean isEmpty(File pFile) {
        if (pFile.isDirectory()) {
            return pFile.list().length == 0;
        }
        return pFile.length() == 0L;
    }

    public static File getTempDirFile() {
        return new File(FileUtil.getTempDir());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getTempDir() {
        Class<FileUtil> clazz = FileUtil.class;
        synchronized (FileUtil.class) {
            if (TEMP_DIR == null) {
                String tmpDir = System.getProperty("java.io.tmpdir");
                if (StringUtil.isEmpty(tmpDir)) {
                    tmpDir = new File("/temp").exists() ? "/temp" : "/tmp";
                }
                TEMP_DIR = tmpDir;
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return TEMP_DIR;
        }
    }

    public static byte[] read(String pFilename) throws IOException {
        return FileUtil.read(new File(pFilename));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] read(File pFile) throws IOException {
        if (!pFile.exists()) {
            throw new FileNotFoundException(pFile.toString());
        }
        byte[] bytes = new byte[(int)pFile.length()];
        BufferedInputStream in = null;
        try {
            int len;
            in = new BufferedInputStream(new FileInputStream(pFile), 2048);
            for (int off = 0; (len = ((InputStream)in).read(bytes, off, ((InputStream)in).available())) != -1 && off < bytes.length; off += len) {
            }
        }
        catch (Throwable throwable) {
            FileUtil.close(in);
            throw throwable;
        }
        FileUtil.close(in);
        return bytes;
    }

    public static byte[] read(InputStream pInput) throws IOException {
        FastByteArrayOutputStream bytes = new FastByteArrayOutputStream(1024);
        FileUtil.copy(pInput, bytes);
        return ((ByteArrayOutputStream)bytes).toByteArray();
    }

    public static boolean write(OutputStream pOutput, byte[] pData) throws IOException {
        pOutput.write(pData);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean write(File pFile, byte[] pData) throws IOException {
        boolean success = false;
        BufferedOutputStream out = null;
        try {
            out = new BufferedOutputStream(new FileOutputStream(pFile));
            success = FileUtil.write(out, pData);
        }
        catch (Throwable throwable) {
            FileUtil.close(out);
            throw throwable;
        }
        FileUtil.close(out);
        return success;
    }

    public static boolean write(String pFilename, byte[] pData) throws IOException {
        return FileUtil.write(new File(pFilename), pData);
    }

    public static boolean delete(File pFile, boolean pForce) throws IOException {
        if (pForce && pFile.isDirectory()) {
            return FileUtil.deleteDir(pFile);
        }
        return pFile.exists() && pFile.delete();
    }

    private static boolean deleteDir(File pFile) throws IOException {
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class DeleteFilesVisitor
        implements Visitor<File> {
            private int mFailedCount = 0;
            private IOException mException = null;

            DeleteFilesVisitor() {
            }

            @Override
            public void visit(File pFile) {
                block3: {
                    try {
                        if (!FileUtil.delete(pFile, true)) {
                            ++this.mFailedCount;
                        }
                    }
                    catch (IOException e) {
                        ++this.mFailedCount;
                        if (this.mException != null) break block3;
                        this.mException = e;
                    }
                }
            }

            boolean succeeded() throws IOException {
                if (this.mException != null) {
                    throw this.mException;
                }
                return this.mFailedCount == 0;
            }
        }
        DeleteFilesVisitor fileDeleter = new DeleteFilesVisitor();
        FileUtil.visitFiles(pFile, null, fileDeleter);
        return fileDeleter.succeeded() && pFile.delete();
    }

    public static boolean delete(String pFilename, boolean pForce) throws IOException {
        return FileUtil.delete(new File(pFilename), pForce);
    }

    public static boolean delete(File pFile) throws IOException {
        return FileUtil.delete(pFile, false);
    }

    public static boolean delete(String pFilename) throws IOException {
        return FileUtil.delete(new File(pFilename), false);
    }

    public static boolean rename(File pFrom, File pTo, boolean pOverWrite) throws IOException {
        if (!pFrom.exists()) {
            throw new FileNotFoundException(pFrom.getAbsolutePath());
        }
        if (pFrom.isFile() && pTo.isDirectory()) {
            pTo = new File(pTo, pFrom.getName());
        }
        return (pOverWrite || !pTo.exists()) && pFrom.renameTo(pTo);
    }

    public static boolean rename(File pFrom, File pTo) throws IOException {
        return FileUtil.rename(pFrom, pTo, false);
    }

    public static boolean rename(File pFrom, String pTo, boolean pOverWrite) throws IOException {
        return FileUtil.rename(pFrom, new File(pTo), pOverWrite);
    }

    public static boolean rename(File pFrom, String pTo) throws IOException {
        return FileUtil.rename(pFrom, new File(pTo), false);
    }

    public static boolean rename(String pFrom, String pTo, boolean pOverWrite) throws IOException {
        return FileUtil.rename(new File(pFrom), new File(pTo), pOverWrite);
    }

    public static boolean rename(String pFrom, String pTo) throws IOException {
        return FileUtil.rename(new File(pFrom), new File(pTo), false);
    }

    public static File[] list(String pFolder) throws FileNotFoundException {
        return FileUtil.list(pFolder, null);
    }

    public static File[] list(String pFolder, String pFilenameMask) throws FileNotFoundException {
        if (StringUtil.isEmpty(pFolder)) {
            return null;
        }
        File folder = FileUtil.resolve(pFolder);
        if (!folder.isDirectory() || !folder.canRead()) {
            throw new FileNotFoundException("\"" + pFolder + "\" is not a directory or is not readable.");
        }
        if (StringUtil.isEmpty(pFilenameMask)) {
            return folder.listFiles();
        }
        FilenameMaskFilter filter = new FilenameMaskFilter(pFilenameMask);
        return folder.listFiles(filter);
    }

    public static File toFile(URL pURL) {
        if (pURL == null) {
            throw new NullPointerException("URL == null");
        }
        if (!"file".equals(pURL.getProtocol())) {
            throw new IllegalArgumentException("URL scheme is not \"file\"");
        }
        if (pURL.getAuthority() != null) {
            throw new IllegalArgumentException("URL has an authority component");
        }
        if (pURL.getRef() != null) {
            throw new IllegalArgumentException("URI has a fragment component");
        }
        if (pURL.getQuery() != null) {
            throw new IllegalArgumentException("URL has a query component");
        }
        String path = pURL.getPath();
        if (!path.startsWith("/")) {
            throw new IllegalArgumentException("URI is not hierarchical");
        }
        if (path.equals("")) {
            throw new IllegalArgumentException("URI path component is empty");
        }
        if (File.separatorChar != '/') {
            path = path.replace('/', File.separatorChar);
        }
        return FileUtil.resolve(path);
    }

    public static File resolve(String pPath) {
        return Win32File.wrap(new File(pPath));
    }

    public static File resolve(File pPath) {
        return Win32File.wrap(pPath);
    }

    public static File resolve(File pParent, String pChild) {
        return Win32File.wrap(new File(pParent, pChild));
    }

    public static File[] resolve(File[] pPaths) {
        return Win32File.wrap(pPaths);
    }

    public static long getFreeSpace(File pPath) {
        File path = pPath != null ? pPath : new File(".");
        Long space = FileUtil.getSpace16("getFreeSpace", path);
        if (space != null) {
            return space;
        }
        return FS.getFreeSpace(path);
    }

    public static long getUsableSpace(File pPath) {
        File path = pPath != null ? pPath : new File(".");
        Long space = FileUtil.getSpace16("getUsableSpace", path);
        if (space != null) {
            return space;
        }
        return FileUtil.getTotalSpace(path);
    }

    public static long getTotalSpace(File pPath) {
        File path = pPath != null ? pPath : new File(".");
        Long space = FileUtil.getSpace16("getTotalSpace", path);
        if (space != null) {
            return space;
        }
        return FS.getTotalSpace(path);
    }

    private static Long getSpace16(String pMethodName, File pPath) {
        try {
            Method freeSpace = File.class.getMethod(pMethodName, new Class[0]);
            return (Long)freeSpace.invoke((Object)pPath, new Object[0]);
        }
        catch (NoSuchMethodException ignore) {
        }
        catch (IllegalAccessException ignore) {
        }
        catch (InvocationTargetException e) {
            Throwable throwable = e.getTargetException();
            if (throwable instanceof SecurityException) {
                throw (SecurityException)throwable;
            }
            throw new UndeclaredThrowableException(throwable);
        }
        return null;
    }

    public static String toHumanReadableSize(long pSizeInBytes) {
        if (pSizeInBytes < 1024L) {
            return pSizeInBytes + " Bytes";
        }
        if (pSizeInBytes < 0x100000L) {
            return FileUtil.getSizeFormat().format((double)pSizeInBytes / 1024.0) + " KB";
        }
        if (pSizeInBytes < 0x40000000L) {
            return FileUtil.getSizeFormat().format((double)pSizeInBytes / 1048576.0) + " MB";
        }
        if (pSizeInBytes < 0x10000000000L) {
            return FileUtil.getSizeFormat().format((double)pSizeInBytes / 1.073741824E9) + " GB";
        }
        if (pSizeInBytes < 0x4000000000000L) {
            return FileUtil.getSizeFormat().format((double)pSizeInBytes / 1.099511627776E12) + " TB";
        }
        return FileUtil.getSizeFormat().format((double)pSizeInBytes / 1.125899906842624E15) + " PB";
    }

    private static NumberFormat getSizeFormat() {
        return sNumberFormat.get();
    }

    public static void visitFiles(File pDirectory, final FileFilter pFilter, final Visitor<File> pVisitor) {
        Validate.notNull(pDirectory, "directory");
        Validate.notNull(pVisitor, "visitor");
        pDirectory.listFiles(new FileFilter(){

            public boolean accept(File pFile) {
                if (pFilter == null || pFilter.accept(pFile)) {
                    pVisitor.visit(pFile);
                }
                return false;
            }
        });
    }
}

