/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.io;

import com.twelvemonkeys.util.regex.WildcardStringParser;
import java.io.File;
import java.io.FilenameFilter;

public class FilenameMaskFilter
implements FilenameFilter {
    private String[] mFilenameMasksForInclusion;
    private String[] mFilenameMasksForExclusion;
    private boolean mInclusion = true;

    public FilenameMaskFilter() {
    }

    public FilenameMaskFilter(String pFilenameMask) {
        String[] filenameMask = new String[]{pFilenameMask};
        this.setFilenameMasksForInclusion(filenameMask);
    }

    public FilenameMaskFilter(String[] pFilenameMasks) {
        this(pFilenameMasks, false);
    }

    public FilenameMaskFilter(String pFilenameMask, boolean pExclusion) {
        String[] filenameMask = new String[]{pFilenameMask};
        if (pExclusion) {
            this.setFilenameMasksForExclusion(filenameMask);
        } else {
            this.setFilenameMasksForInclusion(filenameMask);
        }
    }

    public FilenameMaskFilter(String[] pFilenameMasks, boolean pExclusion) {
        if (pExclusion) {
            this.setFilenameMasksForExclusion(pFilenameMasks);
        } else {
            this.setFilenameMasksForInclusion(pFilenameMasks);
        }
    }

    public void setFilenameMasksForInclusion(String[] pFilenameMasksForInclusion) {
        this.mFilenameMasksForInclusion = pFilenameMasksForInclusion;
    }

    public String[] getFilenameMasksForInclusion() {
        return (String[])this.mFilenameMasksForInclusion.clone();
    }

    public void setFilenameMasksForExclusion(String[] pFilenameMasksForExclusion) {
        this.mFilenameMasksForExclusion = pFilenameMasksForExclusion;
        this.mInclusion = false;
    }

    public String[] getFilenameMasksForExclusion() {
        return (String[])this.mFilenameMasksForExclusion.clone();
    }

    public boolean accept(File pDir, String pName) {
        if (this.mInclusion) {
            for (String mask : this.mFilenameMasksForInclusion) {
                WildcardStringParser parser = new WildcardStringParser(mask);
                if (!parser.parseString(pName)) continue;
                return true;
            }
            return false;
        }
        for (String mask : this.mFilenameMasksForExclusion) {
            WildcardStringParser parser = new WildcardStringParser(mask);
            if (!parser.parseString(pName)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuilder retVal = new StringBuilder();
        if (this.mInclusion) {
            if (this.mFilenameMasksForInclusion == null) {
                retVal.append("No filename masks set - property mFilenameMasksForInclusion is null!");
            } else {
                retVal.append(this.mFilenameMasksForInclusion.length);
                retVal.append(" filename mask(s) - ");
                for (int i = 0; i < this.mFilenameMasksForInclusion.length; ++i) {
                    retVal.append("\"");
                    retVal.append(this.mFilenameMasksForInclusion[i]);
                    retVal.append("\", \"");
                }
            }
        } else if (this.mFilenameMasksForExclusion == null) {
            retVal.append("No filename masks set - property mFilenameMasksForExclusion is null!");
        } else {
            retVal.append(this.mFilenameMasksForExclusion.length);
            retVal.append(" exclusion filename mask(s) - ");
            for (int i = 0; i < this.mFilenameMasksForExclusion.length; ++i) {
                retVal.append("\"");
                retVal.append(this.mFilenameMasksForExclusion[i]);
                retVal.append("\", \"");
            }
        }
        return retVal.toString();
    }
}

