/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.io;

import com.twelvemonkeys.io.Seekable;
import java.io.IOException;
import java.io.InputStream;
import java.util.Stack;

public abstract class SeekableInputStream
extends InputStream
implements Seekable {
    long mPosition;
    long mFlushedPosition;
    boolean mClosed;
    protected Stack<Long> mMarkedPositions = new Stack();

    public final int read(byte[] pBytes) throws IOException {
        return this.read(pBytes, 0, pBytes != null ? pBytes.length : 1);
    }

    public final long skip(long pLength) throws IOException {
        long pos = this.mPosition;
        if (pos + pLength < this.mFlushedPosition) {
            throw new IOException("position < flushedPosition");
        }
        this.seek(Math.min(pos + pLength, pos + (long)this.available()));
        return this.mPosition - pos;
    }

    public final void mark(int pLimit) {
        this.mark();
        try {
            this.flushBefore(Math.max(this.mPosition - (long)pLimit, this.mFlushedPosition));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public final boolean markSupported() {
        return true;
    }

    public final void seek(long pPosition) throws IOException {
        this.checkOpen();
        if (pPosition < this.mFlushedPosition) {
            throw new IndexOutOfBoundsException("position < flushedPosition");
        }
        this.seekImpl(pPosition);
        this.mPosition = pPosition;
    }

    protected abstract void seekImpl(long var1) throws IOException;

    public final void mark() {
        this.mMarkedPositions.push(this.mPosition);
    }

    public final void reset() throws IOException {
        this.checkOpen();
        if (!this.mMarkedPositions.isEmpty()) {
            long newPos = this.mMarkedPositions.pop();
            if (newPos < this.mFlushedPosition) {
                throw new IOException("Previous marked position has been discarded");
            }
            this.seek(newPos);
        } else {
            this.seek(0L);
        }
    }

    public final void flushBefore(long pPosition) throws IOException {
        if (pPosition < this.mFlushedPosition) {
            throw new IndexOutOfBoundsException("position < flushedPosition");
        }
        if (pPosition > this.getStreamPosition()) {
            throw new IndexOutOfBoundsException("position > stream position");
        }
        this.checkOpen();
        this.flushBeforeImpl(pPosition);
        this.mFlushedPosition = pPosition;
    }

    protected abstract void flushBeforeImpl(long var1) throws IOException;

    public final void flush() throws IOException {
        this.flushBefore(this.mFlushedPosition);
    }

    public final long getFlushedPosition() throws IOException {
        this.checkOpen();
        return this.mFlushedPosition;
    }

    public final long getStreamPosition() throws IOException {
        this.checkOpen();
        return this.mPosition;
    }

    protected final void checkOpen() throws IOException {
        if (this.mClosed) {
            throw new IOException("closed");
        }
    }

    public final void close() throws IOException {
        this.checkOpen();
        this.mClosed = true;
        this.closeImpl();
    }

    protected abstract void closeImpl() throws IOException;

    protected void finalize() throws Throwable {
        if (!this.mClosed) {
            try {
                this.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        super.finalize();
    }
}

