/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.io.enc;

import com.twelvemonkeys.io.enc.Decoder;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

abstract class AbstractRLEDecoder
implements Decoder {
    protected final byte[] mRow;
    protected final int mWidth;
    protected int mSrcX;
    protected int mSrcY;
    protected int mDstX;
    protected int mDstY;

    AbstractRLEDecoder(int pWidth, int pHeight) {
        int bytesPerRow = this.mWidth = pWidth;
        int mod = bytesPerRow % 4;
        if (mod != 0) {
            bytesPerRow += 4 - mod;
        }
        this.mRow = new byte[bytesPerRow];
        this.mSrcX = 0;
        this.mSrcY = pHeight - 1;
        this.mDstX = this.mSrcX;
        this.mDstY = this.mSrcY;
    }

    protected abstract void decodeRow(InputStream var1) throws IOException;

    public final int decode(InputStream pStream, byte[] pBuffer) throws IOException {
        int decoded = 0;
        while (decoded < pBuffer.length && this.mDstY >= 0) {
            if (this.mDstX == 0 && this.mSrcY == this.mDstY) {
                this.decodeRow(pStream);
            }
            int length = Math.min(this.mRow.length - this.mDstX, pBuffer.length - decoded);
            System.arraycopy(this.mRow, this.mDstX, pBuffer, decoded, length);
            this.mDstX += length;
            decoded += length;
            if (this.mDstX != this.mRow.length) continue;
            this.mDstX = 0;
            --this.mDstY;
            if (this.mDstY <= this.mSrcY) continue;
            for (int i = 0; i < this.mRow.length; ++i) {
                this.mRow[i] = 0;
            }
        }
        return decoded;
    }

    protected static int checkEOF(int pByte) throws EOFException {
        if (pByte < 0) {
            throw new EOFException("Premature end of file");
        }
        return pByte;
    }
}

