/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.io.enc;

import com.twelvemonkeys.io.enc.Encoder;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public final class EncoderStream
extends FilterOutputStream {
    protected final Encoder mEncoder;
    private final boolean mFlushOnWrite;
    protected int mBufferPos;
    protected final byte[] mBuffer;

    public EncoderStream(OutputStream pStream, Encoder pEncoder) {
        this(pStream, pEncoder, false);
    }

    public EncoderStream(OutputStream pStream, Encoder pEncoder, boolean pFlushOnWrite) {
        super(pStream);
        this.mEncoder = pEncoder;
        this.mFlushOnWrite = pFlushOnWrite;
        this.mBuffer = new byte[1024];
        this.mBufferPos = 0;
    }

    public void close() throws IOException {
        this.flush();
        super.close();
    }

    public void flush() throws IOException {
        this.encodeBuffer();
        super.flush();
    }

    private void encodeBuffer() throws IOException {
        if (this.mBufferPos != 0) {
            this.mEncoder.encode(this.out, this.mBuffer, 0, this.mBufferPos);
            this.mBufferPos = 0;
        }
    }

    public final void write(byte[] pBytes) throws IOException {
        this.write(pBytes, 0, pBytes.length);
    }

    public void write(byte[] pBytes, int pOffset, int pLength) throws IOException {
        if (!this.mFlushOnWrite && this.mBufferPos + pLength < this.mBuffer.length) {
            System.arraycopy(pBytes, pOffset, this.mBuffer, this.mBufferPos, pLength);
            this.mBufferPos += pLength;
        } else {
            if (this.mBufferPos != 0) {
                this.encodeBuffer();
            }
            this.mEncoder.encode(this.out, pBytes, pOffset, pLength);
        }
    }

    public void write(int pByte) throws IOException {
        if (this.mBufferPos >= this.mBuffer.length - 1) {
            this.encodeBuffer();
        }
        this.mBuffer[this.mBufferPos++] = (byte)pByte;
    }
}

