/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.io.ole2;

import com.twelvemonkeys.io.FileCacheSeekableStream;
import com.twelvemonkeys.io.FileUtil;
import com.twelvemonkeys.io.LittleEndianDataInputStream;
import com.twelvemonkeys.io.LittleEndianRandomAccessFile;
import com.twelvemonkeys.io.Seekable;
import com.twelvemonkeys.io.SeekableInputStream;
import com.twelvemonkeys.io.ole2.CorruptDocumentException;
import com.twelvemonkeys.io.ole2.Entry;
import com.twelvemonkeys.io.ole2.SIdChain;
import com.twelvemonkeys.lang.StringUtil;
import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.util.Arrays;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.UUID;
import javax.imageio.stream.ImageInputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CompoundDocument {
    private static final byte[] MAGIC = new byte[]{-48, -49, 17, -32, -95, -79, 26, -31};
    public static final int HEADER_SIZE = 512;
    private final DataInput mInput;
    private UUID mUID;
    private int mSectorSize;
    private int mShortSectorSize;
    private int mDirectorySId;
    private int mMinStreamSize;
    private int mShortSATSID;
    private int mShortSATSize;
    private int[] mMasterSAT;
    private int[] mSAT;
    private int[] mShortSAT;
    private Entry mRootEntry;
    private SIdChain mShortStreamSIdChain;
    private SIdChain mDirectorySIdChain;
    private static final int END_OF_CHAIN_SID = -2;
    private static final int FREE_SID = -1;
    public static final long EPOCH_OFFSET = -11644477200000L;

    public CompoundDocument(File pFile) throws IOException {
        this.mInput = new LittleEndianRandomAccessFile(FileUtil.resolve(pFile), "r");
        this.readHeader();
    }

    public CompoundDocument(InputStream pInput) throws IOException {
        this(new FileCacheSeekableStream(pInput));
    }

    CompoundDocument(SeekableInputStream pInput) throws IOException {
        this.mInput = new SeekableLittleEndianDataInputStream(pInput);
        this.readHeader();
    }

    public CompoundDocument(ImageInputStream pInput) throws IOException {
        this.mInput = pInput;
        this.readHeader();
    }

    public static boolean canRead(DataInput pInput) {
        return CompoundDocument.canRead(pInput, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean canRead(DataInput pInput, boolean pReset) {
        long pos;
        block26: {
            pos = -1L;
            if (pReset) {
                try {
                    if (pInput instanceof InputStream && ((InputStream)((Object)pInput)).markSupported()) {
                        ((InputStream)((Object)pInput)).mark(8);
                        break block26;
                    }
                    if (pInput instanceof ImageInputStream) {
                        ((ImageInputStream)pInput).mark();
                        break block26;
                    }
                    if (pInput instanceof RandomAccessFile) {
                        pos = ((RandomAccessFile)pInput).getFilePointer();
                        break block26;
                    }
                    if (pInput instanceof LittleEndianRandomAccessFile) {
                        pos = ((LittleEndianRandomAccessFile)pInput).getFilePointer();
                        break block26;
                    }
                    return false;
                }
                catch (IOException ignore) {
                    return false;
                }
            }
        }
        try {
            byte[] magic = new byte[8];
            pInput.readFully(magic);
            boolean bl = Arrays.equals(magic, MAGIC);
            return bl;
        }
        catch (IOException ignore) {
        }
        finally {
            if (pReset) {
                try {
                    if (pInput instanceof InputStream && ((InputStream)((Object)pInput)).markSupported()) {
                        ((InputStream)((Object)pInput)).reset();
                    } else if (pInput instanceof ImageInputStream) {
                        ((ImageInputStream)pInput).reset();
                    } else if (pInput instanceof RandomAccessFile) {
                        ((RandomAccessFile)pInput).seek(pos);
                    } else if (pInput instanceof LittleEndianRandomAccessFile) {
                        ((LittleEndianRandomAccessFile)pInput).seek(pos);
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return false;
    }

    private void readHeader() throws IOException {
        if (this.mMasterSAT != null) {
            return;
        }
        if (!CompoundDocument.canRead(this.mInput, false)) {
            throw new CorruptDocumentException("Not an OLE 2 Compound Document");
        }
        this.mUID = new UUID(this.mInput.readLong(), this.mInput.readLong());
        this.mInput.readUnsignedShort();
        this.mInput.readUnsignedShort();
        int byteOrder = this.mInput.readUnsignedShort();
        if (byteOrder != 65534) {
            throw new CorruptDocumentException("Cannot read big endian OLE 2 Compound Documents");
        }
        this.mSectorSize = 1 << this.mInput.readUnsignedShort();
        this.mShortSectorSize = 1 << this.mInput.readUnsignedShort();
        if (this.mInput.skipBytes(10) != 10) {
            throw new CorruptDocumentException();
        }
        int SATSize = this.mInput.readInt();
        this.mDirectorySId = this.mInput.readInt();
        if (this.mInput.skipBytes(4) != 4) {
            throw new CorruptDocumentException();
        }
        this.mMinStreamSize = this.mInput.readInt();
        this.mShortSATSID = this.mInput.readInt();
        this.mShortSATSize = this.mInput.readInt();
        int masterSATSId = this.mInput.readInt();
        int masterSATSize = this.mInput.readInt();
        this.mMasterSAT = new int[SATSize];
        int headerSIds = Math.min(SATSize, 109);
        for (int i = 0; i < headerSIds; ++i) {
            this.mMasterSAT[i] = this.mInput.readInt();
        }
        if (masterSATSId == -2) {
            int freeSIdLength = 436 - SATSize * 4;
            if (this.mInput.skipBytes(freeSIdLength) != freeSIdLength) {
                throw new CorruptDocumentException();
            }
        } else {
            this.seekToSId(masterSATSId, -1L);
            int index = headerSIds;
            for (int i = 0; i < masterSATSize; ++i) {
                block5: for (int j = 0; j < 127; ++j) {
                    int sid = this.mInput.readInt();
                    switch (sid) {
                        case -1: {
                            continue block5;
                        }
                        default: {
                            this.mMasterSAT[index++] = sid;
                        }
                    }
                }
                int next = this.mInput.readInt();
                if (next == -2) break;
                this.seekToSId(next, -1L);
            }
        }
    }

    private void readSAT() throws IOException {
        if (this.mSAT != null) {
            return;
        }
        int intsPerSector = this.mSectorSize / 4;
        this.mSAT = new int[this.mMasterSAT.length * intsPerSector];
        for (int i = 0; i < this.mMasterSAT.length; ++i) {
            this.seekToSId(this.mMasterSAT[i], -1L);
            for (int j = 0; j < intsPerSector; ++j) {
                int nextSID = this.mInput.readInt();
                int index = j + i * intsPerSector;
                this.mSAT[index] = nextSID;
            }
        }
        SIdChain chain = this.getSIdChain(this.mShortSATSID, -1L);
        this.mShortSAT = new int[this.mShortSATSize * intsPerSector];
        for (int i = 0; i < this.mShortSATSize; ++i) {
            this.seekToSId(chain.get(i), -1L);
            for (int j = 0; j < intsPerSector; ++j) {
                int nextSID = this.mInput.readInt();
                int index = j + i * intsPerSector;
                this.mShortSAT[index] = nextSID;
            }
        }
    }

    private SIdChain getSIdChain(int pSId, long pStreamSize) throws IOException {
        SIdChain chain = new SIdChain();
        int[] sat = this.isShortStream(pStreamSize) ? this.mShortSAT : this.mSAT;
        int sid = pSId;
        while (sid != -2 && sid != -1) {
            chain.addSID(sid);
            sid = sat[sid];
        }
        return chain;
    }

    private boolean isShortStream(long pStreamSize) {
        return pStreamSize != -1L && pStreamSize < (long)this.mMinStreamSize;
    }

    private void seekToSId(int pSId, long pStreamSize) throws IOException {
        long pos;
        if (this.isShortStream(pStreamSize)) {
            Entry root = this.getRootEntry();
            if (this.mShortStreamSIdChain == null) {
                this.mShortStreamSIdChain = this.getSIdChain(root.startSId, root.streamSize);
            }
            int shortPerStd = this.mSectorSize / this.mShortSectorSize;
            int offset = pSId / shortPerStd;
            int shortOffset = pSId - offset * shortPerStd;
            pos = 512L + (long)this.mShortStreamSIdChain.get(offset) * (long)this.mSectorSize + (long)shortOffset * (long)this.mShortSectorSize;
        } else {
            pos = 512L + (long)pSId * (long)this.mSectorSize;
        }
        if (this.mInput instanceof LittleEndianRandomAccessFile) {
            ((LittleEndianRandomAccessFile)this.mInput).seek(pos);
        } else if (this.mInput instanceof ImageInputStream) {
            ((ImageInputStream)this.mInput).seek(pos);
        } else {
            ((SeekableLittleEndianDataInputStream)this.mInput).seek(pos);
        }
    }

    private void seekToDId(int pDId) throws IOException {
        if (this.mDirectorySIdChain == null) {
            this.mDirectorySIdChain = this.getSIdChain(this.mDirectorySId, -1L);
        }
        int dIdsPerSId = this.mSectorSize / 128;
        int sIdOffset = pDId / dIdsPerSId;
        int dIdOffset = pDId - sIdOffset * dIdsPerSId;
        int sId = this.mDirectorySIdChain.get(sIdOffset);
        this.seekToSId(sId, -1L);
        if (this.mInput instanceof LittleEndianRandomAccessFile) {
            LittleEndianRandomAccessFile input = (LittleEndianRandomAccessFile)this.mInput;
            input.seek(input.getFilePointer() + (long)(dIdOffset * 128));
        } else if (this.mInput instanceof ImageInputStream) {
            ImageInputStream input = (ImageInputStream)this.mInput;
            input.seek(input.getStreamPosition() + (long)(dIdOffset * 128));
        } else {
            SeekableLittleEndianDataInputStream input = (SeekableLittleEndianDataInputStream)this.mInput;
            input.seek(input.getStreamPosition() + (long)(dIdOffset * 128));
        }
    }

    SeekableInputStream getInputStreamForSId(int pStreamId, int pStreamSize) throws IOException {
        SIdChain chain = this.getSIdChain(pStreamId, pStreamSize);
        int sectorSize = pStreamSize < this.mMinStreamSize ? this.mShortSectorSize : this.mSectorSize;
        return new Stream(chain, pStreamSize, sectorSize, this);
    }

    private InputStream getDirectoryStreamForDId(int pDirectoryId) throws IOException {
        byte[] bytes = new byte[128];
        this.seekToDId(pDirectoryId);
        this.mInput.readFully(bytes);
        return new ByteArrayInputStream(bytes);
    }

    Entry getEntry(int pDirectoryId, Entry pParent) throws IOException {
        Entry entry = Entry.readEntry(new LittleEndianDataInputStream(this.getDirectoryStreamForDId(pDirectoryId)));
        entry.mParent = pParent;
        entry.mDocument = this;
        return entry;
    }

    SortedSet<Entry> getEntries(int pDirectoryId, Entry pParent) throws IOException {
        return this.getEntriesRecursive(pDirectoryId, pParent, new TreeSet<Entry>());
    }

    private SortedSet<Entry> getEntriesRecursive(int pDirectoryId, Entry pParent, SortedSet<Entry> pEntries) throws IOException {
        Entry entry = this.getEntry(pDirectoryId, pParent);
        if (!pEntries.add(entry)) {
            throw new CorruptDocumentException("Cyclic chain reference for entry: " + pDirectoryId);
        }
        if (entry.prevDId != -1) {
            this.getEntriesRecursive(entry.prevDId, pParent, pEntries);
        }
        if (entry.nextDId != -1) {
            this.getEntriesRecursive(entry.nextDId, pParent, pEntries);
        }
        return pEntries;
    }

    Entry getEntry(String pPath) throws IOException {
        String pathElement;
        String[] pathElements;
        if (StringUtil.isEmpty(pPath) || !pPath.startsWith("/")) {
            throw new IllegalArgumentException("Path must be absolute, and contain a valid path: " + pPath);
        }
        Entry entry = this.getRootEntry();
        if (pPath.equals("/")) {
            return entry;
        }
        String[] arr$ = pathElements = StringUtil.toStringArray(pPath, "/");
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$ && (entry = entry.getChildEntry(pathElement = arr$[i$])) != null; ++i$) {
        }
        return entry;
    }

    public Entry getRootEntry() throws IOException {
        if (this.mRootEntry == null) {
            this.readSAT();
            this.mRootEntry = this.getEntry(0, null);
            if (this.mRootEntry.type != 5) {
                throw new CorruptDocumentException("Invalid root storage type: " + this.mRootEntry.type);
            }
        }
        return this.mRootEntry;
    }

    public String toString() {
        return String.format("%s[uuid: %s, sector size: %d/%d bytes, directory SID: %d, master SAT: %s entries]", this.getClass().getSimpleName(), this.mUID, this.mSectorSize, this.mShortSectorSize, this.mDirectorySId, this.mMasterSAT.length);
    }

    public static long toJavaTimeInMillis(long pMSTime) {
        if (pMSTime == 0L) {
            return 0L;
        }
        return (pMSTime >> 1) / 5000L + -11644477200000L;
    }

    static class SeekableLittleEndianDataInputStream
    extends LittleEndianDataInputStream
    implements Seekable {
        private final SeekableInputStream mSeekable;

        public SeekableLittleEndianDataInputStream(SeekableInputStream pInput) {
            super(pInput);
            this.mSeekable = pInput;
        }

        public void seek(long pPosition) throws IOException {
            this.mSeekable.seek(pPosition);
        }

        public boolean isCachedFile() {
            return this.mSeekable.isCachedFile();
        }

        public boolean isCachedMemory() {
            return this.mSeekable.isCachedMemory();
        }

        public boolean isCached() {
            return this.mSeekable.isCached();
        }

        public long getStreamPosition() throws IOException {
            return this.mSeekable.getStreamPosition();
        }

        public long getFlushedPosition() throws IOException {
            return this.mSeekable.getFlushedPosition();
        }

        public void flushBefore(long pPosition) throws IOException {
            this.mSeekable.flushBefore(pPosition);
        }

        public void flush() throws IOException {
            this.mSeekable.flush();
        }

        public void reset() throws IOException {
            this.mSeekable.reset();
        }

        public void mark() {
            this.mSeekable.mark();
        }
    }

    static class Stream
    extends SeekableInputStream {
        private SIdChain mChain;
        int mNextSectorPos;
        byte[] mBuffer;
        int mBufferPos;
        private final CompoundDocument mDocument;
        private final long mLength;

        public Stream(SIdChain pChain, long pLength, int pSectorSize, CompoundDocument pDocument) {
            this.mChain = pChain;
            this.mLength = pLength;
            this.mBuffer = new byte[pSectorSize];
            this.mBufferPos = this.mBuffer.length;
            this.mDocument = pDocument;
        }

        public int available() throws IOException {
            return (int)Math.min((long)(this.mBuffer.length - this.mBufferPos), this.mLength - this.getStreamPosition());
        }

        public int read() throws IOException {
            if (this.available() <= 0 && !this.fillBuffer()) {
                return -1;
            }
            return this.mBuffer[this.mBufferPos++] & 0xFF;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean fillBuffer() throws IOException {
            if (this.mNextSectorPos < this.mChain.length()) {
                CompoundDocument compoundDocument = this.mDocument;
                synchronized (compoundDocument) {
                    this.mDocument.seekToSId(this.mChain.get(this.mNextSectorPos), this.mLength);
                    this.mDocument.mInput.readFully(this.mBuffer);
                }
                ++this.mNextSectorPos;
                this.mBufferPos = 0;
                return true;
            }
            return false;
        }

        public int read(byte[] b, int off, int len) throws IOException {
            if (this.available() <= 0 && !this.fillBuffer()) {
                return -1;
            }
            int toRead = Math.min(len, this.available());
            System.arraycopy(this.mBuffer, this.mBufferPos, b, off, toRead);
            this.mBufferPos += toRead;
            return toRead;
        }

        public boolean isCached() {
            return true;
        }

        public boolean isCachedMemory() {
            return false;
        }

        public boolean isCachedFile() {
            return true;
        }

        protected void closeImpl() throws IOException {
            this.mBuffer = null;
            this.mChain = null;
        }

        protected void seekImpl(long pPosition) throws IOException {
            long pos = this.getStreamPosition();
            if (pos - (long)this.mBufferPos >= pPosition && pPosition <= pos + (long)this.available()) {
                this.mBufferPos = (int)((long)this.mBufferPos + (pPosition - pos));
            } else {
                this.mNextSectorPos = (int)(pPosition / (long)this.mBuffer.length);
                if (!this.fillBuffer()) {
                    throw new EOFException();
                }
                this.mBufferPos = (int)(pPosition % (long)this.mBuffer.length);
            }
        }

        protected void flushBeforeImpl(long pPosition) throws IOException {
        }
    }
}

