/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.util;

import com.twelvemonkeys.util.DuplicateHandler;
import com.twelvemonkeys.util.FilterIterator;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CollectionUtil {
    public static void main(String[] pArgs) {
        String str;
        CollectionUtil.test();
        int howMany = 1000;
        if (pArgs.length > 0) {
            howMany = Integer.parseInt(pArgs[0]);
        }
        String[] stringArr1 = new String[]{"zero", "one", "two", "three", "four", "five", "six", "seven", "eight", "nine"};
        stringArr1 = new String[]{"zero", "one", "two", "three", "four", "five", "six", "seven", "eight", "nine", "ten", "eleven", "twelve", "thirteen", "fourteen", "fifteen", "sixteen", "seventeen", "eighteen", "nineteen"};
        System.out.println("\nFilterIterators:\n");
        List<String> list = Arrays.asList(stringArr1);
        FilterIterator<String> iter = new FilterIterator<String>(list.iterator(), new FilterIterator.Filter(){

            public boolean accept(Object pElement) {
                return ((String)pElement).length() > 5;
            }
        });
        while (iter.hasNext()) {
            str = (String)iter.next();
            System.out.println(str + " has more than 5 letters!");
        }
        iter = new FilterIterator<String>(list.iterator(), new FilterIterator.Filter(){

            public boolean accept(Object pElement) {
                return ((String)pElement).length() <= 5;
            }
        });
        while (iter.hasNext()) {
            str = (String)iter.next();
            System.out.println(str + " has less than, or exactly 5 letters!");
        }
        long start = System.currentTimeMillis();
        for (int i = 0; i < howMany; ++i) {
            iter = new FilterIterator<String>(list.iterator(), new FilterIterator.Filter(){

                public boolean accept(Object pElement) {
                    return ((String)pElement).length() <= 5;
                }
            });
            while (iter.hasNext()) {
                iter.next();
                System.out.print("");
            }
        }
    }

    private CollectionUtil() {
    }

    public static Object mergeArrays(Object pArray1, Object pArray2) {
        return CollectionUtil.mergeArrays(pArray1, 0, Array.getLength(pArray1), pArray2, 0, Array.getLength(pArray2));
    }

    public static Object mergeArrays(Object pArray1, int pOffset1, int pLength1, Object pArray2, int pOffset2, int pLength2) {
        Class<?> class1 = pArray1.getClass();
        Class<?> type = class1.getComponentType();
        Object array = Array.newInstance(type, pLength1 + pLength2);
        System.arraycopy(pArray1, pOffset1, array, 0, pLength1);
        System.arraycopy(pArray2, pOffset2, array, pLength1, pLength2);
        return array;
    }

    public static Object subArray(Object pArray, int pStart) {
        return CollectionUtil.subArray(pArray, pStart, -1);
    }

    public static Object subArray(Object pArray, int pStart, int pLength) {
        Object result;
        int newLength;
        if (pArray == null) {
            throw new IllegalArgumentException("array == null");
        }
        if (pStart < 0) {
            throw new ArrayIndexOutOfBoundsException(pStart + " < 0");
        }
        Class<?> type = pArray.getClass().getComponentType();
        if (type == null) {
            throw new IllegalArgumentException("Not an array: " + pArray);
        }
        int originalLength = Array.getLength(pArray);
        int n = newLength = pLength < 0 ? Math.max(0, originalLength - pStart) : Math.min(pLength, Math.max(0, originalLength - pStart));
        if (newLength < originalLength) {
            result = Array.newInstance(type, newLength);
            System.arraycopy(pArray, pStart, result, 0, newLength);
        } else {
            result = pArray;
        }
        return result;
    }

    public static <T> Iterator<T> iterator(final Enumeration<T> pEnum) {
        return new Iterator<T>(){

            @Override
            public boolean hasNext() {
                return pEnum.hasMoreElements();
            }

            @Override
            public T next() {
                return pEnum.nextElement();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static <E> void addAll(Collection<E> pCollection, Iterator<? extends E> pIterator) {
        while (pIterator.hasNext()) {
            pCollection.add(pIterator.next());
        }
    }

    public static <E> ListIterator<E> iterator(E[] pArray) {
        return CollectionUtil.iterator(pArray, 0, pArray.length);
    }

    public static <E> ListIterator<E> iterator(E[] pArray, int pStart, int pLength) {
        return new ArrayIterator<E>(pArray, pStart, pLength);
    }

    public static <K, V> Map<V, K> invert(Map<K, V> pSource) {
        return CollectionUtil.invert(pSource, null, null);
    }

    public static <K, V> Map<V, K> invert(Map<K, V> pSource, Map<V, K> pResult, DuplicateHandler<K> pHandler) {
        if (pSource == null) {
            throw new IllegalArgumentException("source == null");
        }
        Map result = pResult;
        if (result == null) {
            try {
                result = (Map)pSource.getClass().newInstance();
            }
            catch (InstantiationException e) {
            }
            catch (IllegalAccessException e) {
                // empty catch block
            }
            if (result == null) {
                throw new IllegalArgumentException("result == null and source class " + pSource.getClass() + " cannot be instantiated.");
            }
        }
        Set<Map.Entry<K, V>> entries = pSource.entrySet();
        for (Map.Entry<K, V> entry : entries) {
            V newKey = entry.getValue();
            K newValue = entry.getKey();
            if (result.containsKey(newKey)) {
                if (pHandler != null) {
                    newValue = pHandler.resolve(result.get(newKey), newValue);
                } else {
                    throw new IllegalArgumentException("Result would include duplicate keys, but no DuplicateHandler specified.");
                }
            }
            result.put(newKey, newValue);
        }
        return result;
    }

    public static <T> Comparator<T> reverseOrder(Comparator<T> pOriginal) {
        return new ReverseComparator<T>(pOriginal);
    }

    static <T extends Iterator<? super E>, E> T generify(Iterator<?> pIterator, Class<E> pElementType) {
        return (T)pIterator;
    }

    static <T extends Collection<? super E>, E> T generify(Collection<?> pCollection, Class<E> pElementType) {
        return (T)pCollection;
    }

    static <T extends Map<? super K, ? super V>, K, V> T generify(Map<?, ?> pMap, Class<K> pKeyType, Class<V> pValueType) {
        return (T)pMap;
    }

    static <T extends Collection<? super E>, E> T generify2(Collection<?> pCollection) {
        return (T)pCollection;
    }

    static void test() {
        List<String> list = Collections.singletonList("foo");
        HashSet<String> set = new HashSet<String>(list);
        List strs0 = (List)CollectionUtil.generify(list, String.class);
        List objs0 = (List)CollectionUtil.generify(list, String.class);
        try {
            List strs1 = (List)CollectionUtil.generify(set, String.class);
        }
        catch (RuntimeException e) {
            e.printStackTrace();
        }
        try {
            ArrayList strs01 = (ArrayList)CollectionUtil.generify(list, String.class);
        }
        catch (RuntimeException e) {
            e.printStackTrace();
        }
        Set setstr1 = (Set)CollectionUtil.generify(set, String.class);
        Set setobj1 = (Set)CollectionUtil.generify(set, String.class);
        try {
            Set setobj44 = (Set)CollectionUtil.generify(list, String.class);
        }
        catch (RuntimeException e) {
            e.printStackTrace();
        }
        List strs2 = (List)CollectionUtil.generify2(list);
        List objs2 = (List)CollectionUtil.generify2(list);
        try {
            List strs3 = (List)CollectionUtil.generify2(set);
        }
        catch (RuntimeException e) {
            e.printStackTrace();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ArrayIterator<E>
    implements ListIterator<E> {
        private int mIndex;
        private final int mStart;
        private final int mLength;
        private final E[] mArray;

        public ArrayIterator(E[] pArray, int pStart, int pLength) {
            if (pArray == null) {
                throw new IllegalArgumentException("array == null");
            }
            if (pStart < 0) {
                throw new IllegalArgumentException("start < 0");
            }
            if (pLength > pArray.length - pStart) {
                throw new IllegalArgumentException("length > array.length - start");
            }
            this.mArray = pArray;
            this.mStart = pStart;
            this.mLength = pLength;
            this.mIndex = this.mStart;
        }

        @Override
        public boolean hasNext() {
            return this.mIndex < this.mLength + this.mStart;
        }

        @Override
        public E next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            try {
                return this.mArray[this.mIndex++];
            }
            catch (ArrayIndexOutOfBoundsException e) {
                NoSuchElementException nse = new NoSuchElementException(e.getMessage());
                nse.initCause(e);
                throw nse;
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(E pElement) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean hasPrevious() {
            return this.mIndex > this.mStart;
        }

        @Override
        public int nextIndex() {
            return this.mIndex + 1;
        }

        @Override
        public E previous() {
            if (!this.hasPrevious()) {
                throw new NoSuchElementException();
            }
            try {
                return this.mArray[this.mIndex--];
            }
            catch (ArrayIndexOutOfBoundsException e) {
                NoSuchElementException nse = new NoSuchElementException(e.getMessage());
                nse.initCause(e);
                throw nse;
            }
        }

        @Override
        public int previousIndex() {
            return this.mIndex - 1;
        }

        @Override
        public void set(E pElement) {
            this.mArray[this.mIndex] = pElement;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ReverseComparator<T>
    implements Comparator<T> {
        private Comparator<T> mComparator;

        public ReverseComparator(Comparator<T> pComparator) {
            this.mComparator = pComparator;
        }

        @Override
        public int compare(T pLeft, T pRight) {
            int result = this.mComparator.compare(pLeft, pRight);
            return -(result | result >>> 1);
        }
    }
}

