/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.util;

import java.util.Iterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilterIterator<E>
implements Iterator<E> {
    protected final Filter<E> mFilter;
    protected final Iterator<E> mIterator;
    private E mNext = null;
    private E mCurrent = null;

    public FilterIterator(Iterator<E> pIterator, Filter<E> pFilter) {
        if (pIterator == null) {
            throw new IllegalArgumentException("iterator == null");
        }
        if (pFilter == null) {
            throw new IllegalArgumentException("filter == null");
        }
        this.mIterator = pIterator;
        this.mFilter = pFilter;
    }

    @Override
    public boolean hasNext() {
        while (this.mNext == null && this.mIterator.hasNext()) {
            E element = this.mIterator.next();
            if (!this.mFilter.accept(element)) continue;
            this.mNext = element;
            break;
        }
        return this.mNext != null;
    }

    @Override
    public E next() {
        if (this.hasNext()) {
            this.mCurrent = this.mNext;
            this.mNext = null;
            return this.mCurrent;
        }
        throw new NoSuchElementException("Iteration has no more elements.");
    }

    @Override
    public void remove() {
        if (this.mCurrent == null) {
            throw new IllegalStateException("Iteration has no current element.");
        }
        this.mIterator.remove();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Filter<E> {
        public boolean accept(E var1);
    }
}

