/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.util;

import com.twelvemonkeys.util.ExpiringMap;
import com.twelvemonkeys.util.LinkedMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LRUMap<K, V>
extends LinkedMap<K, V>
implements ExpiringMap<K, V> {
    private int mMaxSize = 1000;
    private float mTrimFactor = 0.01f;

    public LRUMap() {
        super(null, true);
    }

    public LRUMap(int pMaxSize) {
        super(null, true);
        this.setMaxSize(pMaxSize);
    }

    public LRUMap(Map<? extends K, ? extends V> pContents) {
        super(pContents, true);
    }

    public LRUMap(Map<? extends K, ? extends V> pContents, int pMaxSize) {
        super(pContents, true);
        this.setMaxSize(pMaxSize);
    }

    public LRUMap(Map<K, Map.Entry<K, V>> pBacking, Map<? extends K, ? extends V> pContents, int pMaxSize) {
        super(pBacking, pContents, true);
        this.setMaxSize(pMaxSize);
    }

    public int getMaxSize() {
        return this.mMaxSize;
    }

    public void setMaxSize(int pMaxSize) {
        if (pMaxSize < 0) {
            throw new IllegalArgumentException("max size must be positive");
        }
        this.mMaxSize = pMaxSize;
        while (this.size() > this.mMaxSize) {
            this.removeLRU();
        }
    }

    public float getTrimFactor() {
        return this.mTrimFactor;
    }

    public void setTrimFactor(float pTrimFactor) {
        if (pTrimFactor < 0.0f || pTrimFactor >= 1.0f) {
            throw new IllegalArgumentException("trim factor must be between 0 and 1");
        }
        this.mTrimFactor = pTrimFactor;
    }

    @Override
    protected boolean removeEldestEntry(Map.Entry pEldest) {
        if (this.size() >= this.mMaxSize) {
            this.removeLRU();
        }
        return false;
    }

    @Override
    protected Map.Entry<K, V> removeEntry(Map.Entry<K, V> pEntry) {
        Map.Entry<K, V> entry = super.removeEntry(pEntry);
        this.processRemoved(pEntry);
        return entry;
    }

    @Override
    public void processRemoved(Map.Entry<K, V> pRemoved) {
    }

    public void removeLRU() {
        int removeCount = (int)Math.max((float)this.size() * this.mTrimFactor, 1.0f);
        while (removeCount-- > 0) {
            this.removeEntry(this.mHead.mNext);
        }
    }
}

