/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.util;

import com.twelvemonkeys.util.TimeFormat;

public class Time {
    private int mTime = -1;
    public static final int SECONDS_IN_MINUTE = 60;

    public Time() {
        this(0);
    }

    public Time(int pTime) {
        this.setTime(pTime);
    }

    public void setTime(int pTime) {
        if (pTime < 0) {
            throw new IllegalArgumentException("Time argument must be 0 or positive!");
        }
        this.mTime = pTime;
    }

    public int getTime() {
        return this.mTime;
    }

    public long getTimeInMillis() {
        return (long)this.mTime * 1000L;
    }

    public void setSeconds(int pSeconds) {
        this.mTime = this.getMinutes() * 60 + pSeconds;
    }

    public int getSeconds() {
        return this.mTime % 60;
    }

    public void setMinutes(int pMinutes) {
        this.mTime = pMinutes * 60 + this.getSeconds();
    }

    public int getMinutes() {
        return this.mTime / 60;
    }

    public String toString() {
        return "" + this.getMinutes() + ":" + (this.getSeconds() < 10 ? "0" : "") + this.getSeconds();
    }

    public String toString(String pFormatStr) {
        TimeFormat tf = new TimeFormat(pFormatStr);
        return tf.format(this);
    }

    public static Time parseTime(String pStr) {
        TimeFormat tf = TimeFormat.getInstance();
        return tf.parse(pStr);
    }
}

