/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.util.convert;

import com.twelvemonkeys.lang.BeanUtil;
import com.twelvemonkeys.lang.StringUtil;
import com.twelvemonkeys.util.convert.ConversionException;
import com.twelvemonkeys.util.convert.NumberConverter;
import com.twelvemonkeys.util.convert.TypeMismathException;
import java.lang.reflect.InvocationTargetException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;

public class DateConverter
extends NumberConverter {
    public Object toObject(String pString, Class pType, String pFormat) throws ConversionException {
        if (StringUtil.isEmpty(pString)) {
            return null;
        }
        try {
            DateFormat format = pFormat == null ? DateFormat.getDateTimeInstance() : this.getDateFormat(pFormat);
            Date date = StringUtil.toDate(pString, format);
            if (pType != Date.class) {
                try {
                    date = (Date)BeanUtil.createInstance(pType, (Object)new Long(date.getTime()));
                }
                catch (ClassCastException e) {
                    throw new TypeMismathException(pType);
                }
                catch (InvocationTargetException e) {
                    throw new ConversionException(e);
                }
            }
            return date;
        }
        catch (RuntimeException rte) {
            throw new ConversionException(rte);
        }
    }

    public String toString(Object pObject, String pFormat) throws ConversionException {
        if (pObject == null) {
            return null;
        }
        if (!(pObject instanceof Date)) {
            throw new TypeMismathException(pObject.getClass());
        }
        try {
            if (StringUtil.isEmpty(pFormat)) {
                return DateFormat.getDateTimeInstance().format(pObject);
            }
            DateFormat format = this.getDateFormat(pFormat);
            return format.format(pObject);
        }
        catch (RuntimeException rte) {
            throw new ConversionException(rte);
        }
    }

    private DateFormat getDateFormat(String pFormat) {
        return (DateFormat)this.getFormat(SimpleDateFormat.class, pFormat);
    }
}

