/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.util.convert;

import com.twelvemonkeys.lang.StringUtil;
import com.twelvemonkeys.util.Time;
import com.twelvemonkeys.util.TimeFormat;
import com.twelvemonkeys.util.convert.ConversionException;
import com.twelvemonkeys.util.convert.NumberConverter;
import com.twelvemonkeys.util.convert.TypeMismathException;

public class TimeConverter
extends NumberConverter {
    public Object toObject(String pString, Class pType, String pFormat) throws ConversionException {
        if (StringUtil.isEmpty(pString)) {
            return null;
        }
        try {
            TimeFormat format = pFormat == null ? TimeFormat.getInstance() : this.getTimeFormat(pFormat);
            return format.parse(pString);
        }
        catch (RuntimeException rte) {
            throw new ConversionException(rte);
        }
    }

    public String toString(Object pObject, String pFormat) throws ConversionException {
        if (pObject == null) {
            return null;
        }
        if (!(pObject instanceof Time)) {
            throw new TypeMismathException(pObject.getClass());
        }
        try {
            if (StringUtil.isEmpty(pFormat)) {
                return pObject.toString();
            }
            TimeFormat format = this.getTimeFormat(pFormat);
            return format.format((Time)pObject);
        }
        catch (RuntimeException rte) {
            throw new ConversionException(rte);
        }
    }

    private TimeFormat getTimeFormat(String pFormat) {
        return (TimeFormat)this.getFormat(TimeFormat.class, pFormat);
    }
}

