/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.util.service;

import com.twelvemonkeys.lang.Validate;
import com.twelvemonkeys.util.FilterIterator;
import com.twelvemonkeys.util.service.RegisterableService;
import com.twelvemonkeys.util.service.ServiceConfigurationError;
import java.io.IOException;
import java.net.URL;
import java.nio.channels.spi.SelectorProvider;
import java.nio.charset.spi.CharsetProvider;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.spi.ImageReaderWriterSpi;
import javax.imageio.spi.ImageWriterSpi;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceRegistry {
    public static final String SERVICES = "META-INF/services/";
    private final Map<Class<?>, CategoryRegistry> mCategoryMap;

    public ServiceRegistry(Iterator<? extends Class<?>> pCategories) {
        Validate.notNull(pCategories, "categories");
        LinkedHashMap map = new LinkedHashMap();
        while (pCategories.hasNext()) {
            this.putCategory(map, pCategories.next());
        }
        this.mCategoryMap = Collections.unmodifiableMap(map);
    }

    private <T> void putCategory(Map<Class<?>, CategoryRegistry> pMap, Class<T> pCategory) {
        CategoryRegistry<T> registry = new CategoryRegistry<T>(pCategory);
        pMap.put(pCategory, registry);
    }

    public void registerApplicationClasspathSPIs() {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        Iterator<Class<?>> categories = this.categories();
        while (categories.hasNext()) {
            Class<?> category = categories.next();
            try {
                String name = SERVICES + category.getName();
                Enumeration<URL> spiResources = loader.getResources(name);
                while (spiResources.hasMoreElements()) {
                    URL resource = spiResources.nextElement();
                    this.registerSPIs(resource, category, loader);
                }
            }
            catch (IOException e) {
                throw new ServiceConfigurationError(e);
            }
        }
    }

    <T> void registerSPIs(URL pResource, Class<T> pCategory, ClassLoader pLoader) {
        Properties classNames = new Properties();
        try {
            classNames.load(pResource.openStream());
        }
        catch (IOException e) {
            throw new ServiceConfigurationError(e);
        }
        if (!classNames.isEmpty()) {
            CategoryRegistry registry = this.mCategoryMap.get(pCategory);
            Set<Object> providerClassNames = classNames.keySet();
            for (Object providerClassName : providerClassNames) {
                String className = (String)providerClassName;
                try {
                    Class<?> providerClass = Class.forName(className, true, pLoader);
                    Object provider = providerClass.newInstance();
                    registry.register(provider);
                }
                catch (ClassNotFoundException e) {
                    throw new ServiceConfigurationError(e);
                }
                catch (IllegalAccessException e) {
                    throw new ServiceConfigurationError(e);
                }
                catch (InstantiationException e) {
                    throw new ServiceConfigurationError(e);
                }
                catch (IllegalArgumentException e) {
                    throw new ServiceConfigurationError(e);
                }
            }
        }
    }

    protected <T> Iterator<T> providers(Class<T> pCategory) {
        return this.getRegistry(pCategory).providers();
    }

    protected Iterator<Class<?>> categories() {
        return this.mCategoryMap.keySet().iterator();
    }

    protected Iterator<Class<?>> compatibleCategories(final Object pProvider) {
        return new FilterIterator(this.categories(), new FilterIterator.Filter<Class<?>>(){

            @Override
            public boolean accept(Class<?> pElement) {
                return pElement.isInstance(pProvider);
            }
        });
    }

    protected Iterator<Class<?>> containingCategories(final Object pProvider) {
        return new FilterIterator<Class<?>>(this.categories(), new FilterIterator.Filter<Class<?>>(){

            @Override
            public boolean accept(Class<?> pElement) {
                return ServiceRegistry.this.getRegistry(pElement).contatins(pProvider);
            }
        }){
            Class<?> mCurrent;

            @Override
            public Class next() {
                this.mCurrent = (Class)super.next();
                return this.mCurrent;
            }

            @Override
            public void remove() {
                if (this.mCurrent == null) {
                    throw new IllegalStateException("No current element");
                }
                ServiceRegistry.this.getRegistry(this.mCurrent).deregister(pProvider);
                this.mCurrent = null;
            }
        };
    }

    private <T> CategoryRegistry<T> getRegistry(Class<T> pCategory) {
        CategoryRegistry registry = this.mCategoryMap.get(pCategory);
        if (registry == null) {
            throw new IllegalArgumentException("No such category: " + pCategory.getName());
        }
        return registry;
    }

    public boolean register(Object pProvider) {
        Iterator<Class<?>> categories = this.compatibleCategories(pProvider);
        boolean registered = false;
        while (categories.hasNext()) {
            Class<?> category = categories.next();
            if (!this.registerImpl(pProvider, category) || registered) continue;
            registered = true;
        }
        return registered;
    }

    private <T> boolean registerImpl(Object pProvider, Class<T> pCategory) {
        return this.getRegistry(pCategory).register(pCategory.cast(pProvider));
    }

    public <T> boolean register(T pProvider, Class<? super T> pCategory) {
        return this.registerImpl(pProvider, pCategory);
    }

    public boolean deregister(Object pProvider) {
        Iterator<Class<?>> categories = this.containingCategories(pProvider);
        boolean deregistered = false;
        while (categories.hasNext()) {
            Class<?> category = categories.next();
            if (!this.deregister(pProvider, category) || deregistered) continue;
            deregistered = true;
        }
        return deregistered;
    }

    public boolean deregister(Object pProvider, Class<?> pCategory) {
        return this.getRegistry(pCategory).deregister(pProvider);
    }

    public static void main(String[] pArgs) {
        abstract class Spi {
            Spi() {
            }
        }
        ServiceRegistry testRegistry = new ServiceRegistry(Arrays.asList(CharsetProvider.class, SelectorProvider.class, ImageReaderSpi.class, ImageWriterSpi.class, Spi.class).iterator());
        testRegistry.registerApplicationClasspathSPIs();
        class One
        extends Spi {
            One() {
            }
        }
        One one = new One();
        class Two
        extends Spi {
            Two() {
            }
        }
        Two two = new Two();
        testRegistry.register(one, Spi.class);
        testRegistry.register(two, Spi.class);
        testRegistry.deregister(one);
        testRegistry.deregister(one, Spi.class);
        testRegistry.deregister(two, Spi.class);
        testRegistry.deregister(two);
        Iterator<Class<?>> categories = testRegistry.categories();
        System.out.println("Categories: ");
        while (categories.hasNext()) {
            Class<?> category = categories.next();
            System.out.println("  " + category.getName() + ":");
            Iterator<?> providers = testRegistry.providers(category);
            Object provider = null;
            while (providers.hasNext()) {
                provider = providers.next();
                System.out.println("    " + provider);
                if (provider instanceof ImageReaderWriterSpi) {
                    System.out.println("    - " + ((ImageReaderWriterSpi)provider).getDescription(null));
                }
                if (!providers.hasNext()) continue;
                providers.remove();
            }
            if (provider != null) {
                Iterator<Class<?>> containers = testRegistry.containingCategories(provider);
                int count = 0;
                while (containers.hasNext()) {
                    if (category != containers.next()) continue;
                    containers.remove();
                    ++count;
                }
                if (count != 1) {
                    System.err.println("Removed " + provider + " from " + count + " categories");
                }
            }
            if (!(providers = testRegistry.providers(category)).hasNext()) {
                System.out.println("All providers successfully deregistered");
            }
            while (providers.hasNext()) {
                System.err.println("Not removed: " + providers.next());
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class CategoryRegistry<T> {
        private final Class<T> mCategory;
        private final Map<Class, T> mProviders = new LinkedHashMap<Class, T>();

        CategoryRegistry(Class<T> pCategory) {
            Validate.notNull(pCategory, "category");
            this.mCategory = pCategory;
        }

        private void checkCategory(Object pProvider) {
            if (!this.mCategory.isInstance(pProvider)) {
                throw new IllegalArgumentException(pProvider + " not instance of category " + this.mCategory.getName());
            }
        }

        public boolean register(T pProvider) {
            this.checkCategory(pProvider);
            if (!this.contatins(pProvider)) {
                this.mProviders.put(pProvider.getClass(), pProvider);
                this.processRegistration(pProvider);
                return true;
            }
            return false;
        }

        void processRegistration(T pProvider) {
            if (pProvider instanceof RegisterableService) {
                RegisterableService service = (RegisterableService)pProvider;
                service.onRegistration(ServiceRegistry.this, this.mCategory);
            }
        }

        public boolean deregister(Object pProvider) {
            this.checkCategory(pProvider);
            T oldProvider = this.mProviders.remove(pProvider.getClass());
            if (oldProvider != null) {
                this.processDeregistration(oldProvider);
                return true;
            }
            return false;
        }

        void processDeregistration(T pOldProvider) {
            if (pOldProvider instanceof RegisterableService) {
                RegisterableService service = (RegisterableService)pOldProvider;
                service.onDeregistration(ServiceRegistry.this, this.mCategory);
            }
        }

        public boolean contatins(Object pProvider) {
            return this.mProviders.containsKey(pProvider.getClass());
        }

        public Iterator<T> providers() {
            final Iterator<T> iterator = this.mProviders.values().iterator();
            return new Iterator<T>(){
                T mCurrent;

                @Override
                public boolean hasNext() {
                    return iterator.hasNext();
                }

                @Override
                public T next() {
                    this.mCurrent = iterator.next();
                    return this.mCurrent;
                }

                @Override
                public void remove() {
                    iterator.remove();
                    CategoryRegistry.this.processDeregistration(this.mCurrent);
                }
            };
        }
    }
}

