/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.chromium;

import com.teamdev.jxbrowser.chromium.internal.ChromiumBuild;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BrowserPreferences {
    public static final String USER_AGENT_PROPERTY = "jxbrowser.chromium.user-agent";
    public static final String CHROMIUM_DIR_PROPERTY = "jxbrowser.chromium.dir";
    private static final Set<String> a = new LinkedHashSet<String>();
    private String b;
    private boolean c;
    private boolean d;
    private boolean e;
    private boolean f;
    private boolean g;
    private boolean h;
    private boolean i;
    private boolean j;
    private boolean k;
    private boolean l;
    private boolean m;
    private boolean n;
    private boolean o;
    private boolean p;

    public static void setChromiumDir(String string) {
        if (string == null) {
            throw new IllegalArgumentException("The chromiumDir parameter cannot be null.");
        }
        if (string.isEmpty()) {
            throw new IllegalArgumentException("The chromiumDir string cannot be empty.");
        }
        System.setProperty(CHROMIUM_DIR_PROPERTY, string);
    }

    public static String getChromiumDir() {
        return System.getProperty(CHROMIUM_DIR_PROPERTY, BrowserPreferences.getDefaultChromiumDir());
    }

    public static void setUserAgent(String string) {
        if (string == null) {
            throw new IllegalArgumentException("The userAgent parameter cannot be null.");
        }
        if (string.isEmpty()) {
            throw new IllegalArgumentException("The userAgent string cannot be empty.");
        }
        System.setProperty(USER_AGENT_PROPERTY, string);
    }

    public static String getUserAgent() {
        return System.getProperty(USER_AGENT_PROPERTY);
    }

    public static String getDefaultChromiumDir() {
        Object object = ChromiumBuild.version();
        String string = System.getProperty("java.io.tmpdir");
        object = "jxbrowser-chromium-" + (String)object;
        object = new File(string, (String)object);
        return ((File)object).getAbsolutePath();
    }

    public static String getDefaultDataDir() {
        File file = new File(BrowserPreferences.getDefaultChromiumDir(), "data");
        return file.getAbsolutePath();
    }

    public static String getDefaultAcceptLanguage() {
        String string = System.getProperty("user.country");
        String string2 = System.getProperty("user.language");
        string = string2 + '-' + string.toLowerCase();
        return string;
    }

    public static void setChromiumSwitches(String ... stringArray) {
        if (stringArray == null) {
            throw new IllegalArgumentException("The switches parameter cannot be null.");
        }
        a.clear();
        Collections.addAll(a, stringArray);
    }

    public static List<String> getChromiumSwitches() {
        return new ArrayList<String>(a);
    }

    public String getDefaultEncoding() {
        return this.b;
    }

    public boolean isJavaScriptEnabled() {
        return this.c;
    }

    public boolean isJavaScriptCanOpenWindowsAutomatically() {
        return this.d;
    }

    public boolean isLoadsImagesAutomatically() {
        return this.f;
    }

    public boolean isImagesEnabled() {
        return this.g;
    }

    public boolean isPluginsEnabled() {
        return this.h;
    }

    public boolean isJavaEnabled() {
        return this.i;
    }

    public boolean isAllowScriptsToCloseWindows() {
        return this.j;
    }

    public boolean isJavaScriptCanAccessClipboard() {
        return this.e;
    }

    public boolean isLocalStorageEnabled() {
        return this.k;
    }

    public boolean isDatabasesEnabled() {
        return this.l;
    }

    public boolean isWebAudioEnabled() {
        return this.m;
    }

    public boolean isApplicationCacheEnabled() {
        return this.n;
    }

    public boolean isAllowDisplayingInsecureContent() {
        return this.o;
    }

    public boolean isAllowRunningInsecureContent() {
        return this.p;
    }

    public void setDefaultEncoding(String string) {
        this.b = string;
    }

    public void setJavaScriptEnabled(boolean bl) {
        this.c = bl;
    }

    public void setJavaScriptCanOpenWindowsAutomatically(boolean bl) {
        this.d = bl;
    }

    public void setLoadsImagesAutomatically(boolean bl) {
        this.f = bl;
    }

    public void setImagesEnabled(boolean bl) {
        this.g = bl;
    }

    public void setPluginsEnabled(boolean bl) {
        this.h = bl;
    }

    public void setJavaEnabled(boolean bl) {
        this.i = bl;
    }

    public void setAllowScriptsToCloseWindows(boolean bl) {
        this.j = bl;
    }

    public void setJavaScriptCanAccessClipboard(boolean bl) {
        this.e = bl;
    }

    public void setLocalStorageEnabled(boolean bl) {
        this.k = bl;
    }

    public void setDatabasesEnabled(boolean bl) {
        this.l = bl;
    }

    public void setWebAudioEnabled(boolean bl) {
        this.m = bl;
    }

    public void setApplicationCacheEnabled(boolean bl) {
        this.n = bl;
    }

    public void setAllowDisplayingInsecureContent(boolean bl) {
        this.o = bl;
    }

    public void setAllowRunningInsecureContent(boolean bl) {
        this.p = bl;
    }
}

