/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.chromium;

import com.teamdev.jxbrowser.chromium.Certificate;
import com.teamdev.jxbrowser.chromium.CertificatesDialogParams;
import com.teamdev.jxbrowser.chromium.CloseStatus;
import com.teamdev.jxbrowser.chromium.DialogHandler;
import com.teamdev.jxbrowser.chromium.DialogParams;
import com.teamdev.jxbrowser.chromium.FileChooserMode;
import com.teamdev.jxbrowser.chromium.FileChooserParams;
import com.teamdev.jxbrowser.chromium.PromptDialogParams;
import com.teamdev.jxbrowser.chromium.ReloadPostDataParams;
import com.teamdev.jxbrowser.chromium.UnloadDialogParams;
import com.teamdev.jxbrowser.chromium.p;
import java.awt.Component;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class DefaultDialogHandler
implements DialogHandler {
    public void onAlert(DialogParams object) {
        Object object2 = ((DialogParams)object).getURL();
        object2 = "The page at " + (String)object2 + " says:";
        String string = ((DialogParams)object).getMessage();
        object = ((DialogParams)object).getBrowser().getView().getComponent();
        JOptionPane.showMessageDialog((Component)object, string, (String)object2, -1);
    }

    public CloseStatus onConfirmation(DialogParams object) {
        Object object2 = ((DialogParams)object).getURL();
        object2 = "The page at " + (String)object2 + " says:";
        String string = ((DialogParams)object).getMessage();
        int n2 = JOptionPane.showConfirmDialog((Component)(object = ((DialogParams)object).getBrowser().getView().getComponent()), string, (String)object2, 2, -1);
        if (n2 == 0) {
            return CloseStatus.OK;
        }
        return CloseStatus.CANCEL;
    }

    public CloseStatus onPrompt(PromptDialogParams promptDialogParams) {
        Object object = promptDialogParams.getURL();
        object = "The page at " + (String)object + " says:";
        Object[] objectArray = promptDialogParams.getMessage();
        JTextField jTextField = new JTextField(promptDialogParams.getPromptText());
        objectArray = new Object[]{new JLabel((String)objectArray), jTextField};
        JComponent jComponent = promptDialogParams.getBrowser().getView().getComponent();
        int n2 = JOptionPane.showConfirmDialog(jComponent, objectArray, (String)object, 2, -1);
        if (n2 == 0) {
            promptDialogParams.setPromptText(jTextField.getText());
            return CloseStatus.OK;
        }
        return CloseStatus.CANCEL;
    }

    public CloseStatus onFileChooser(FileChooserParams fileChooserParams) {
        boolean bl;
        boolean bl2 = fileChooserParams.getMode() == FileChooserMode.Open;
        boolean bl3 = bl = fileChooserParams.getMode() == FileChooserMode.OpenMultiple;
        if (bl2 || bl) {
            JFileChooser jFileChooser = new JFileChooser();
            jFileChooser.setMultiSelectionEnabled(bl);
            jFileChooser.setDialogTitle("Open");
            JComponent jComponent = fileChooserParams.getBrowser().getView().getComponent();
            AtomicInteger atomicInteger = new AtomicInteger(1);
            try {
                SwingUtilities.invokeAndWait(new p((DefaultDialogHandler)fileArray, atomicInteger, jFileChooser, jComponent));
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new RuntimeException(invocationTargetException);
            }
            if (atomicInteger.get() == 0) {
                if (bl) {
                    File[] fileArray = jFileChooser.getSelectedFiles();
                    fileChooserParams.setSelectedFiles(fileArray);
                } else {
                    fileChooserParams.setSelectedFiles(jFileChooser.getSelectedFile());
                }
                return CloseStatus.OK;
            }
        }
        return CloseStatus.CANCEL;
    }

    public CloseStatus onBeforeUnload(UnloadDialogParams unloadDialogParams) {
        int n2;
        Object object = "Confirm Navigation";
        String string = unloadDialogParams.getMessage();
        JComponent jComponent = unloadDialogParams.getBrowser().getView().getComponent();
        Object[] objectArray = new Object[]{"Leave this Page", "Stay on this Page"};
        if (unloadDialogParams.isReload()) {
            object = "Confirm Reload";
            objectArray = new Object[]{"Reload this Page", "Don't Reload"};
        }
        if ((n2 = JOptionPane.showOptionDialog(jComponent, string, (String)object, 2, -1, null, objectArray, objectArray[0])) == 0) {
            return CloseStatus.OK;
        }
        return CloseStatus.CANCEL;
    }

    public CloseStatus onSelectCertificate(CertificatesDialogParams certificatesDialogParams) {
        Object object = certificatesDialogParams.getBrowser().getView().getComponent();
        String string = "Select a certificate to authenticate yourself to " + certificatesDialogParams.getHostPortPair().getHostPort();
        Object[] objectArray = certificatesDialogParams.getCertificates();
        if (!objectArray.isEmpty() && (object = JOptionPane.showInputDialog((Component)object, string, "Select a certificate", -1, null, objectArray = objectArray.toArray(), objectArray[0])) != null) {
            certificatesDialogParams.setSelectedCertificate((Certificate)object);
            return CloseStatus.OK;
        }
        return CloseStatus.CANCEL;
    }

    public CloseStatus onReloadPostData(ReloadPostDataParams object) {
        JComponent jComponent = ((ReloadPostDataParams)object).getBrowser().getView().getComponent();
        object = "Confirm Form Resubmission";
        String string = "The page that you're looking for used information that you entered.\nReturning to that page might cause any action you took to be repeated.\nDo you want to continue?";
        Object[] objectArray = new Object[]{"Continue", "Cancel"};
        int n2 = JOptionPane.showOptionDialog(jComponent, string, (String)object, 2, -1, null, objectArray, objectArray[0]);
        if (n2 == 0) {
            return CloseStatus.OK;
        }
        return CloseStatus.CANCEL;
    }
}

