/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.chromium.dom.internal;

import com.teamdev.jxbrowser.chromium.XPathResult;
import com.teamdev.jxbrowser.chromium.XPathResultType;
import com.teamdev.jxbrowser.chromium.dom.DOMDocument;
import com.teamdev.jxbrowser.chromium.dom.DOMElement;
import com.teamdev.jxbrowser.chromium.dom.DOMNode;
import com.teamdev.jxbrowser.chromium.dom.internal.DOMContext;
import com.teamdev.jxbrowser.chromium.dom.internal.DOMFactory;
import com.teamdev.jxbrowser.chromium.dom.internal.NodePtr;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.CreateElementMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.CreateTextNodeMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.EvaluateXPathMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.GetDocumentElementMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.GetElementByIdMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.GetElementsMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.MessageUIDGenerator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Document
extends NodePtr
implements DOMDocument {
    public Document(long l2, DOMFactory dOMFactory, DOMContext dOMContext) {
        super(l2, dOMFactory, dOMContext);
    }

    @Override
    public synchronized DOMElement getDocumentElement() {
        GetDocumentElementMessage getDocumentElementMessage = this.post(new GetDocumentElementMessage(MessageUIDGenerator.generate(), this.getPtr(), 0L));
        long l2 = getDocumentElementMessage.getElementPtr();
        if (l2 != 0L) {
            return this.getFactory().createElement(l2);
        }
        return null;
    }

    @Override
    public synchronized List<DOMNode> getElementsByTagName(String string) {
        return this.a(GetElementsMessage.Flag.GetElementsByTagName, string);
    }

    private List<DOMNode> a(GetElementsMessage.Flag object, String string) {
        object = this.post(new GetElementsMessage(MessageUIDGenerator.generate(), (GetElementsMessage.Flag)((Object)object), this.getPtr(), string, ""));
        object = ((GetElementsMessage)object).getElementPointers();
        return this.getFactory().createNodes((String)object);
    }

    @Override
    public synchronized List<DOMNode> getElementsByName(String string) {
        return this.a(GetElementsMessage.Flag.GetElementsByName, string);
    }

    @Override
    public synchronized List<DOMNode> getElementsByClassName(String string) {
        return this.a(GetElementsMessage.Flag.GetElementsByClassName, string);
    }

    @Override
    public synchronized DOMElement createElement(String object) {
        if (object == null || ((String)object).isEmpty()) {
            throw new IllegalArgumentException("The tagName parameter cannot be null or empty.");
        }
        object = this.post(new CreateElementMessage(MessageUIDGenerator.generate(), this.getPtr(), (String)object, 0L));
        long l2 = ((CreateElementMessage)object).getElementPtr();
        if (l2 != 0L) {
            return this.getFactory().createElement(l2);
        }
        return null;
    }

    @Override
    public synchronized DOMNode createTextNode() {
        return this.a(null);
    }

    @Override
    public synchronized DOMNode createTextNode(String string) {
        if (string == null || string.isEmpty()) {
            throw new IllegalArgumentException("The text parameter cannot be null or empty.");
        }
        return this.a(string);
    }

    @Override
    public XPathResult evaluate(String string) {
        DOMElement dOMElement = this.getDocumentElement();
        if (dOMElement == null) {
            throw new IllegalStateException("The document element is not available.");
        }
        return this.evaluate(string, dOMElement, XPathResultType.ANY_TYPE);
    }

    @Override
    public XPathResult evaluate(String object, DOMNode dOMNode, XPathResultType xPathResultType) {
        if (object == null || ((String)object).isEmpty()) {
            throw new IllegalArgumentException("The expression parameter cannot be null or empty.");
        }
        if (dOMNode == null) {
            throw new IllegalArgumentException("The contextNode parameter cannot be null.");
        }
        if (xPathResultType == null) {
            throw new IllegalArgumentException("The type parameter cannot be null.");
        }
        long l2 = ((NodePtr)((Object)dOMNode)).getPtr();
        object = this.post(new EvaluateXPathMessage(MessageUIDGenerator.generate(), (String)object, l2, 0L, xPathResultType.getValue()));
        return new XPathResult(this.getChannel(), this.getFactory(), ((EvaluateXPathMessage)object).getResultId(), ((EvaluateXPathMessage)object).getErrorMsg());
    }

    private DOMNode a(String object) {
        object = this.post(new CreateTextNodeMessage(MessageUIDGenerator.generate(), this.getPtr(), (String)object, 0L));
        long l2 = ((CreateTextNodeMessage)object).getElementPtr();
        if (l2 != 0L) {
            return this.getFactory().createElement(l2);
        }
        return null;
    }

    @Override
    public synchronized DOMElement getElementById(String object) {
        if (object == null || ((String)object).isEmpty()) {
            throw new IllegalArgumentException("The elementId parameter cannot be null or empty.");
        }
        object = this.post(new GetElementByIdMessage(MessageUIDGenerator.generate(), this.getPtr(), (String)object, 0L));
        long l2 = ((GetElementByIdMessage)object).getElementPtr();
        if (l2 != 0L) {
            return this.getFactory().createElement(l2);
        }
        return null;
    }
}

