/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.chromium.internal;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class BrowserTransferable
implements Transferable {
    private final Map<DataFlavor, Object> a = new HashMap<DataFlavor, Object>();

    public BrowserTransferable(String string) {
        if (string == null) {
            throw new IllegalArgumentException("The urlData parameter cannot be null");
        }
        try {
            this.a.put(new DataFlavor("text/plain; class=java.lang.String; charset=Unicode"), string);
            this.a.put(DataFlavor.stringFlavor, string);
            return;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new RuntimeException("Transferable construction failed.", classNotFoundException);
        }
    }

    public BrowserTransferable(URL uRL) {
        if (uRL == null) {
            throw new IllegalArgumentException("The urlData parameter cannot be null");
        }
        try {
            this.a.put(new DataFlavor("application/x-java-url; class=java.net.URL"), uRL);
            this.a.put(new DataFlavor("text/plain; class=java.lang.String; charset=Unicode"), uRL.toString());
            this.a.put(DataFlavor.stringFlavor, uRL.toString());
            return;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new RuntimeException("Transferable construction failed.", classNotFoundException);
        }
    }

    public DataFlavor[] getTransferDataFlavors() {
        Set<DataFlavor> set = ((BrowserTransferable)((Object)set)).a.keySet();
        return set.toArray(new DataFlavor[set.size()]);
    }

    public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
        return this.a.keySet().contains(dataFlavor);
    }

    public Object getTransferData(DataFlavor dataFlavor) {
        if (!this.a.keySet().contains(dataFlavor)) {
            throw new UnsupportedFlavorException(dataFlavor);
        }
        return this.a.get(dataFlavor);
    }
}

