/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.chromium.internal;

import com.teamdev.jxbrowser.chromium.Cookie;
import com.teamdev.jxbrowser.chromium.CookieStorage;
import com.teamdev.jxbrowser.chromium.internal.CookieParser;
import com.teamdev.jxbrowser.chromium.internal.ipc.Channel;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.FlushCookiesMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.GetCookiesMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.MessageUIDGenerator;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.ModifyCookiesMessage;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChannelCookieStorage
implements CookieStorage {
    private final Channel a;

    public ChannelCookieStorage(Channel channel) {
        this.a = channel;
    }

    @Override
    public synchronized List<Cookie> getAllCookies() {
        GetCookiesMessage getCookiesMessage = ((ChannelCookieStorage)((Object)getCookiesMessage)).a.post(new GetCookiesMessage("", ""));
        return CookieParser.cookiesFromString(getCookiesMessage.getCookies());
    }

    @Override
    public synchronized List<Cookie> getAllCookies(String string) {
        GetCookiesMessage getCookiesMessage = ((ChannelCookieStorage)((Object)getCookiesMessage)).a.post(new GetCookiesMessage(string, ""));
        return CookieParser.cookiesFromString(getCookiesMessage.getCookies());
    }

    @Override
    public synchronized boolean delete(Cookie cookie) {
        int n2 = ModifyCookiesMessage.FlagType.DeleteCookie.getValue();
        ModifyCookiesMessage modifyCookiesMessage = ((ChannelCookieStorage)((Object)modifyCookiesMessage)).a.post(new ModifyCookiesMessage(MessageUIDGenerator.generate(), n2, "", 0L, 0L, cookie.getName(), cookie.getValue(), cookie.getDomain(), cookie.getPath(), cookie.getCreationTime(), cookie.getExpirationTime(), cookie.isSecure(), cookie.isHTTPOnly(), false, 0));
        return modifyCookiesMessage.isSuccess();
    }

    @Override
    public synchronized int deleteAll() {
        int n2 = ModifyCookiesMessage.FlagType.DeleteAll.getValue();
        ModifyCookiesMessage modifyCookiesMessage = ((ChannelCookieStorage)((Object)modifyCookiesMessage)).a.post(new ModifyCookiesMessage(MessageUIDGenerator.generate(), n2, "", 0L, 0L, "", "", "", "", 0L, 0L, false, false, false, 0));
        return modifyCookiesMessage.getNumDeleted();
    }

    @Override
    public synchronized boolean setCookie(String string, String string2, String string3, String string4, String string5, long l2, boolean bl, boolean bl2) {
        int n2 = ModifyCookiesMessage.FlagType.SetCookie.getValue();
        ModifyCookiesMessage modifyCookiesMessage = ((ChannelCookieStorage)((Object)modifyCookiesMessage)).a.post(new ModifyCookiesMessage(MessageUIDGenerator.generate(), n2, string, 0L, 0L, string2, string3, string4, string5, 0L, l2, bl, bl2, false, 0));
        return modifyCookiesMessage.isSuccess();
    }

    @Override
    public synchronized boolean setSessionCookie(String string, String string2, String string3, String string4, String string5, boolean bl, boolean bl2) {
        return this.setCookie(string, string2, string3, string4, string5, 0L, bl, bl2);
    }

    @Override
    public synchronized void save() {
        this.a.post(new FlushCookiesMessage(MessageUIDGenerator.generate()));
    }
}

