/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.chromium.internal;

import com.teamdev.jxbrowser.chromium.LoggerProvider;
import com.teamdev.jxbrowser.chromium.internal.ChromiumExtractorException;
import com.teamdev.jxbrowser.chromium.internal.Environment;
import com.teamdev.jxbrowser.chromium.internal.FileUtil;
import com.teamdev.jxbrowser.chromium.internal.au;
import java.io.File;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.logging.Logger;

public abstract class ChromiumExtractor {
    private static final Logger a = LoggerProvider.getBrowserLogger();

    public static ChromiumExtractor create() {
        if (Environment.isWindows()) {
            return new f(null);
        }
        if (Environment.isMac()) {
            return new b(null);
        }
        if (Environment.isLinux() && Environment.is32Bit()) {
            return new e(null);
        }
        if (Environment.isLinux() && Environment.is64Bit()) {
            return new d(null);
        }
        throw new IllegalStateException("Unsupported operating system.");
    }

    public void extract(String object) {
        object = new File((String)object);
        try {
            AccessController.doPrivileged(new au(this, (File)object));
            return;
        }
        catch (Exception exception) {
            throw new ChromiumExtractorException("Failed to extract chromium binaries into " + ((File)object).getAbsoluteFile(), exception);
        }
    }

    public boolean shouldExtract(String string) {
        return !FileUtil.allFilesExist(new File(string), this.getChromiumFiles());
    }

    protected abstract String getArchiveName();

    protected abstract String[] getChromiumFiles();

    static /* synthetic */ Logger a() {
        return a;
    }

    static /* synthetic */ void b(File file) {
        a.info("Restore permissions for file: " + file.getAbsolutePath());
        if (!file.setExecutable(true, false)) {
            throw new RuntimeException("Failed to update permissions for file: " + file.getAbsolutePath());
        }
    }

    private static final class d
    extends c {
        private d() {
            super(null);
        }

        protected final String getArchiveName() {
            return "/chromium-linux64.zip";
        }

        /* synthetic */ d(au au2) {
            this();
        }
    }

    private static final class e
    extends c {
        private e() {
            super(null);
        }

        protected final String getArchiveName() {
            return "/chromium-linux32.zip";
        }

        /* synthetic */ e(au au2) {
            this();
        }
    }

    private static abstract class c
    extends ChromiumExtractor
    implements a {
        private c() {
        }

        protected String[] getChromiumFiles() {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add("locales");
            arrayList.add("jxbrowser-chromium");
            arrayList.add("libjxbrowser-chromium-lib.so");
            arrayList.add("libjxbrowser-common.so");
            arrayList.add("icudtl.dat");
            arrayList.add("libpdf.so");
            arrayList.add("libffmpegsumo.so");
            arrayList.add("resources.pak");
            arrayList.add("chrome_100_percent.pak");
            arrayList.add("devtools_resources.pak");
            arrayList.add("webui_resources.pak");
            return arrayList.toArray(new String[arrayList.size()]);
        }

        public final void a(File file) {
            ChromiumExtractor.b(new File(file, "jxbrowser-chromium"));
        }

        /* synthetic */ c(au au2) {
            this();
        }
    }

    private static final class b
    extends ChromiumExtractor
    implements a {
        private b() {
        }

        protected final String getArchiveName() {
            return "/chromium-mac.zip";
        }

        protected final String[] getChromiumFiles() {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add("jxbrowser.app");
            arrayList.add("libjxbrowser-common32.dylib");
            arrayList.add("libjxbrowser-common64.dylib");
            return arrayList.toArray(new String[arrayList.size()]);
        }

        public final void a(File file) {
            ChromiumExtractor.b(new File(file, "jxbrowser.app/Contents/MacOS/jxbrowser"));
            ChromiumExtractor.b(new File(file, "jxbrowser.app/Contents/Frameworks/jxbrowser-helper.app/Contents/MacOS/jxbrowser-helper"));
            ChromiumExtractor.b(new File(file, "jxbrowser.app/Contents/Frameworks/jxbrowser-helper NP.app/Contents/MacOS/jxbrowser-helper NP"));
            ChromiumExtractor.b(new File(file, "jxbrowser.app/Contents/Frameworks/jxbrowser-helper EH.app/Contents/MacOS/jxbrowser-helper EH"));
        }

        /* synthetic */ b(au au2) {
            this();
        }
    }

    private static final class f
    extends ChromiumExtractor {
        private f() {
        }

        protected final String getArchiveName() {
            return "/chromium-windows.zip";
        }

        protected final String[] getChromiumFiles() {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add("locales");
            arrayList.add("ffmpegsumo.dll");
            arrayList.add("jxbrowser-chromium.exe");
            arrayList.add("jxbrowser-chromium-lib.dll");
            arrayList.add("jxbrowser-common32.dll");
            arrayList.add("jxbrowser-common64.dll");
            arrayList.add("pdf.dll");
            arrayList.add("libEGL.dll");
            arrayList.add("libGLESv2.dll");
            arrayList.add("d3dcompiler_46.dll");
            arrayList.add("resources.pak");
            arrayList.add("chrome_100_percent.pak");
            arrayList.add("devtools_resources.pak");
            arrayList.add("webui_resources.pak");
            return arrayList.toArray(new String[arrayList.size()]);
        }

        /* synthetic */ f(au au2) {
            this();
        }
    }

    private static interface a {
        public void a(File var1);
    }
}

